/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.clickhouse;

import java.io.Serializable;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VarcharType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;
import xenon.clickhouse.exception.CHClientException;
import xenon.clickhouse.exception.CHClientException$;

public final class SchemaUtils$ {
    public static SchemaUtils$ MODULE$;
    private final Regex arrayTypePattern;
    private final Regex mapTypePattern;
    private final Regex dateTypePattern;
    private final Regex dateTimeTypePattern;
    private final Regex decimalTypePattern;
    private final Regex decimalTypePattern2;
    private final Regex enumTypePattern;
    private final Regex fixedStringTypePattern;
    private final Regex nullableTypePattern;
    private final Regex lowCardinalityTypePattern;

    static {
        new SchemaUtils$();
    }

    public Regex arrayTypePattern() {
        return this.arrayTypePattern;
    }

    public Regex mapTypePattern() {
        return this.mapTypePattern;
    }

    public Regex dateTypePattern() {
        return this.dateTypePattern;
    }

    public Regex dateTimeTypePattern() {
        return this.dateTimeTypePattern;
    }

    public Regex decimalTypePattern() {
        return this.decimalTypePattern;
    }

    public Regex decimalTypePattern2() {
        return this.decimalTypePattern2;
    }

    public Regex enumTypePattern() {
        return this.enumTypePattern;
    }

    public Regex fixedStringTypePattern() {
        return this.fixedStringTypePattern;
    }

    public Regex nullableTypePattern() {
        return this.nullableTypePattern;
    }

    public Regex lowCardinalityTypePattern() {
        return this.lowCardinalityTypePattern;
    }

    public Tuple2<DataType, Object> fromClickHouseType(String chType) {
        StringType$ stringType$;
        Option option;
        Option option2;
        Tuple2<String, Object> tuple2 = this.unwrapNullable(this.unwrapLowCardinalityTypePattern(chType));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String unwrappedChType = (String)tuple2._1();
        boolean nullable = tuple2._2$mcZ$sp();
        Tuple2 tuple22 = new Tuple2((Object)unwrappedChType, (Object)BoxesRunTime.boxToBoolean((boolean)nullable));
        Tuple2 tuple23 = tuple22;
        String unwrappedChType2 = (String)tuple23._1();
        boolean nullable2 = tuple23._2$mcZ$sp();
        String string = unwrappedChType2;
        boolean bl = "String".equals(string) ? true : ("UUID".equals(string) ? true : (!(option2 = this.fixedStringTypePattern().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(0) == 0 ? true : !(option = this.enumTypePattern().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0));
        if (bl) {
            stringType$ = StringType$.MODULE$;
        } else if ("Int8".equals(string)) {
            stringType$ = ByteType$.MODULE$;
        } else {
            boolean bl2 = "UInt8".equals(string) ? true : "Int16".equals(string);
            if (bl2) {
                stringType$ = ShortType$.MODULE$;
            } else {
                boolean bl3 = "UInt16".equals(string) ? true : "Int32".equals(string);
                if (bl3) {
                    stringType$ = IntegerType$.MODULE$;
                } else {
                    boolean bl4 = "UInt32".equals(string) ? true : ("Int64".equals(string) ? true : ("UInt64".equals(string) ? true : "IPv4".equals(string)));
                    if (bl4) {
                        stringType$ = LongType$.MODULE$;
                    } else {
                        boolean bl5 = "Int128".equals(string) ? true : ("Int256".equals(string) ? true : "UInt256".equals(string));
                        if (bl5) {
                            throw new CHClientException(new StringBuilder(18).append("unsupported type: ").append(chType).toString(), CHClientException$.MODULE$.apply$default$2(), CHClientException$.MODULE$.apply$default$3());
                        }
                        if ("Float32".equals(string)) {
                            stringType$ = FloatType$.MODULE$;
                        } else if ("Float64".equals(string)) {
                            stringType$ = DoubleType$.MODULE$;
                        } else {
                            Option option3 = this.dateTypePattern().unapplySeq((CharSequence)string);
                            if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(0) == 0) {
                                stringType$ = DateType$.MODULE$;
                            } else {
                                Option option4 = this.dateTimeTypePattern().unapplySeq((CharSequence)string);
                                if (!option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(3) == 0) {
                                    stringType$ = TimestampType$.MODULE$;
                                } else {
                                    Option option5 = this.decimalTypePattern().unapplySeq((CharSequence)string);
                                    if (!option5.isEmpty() && option5.get() != null && ((LinearSeqOptimized)option5.get()).lengthCompare(2) == 0) {
                                        String precision = (String)((LinearSeqOptimized)option5.get()).apply(0);
                                        String scale = (String)((LinearSeqOptimized)option5.get()).apply(1);
                                        stringType$ = new DecimalType(new StringOps(Predef$.MODULE$.augmentString(precision)).toInt(), new StringOps(Predef$.MODULE$.augmentString(scale)).toInt());
                                    } else {
                                        Option option6 = this.decimalTypePattern2().unapplySeq((CharSequence)string);
                                        if (!option6.isEmpty() && option6.get() != null && ((LinearSeqOptimized)option6.get()).lengthCompare(2) == 0) {
                                            DecimalType decimalType;
                                            String w = (String)((LinearSeqOptimized)option6.get()).apply(0);
                                            String scale = (String)((LinearSeqOptimized)option6.get()).apply(1);
                                            String string2 = w;
                                            if ("32".equals(string2)) {
                                                decimalType = new DecimalType(9, new StringOps(Predef$.MODULE$.augmentString(scale)).toInt());
                                            } else if ("64".equals(string2)) {
                                                decimalType = new DecimalType(18, new StringOps(Predef$.MODULE$.augmentString(scale)).toInt());
                                            } else if ("128".equals(string2)) {
                                                decimalType = new DecimalType(38, new StringOps(Predef$.MODULE$.augmentString(scale)).toInt());
                                            } else if ("256".equals(string2)) {
                                                decimalType = new DecimalType(76, new StringOps(Predef$.MODULE$.augmentString(scale)).toInt());
                                            } else {
                                                throw new MatchError((Object)string2);
                                            }
                                            stringType$ = decimalType;
                                        } else {
                                            Option option7 = this.arrayTypePattern().unapplySeq((CharSequence)string);
                                            if (!option7.isEmpty() && option7.get() != null && ((LinearSeqOptimized)option7.get()).lengthCompare(1) == 0) {
                                                String nestedChType = (String)((LinearSeqOptimized)option7.get()).apply(0);
                                                Tuple2<DataType, Object> tuple24 = this.fromClickHouseType(nestedChType);
                                                if (tuple24 == null) {
                                                    throw new MatchError(tuple24);
                                                }
                                                DataType _type = (DataType)tuple24._1();
                                                boolean _nullable = tuple24._2$mcZ$sp();
                                                Tuple2 tuple25 = new Tuple2((Object)_type, (Object)BoxesRunTime.boxToBoolean((boolean)_nullable));
                                                Tuple2 tuple26 = tuple25;
                                                DataType _type2 = (DataType)tuple26._1();
                                                boolean _nullable2 = tuple26._2$mcZ$sp();
                                                stringType$ = new ArrayType(_type2, _nullable2);
                                            } else {
                                                Option option8 = this.mapTypePattern().unapplySeq((CharSequence)string);
                                                if (!option8.isEmpty() && option8.get() != null && ((LinearSeqOptimized)option8.get()).lengthCompare(2) == 0) {
                                                    String keyChType = (String)((LinearSeqOptimized)option8.get()).apply(0);
                                                    String valueChType = (String)((LinearSeqOptimized)option8.get()).apply(1);
                                                    Tuple2<DataType, Object> tuple27 = this.fromClickHouseType(keyChType);
                                                    if (tuple27 == null) {
                                                        throw new MatchError(tuple27);
                                                    }
                                                    DataType _keyType = (DataType)tuple27._1();
                                                    boolean _keyNullable = tuple27._2$mcZ$sp();
                                                    Tuple2 tuple28 = new Tuple2((Object)_keyType, (Object)BoxesRunTime.boxToBoolean((boolean)_keyNullable));
                                                    Tuple2 tuple29 = tuple28;
                                                    DataType _keyType2 = (DataType)tuple29._1();
                                                    boolean _keyNullable2 = tuple29._2$mcZ$sp();
                                                    Predef$.MODULE$.require(!_keyNullable2, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Illegal type: ").append(keyChType).append(", the key type of Map should not be nullable").toString());
                                                    Tuple2<DataType, Object> tuple210 = this.fromClickHouseType(valueChType);
                                                    if (tuple210 == null) {
                                                        throw new MatchError(tuple210);
                                                    }
                                                    DataType _valueType = (DataType)tuple210._1();
                                                    boolean _valueNullable = tuple210._2$mcZ$sp();
                                                    Tuple2 tuple211 = new Tuple2((Object)_valueType, (Object)BoxesRunTime.boxToBoolean((boolean)_valueNullable));
                                                    Tuple2 tuple212 = tuple211;
                                                    DataType _valueType2 = (DataType)tuple212._1();
                                                    boolean _valueNullable2 = tuple212._2$mcZ$sp();
                                                    stringType$ = new MapType(_keyType2, _valueType2, _valueNullable2);
                                                } else {
                                                    throw new CHClientException(new StringBuilder(18).append("Unsupported type: ").append(chType).toString(), CHClientException$.MODULE$.apply$default$2(), CHClientException$.MODULE$.apply$default$3());
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        StringType$ catalystType = stringType$;
        return new Tuple2((Object)catalystType, (Object)BoxesRunTime.boxToBoolean((boolean)nullable2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toClickHouseType(DataType catalystType) {
        DecimalType decimalType;
        Option option;
        DataType dataType = catalystType;
        if (BooleanType$.MODULE$.equals(dataType)) {
            return "UInt8";
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return "Int8";
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return "Int16";
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return "Int32";
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return "Int64";
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return "Float32";
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return "Float64";
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return "String";
        }
        if (dataType instanceof VarcharType) {
            return "String";
        }
        if (dataType instanceof CharType) {
            return "String";
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return "Date";
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            return "DateTime";
        }
        if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
            int p = ((Tuple2)option.get())._1$mcI$sp();
            int s = ((Tuple2)option.get())._2$mcI$sp();
            return new StringBuilder(11).append("Decimal(").append(p).append(", ").append(s).append(")").toString();
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType elemType = arrayType.elementType();
            boolean nullable = arrayType.containsNull();
            return new StringBuilder(7).append("Array(").append(this.maybeNullable(this.toClickHouseType(elemType), nullable)).append(")").toString();
        }
        if (!(dataType instanceof MapType)) throw new CHClientException(new StringBuilder(18).append("Unsupported type: ").append(catalystType).toString(), CHClientException$.MODULE$.apply$default$2(), CHClientException$.MODULE$.apply$default$3());
        MapType mapType = (MapType)dataType;
        DataType keyType = mapType.keyType();
        DataType valueType = mapType.valueType();
        boolean nullable = mapType.valueContainsNull();
        if (!(keyType instanceof StringType)) throw new CHClientException(new StringBuilder(18).append("Unsupported type: ").append(catalystType).toString(), CHClientException$.MODULE$.apply$default$2(), CHClientException$.MODULE$.apply$default$3());
        return new StringBuilder(6).append("Map(").append(this.toClickHouseType(keyType)).append(",").append(this.maybeNullable(this.toClickHouseType(valueType), nullable)).append(")").toString();
    }

    public StructType fromClickHouseSchema(Seq<Tuple2<String, String>> chSchema) {
        Seq structFields = (Seq)chSchema.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            String name;
            Tuple2 tuple22 = x0$1;
            if (tuple22 != null) {
                name = (String)tuple22._1();
                String maybeNullableType = (String)tuple22._2();
                Tuple2<DataType, Object> tuple23 = MODULE$.fromClickHouseType(maybeNullableType);
                if (tuple23 == null) {
                    throw new MatchError(tuple23);
                }
                DataType catalyst = (DataType)tuple23._1();
                boolean nullable = tuple23._2$mcZ$sp();
                tuple2 = new Tuple2((Object)catalyst, (Object)BoxesRunTime.boxToBoolean((boolean)nullable));
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple24 = tuple2;
            DataType catalyst = (DataType)tuple24._1();
            boolean nullable = tuple24._2$mcZ$sp();
            StructField structField = new StructField(name, catalyst, nullable, StructField$.MODULE$.apply$default$4());
            return structField;
        }, Seq$.MODULE$.canBuildFrom());
        return StructType$.MODULE$.apply(structFields);
    }

    public Seq<Tuple3<String, String, String>> toClickHouseSchema(StructType catalystSchema) {
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalystSchema.fields())).map((Function1 & Serializable & scala.Serializable)field -> {
            String chType = MODULE$.toClickHouseType(field.dataType());
            return new Tuple3((Object)field.name(), (Object)MODULE$.maybeNullable(chType, field.nullable()), field.getComment().map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(11).append(" COMMENT '").append((String)c).append("'").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public String maybeNullable(String chType, boolean nullable) {
        return nullable ? this.wrapNullable(chType) : chType;
    }

    public String wrapNullable(String chType) {
        return new StringBuilder(10).append("Nullable(").append(chType).append(")").toString();
    }

    public Tuple2<String, Object> unwrapNullable(String maybeNullableType) {
        Tuple2 tuple2;
        String string = maybeNullableType;
        Option option = this.nullableTypePattern().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String typeName = (String)((LinearSeqOptimized)option.get()).apply(0);
            tuple2 = new Tuple2((Object)typeName, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else {
            tuple2 = new Tuple2((Object)maybeNullableType, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        return tuple2;
    }

    public String unwrapLowCardinalityTypePattern(String maybeLowCardinalityType) {
        String typeName;
        String string = maybeLowCardinalityType;
        Option option = this.lowCardinalityTypePattern().unapplySeq((CharSequence)string);
        String string2 = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0 ? (typeName = (String)((LinearSeqOptimized)option.get()).apply(0)) : maybeLowCardinalityType;
        return string2;
    }

    private SchemaUtils$() {
        MODULE$ = this;
        this.arrayTypePattern = new StringOps(Predef$.MODULE$.augmentString("^Array\\((.+)\\)$")).r();
        this.mapTypePattern = new StringOps(Predef$.MODULE$.augmentString("^Map\\((\\w+),\\s*(.+)\\)$")).r();
        this.dateTypePattern = new StringOps(Predef$.MODULE$.augmentString("^Date$")).r();
        this.dateTimeTypePattern = new StringOps(Predef$.MODULE$.augmentString("^DateTime(64)?(\\((.*)\\))?$")).r();
        this.decimalTypePattern = new StringOps(Predef$.MODULE$.augmentString("^Decimal\\((\\d+),\\s*(\\d+)\\)$")).r();
        this.decimalTypePattern2 = new StringOps(Predef$.MODULE$.augmentString("^Decimal(32|64|128|256)\\((\\d+)\\)$")).r();
        this.enumTypePattern = new StringOps(Predef$.MODULE$.augmentString("^Enum(8|16)$")).r();
        this.fixedStringTypePattern = new StringOps(Predef$.MODULE$.augmentString("^FixedString\\((\\d+)\\)$")).r();
        this.nullableTypePattern = new StringOps(Predef$.MODULE$.augmentString("^Nullable\\((.*)\\)")).r();
        this.lowCardinalityTypePattern = new StringOps(Predef$.MODULE$.augmentString("^LowCardinality\\((.*)\\)")).r();
    }
}

