/*
 * Decompiled with CFR 0.152.
 */
package xenon.clickhouse;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.expressions.aggregate.Count;
import org.apache.spark.sql.connector.expressions.aggregate.CountStar;
import org.apache.spark.sql.connector.expressions.aggregate.Max;
import org.apache.spark.sql.connector.expressions.aggregate.Min;
import org.apache.spark.sql.connector.expressions.aggregate.Sum;
import org.apache.spark.sql.sources.AlwaysFalse$;
import org.apache.spark.sql.sources.AlwaysTrue$;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import xenon.clickhouse.Utils$;

@ScalaSignature(bytes="\u0006\u0001I4q\u0001C\u0005\u0011\u0002\u0007\u0005a\u0002C\u0003\u0016\u0001\u0011\u0005a\u0003C\u0003\u001b\u0001\u0011\u00051\u0004C\u0003*\u0001\u0011\u0005!\u0006C\u0003.\u0001\u0011\u0005a\u0006C\u0003?\u0001\u0011\u0005q\bC\u0003V\u0001\u0011\u0005a\u000bC\u0003d\u0001\u0011\u0005AMA\u0005T#2CU\r\u001c9fe*\u0011!bC\u0001\u000bG2L7m\u001b5pkN,'\"\u0001\u0007\u0002\u000ba,gn\u001c8\u0004\u0001M\u0011\u0001a\u0004\t\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#\u0005\u0002\u0007\u0003:L(+\u001a4\u0002\r\u0011Jg.\u001b;%)\u00059\u0002C\u0001\t\u0019\u0013\tI\u0012C\u0001\u0003V]&$\u0018AB9v_R,G\r\u0006\u0002\u001dOA\u0011Q\u0004\n\b\u0003=\t\u0002\"aH\t\u000e\u0003\u0001R!!I\u0007\u0002\rq\u0012xn\u001c;?\u0013\t\u0019\u0013#\u0001\u0004Qe\u0016$WMZ\u0005\u0003K\u0019\u0012aa\u0015;sS:<'BA\u0012\u0012\u0011\u0015A#\u00011\u0001\u001d\u0003\u0015!xn[3o\u0003%)7oY1qKN\u000bH\u000e\u0006\u0002\u001dW!)Af\u0001a\u00019\u0005)a/\u00197vK\u0006a1m\\7qS2,g+\u00197vKR\u0011q&\u0010\u000b\u0003aM\u0002\"\u0001E\u0019\n\u0005I\n\"aA!os\")A\u0007\u0002a\u0002k\u0005\u0011AO\u001f\t\u0003mmj\u0011a\u000e\u0006\u0003qe\nA\u0001^5nK*\t!(\u0001\u0003kCZ\f\u0017B\u0001\u001f8\u0005\u0019QvN\\3JI\")A\u0006\u0002a\u0001a\u0005i1m\\7qS2,g)\u001b7uKJ$\"\u0001Q#\u0015\u0005\u0005#\u0005c\u0001\tC9%\u00111)\u0005\u0002\u0007\u001fB$\u0018n\u001c8\t\u000bQ*\u00019A\u001b\t\u000b\u0019+\u0001\u0019A$\u0002\u0003\u0019\u0004\"\u0001S*\u000e\u0003%S!AS&\u0002\u000fM|WO]2fg*\u0011A*T\u0001\u0004gFd'B\u0001(P\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0016+\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002%\u0006\u0019qN]4\n\u0005QK%A\u0002$jYR,'/\u0001\td_6\u0004\u0018\u000e\\3BO\u001e\u0014XmZ1uKR\u0011\u0011i\u0016\u0005\u00061\u001a\u0001\r!W\u0001\fC\u001e<g)\u001e8di&|g\u000e\u0005\u0002[C6\t1L\u0003\u0002];\u0006I\u0011mZ4sK\u001e\fG/\u001a\u0006\u0003=~\u000b1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0001mS\u0001\nG>tg.Z2u_JL!AY.\u0003\u001b\u0005;wM]3hCR,g)\u001e8d\u00039\u0019w.\u001c9jY\u00164\u0015\u000e\u001c;feN$\"!Z4\u0015\u0005q1\u0007\"\u0002\u001b\b\u0001\b)\u0004\"\u00025\b\u0001\u0004I\u0017a\u00024jYR,'o\u001d\t\u0004U><eBA6n\u001d\tyB.C\u0001\u0013\u0013\tq\u0017#A\u0004qC\u000e\\\u0017mZ3\n\u0005A\f(aA*fc*\u0011a.\u0005")
public interface SQLHelper {
    public static /* synthetic */ String quoted$(SQLHelper $this, String token) {
        return $this.quoted(token);
    }

    default public String quoted(String token) {
        return new StringBuilder(2).append("`").append(token).append("`").toString();
    }

    public static /* synthetic */ String escapeSql$(SQLHelper $this, String value) {
        return $this.escapeSql(value);
    }

    default public String escapeSql(String value) {
        return StringUtils.replace((String)value, (String)"'", (String)"''");
    }

    public static /* synthetic */ Object compileValue$(SQLHelper $this, Object value, ZoneId tz) {
        return $this.compileValue(value, tz);
    }

    default public Object compileValue(Object value2, ZoneId tz) {
        Object object;
        Object object2 = value2;
        if (object2 instanceof String) {
            String string = (String)object2;
            object = new StringBuilder(2).append("'").append(this.escapeSql(string)).append("'").toString();
        } else if (object2 instanceof UTF8String) {
            UTF8String uTF8String = (UTF8String)object2;
            object = new StringBuilder(2).append("'").append(this.escapeSql(uTF8String.toString())).append("'").toString();
        } else if (object2 instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object2;
            object = new StringBuilder(2).append("'").append(timestamp).append("'").toString();
        } else if (object2 instanceof Instant) {
            Instant instant = (Instant)object2;
            object = new StringBuilder(2).append("'").append(Utils$.MODULE$.dateTimeFmt().withZone(tz).format(instant)).append("'").toString();
        } else if (object2 instanceof Date) {
            Date date = (Date)object2;
            object = new StringBuilder(2).append("'").append(date).append("'").toString();
        } else if (object2 instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object2;
            object = new StringBuilder(2).append("'").append(Utils$.MODULE$.dateFmt().format(localDate)).append("'").toString();
        } else if (object2 instanceof Object[]) {
            Object[] objectArray = (Object[])object2;
            object = Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps((Object)objectArray).map((Function1 & Serializable & scala.Serializable)value -> this.compileValue(value, tz), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).mkString(", ");
        } else {
            object = value2;
        }
        return object;
    }

    public static /* synthetic */ Option compileFilter$(SQLHelper $this, Filter f, ZoneId tz) {
        return $this.compileFilter(f, tz);
    }

    /*
     * Enabled aggressive block sorting
     */
    default public Option<String> compileFilter(Filter f, ZoneId tz) {
        Filter f2;
        String string;
        boolean bl = false;
        In in = null;
        Filter filter = f;
        if (AlwaysTrue$.MODULE$.equals(filter)) {
            string = "1=1";
            return Option$.MODULE$.apply((Object)string);
        }
        if (AlwaysFalse$.MODULE$.equals(filter)) {
            string = "1=0";
            return Option$.MODULE$.apply((Object)string);
        }
        if (filter instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)filter;
            String attr = equalTo.attribute();
            Object value = equalTo.value();
            string = new StringBuilder(3).append(this.quoted(attr)).append(" = ").append(this.compileValue(value, tz)).toString();
            return Option$.MODULE$.apply((Object)string);
        }
        if (filter instanceof EqualNullSafe) {
            EqualNullSafe equalNullSafe = (EqualNullSafe)filter;
            String attr = equalNullSafe.attribute();
            Object nullableValue = equalNullSafe.value();
            Tuple2 tuple2 = new Tuple2((Object)this.quoted(attr), this.compileValue(nullableValue, tz));
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String col = (String)tuple2._1();
            Object value = tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)col, value);
            Tuple2 tuple23 = tuple22;
            String col2 = (String)tuple23._1();
            Object value2 = tuple23._2();
            string = new StringBuilder(63).append("(NOT (").append(col2).append(" != ").append(value2).append(" OR ").append(col2).append(" IS NULL OR ").append(value2).append(" IS NULL) OR (").append(col2).append(" IS NULL AND ").append(value2).append(" IS NULL))").toString();
            return Option$.MODULE$.apply((Object)string);
        }
        if (filter instanceof LessThan) {
            LessThan lessThan = (LessThan)filter;
            String attr = lessThan.attribute();
            Object value = lessThan.value();
            string = new StringBuilder(3).append(this.quoted(attr)).append(" < ").append(this.compileValue(value, tz)).toString();
            return Option$.MODULE$.apply((Object)string);
        }
        if (filter instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)filter;
            String attr = greaterThan.attribute();
            Object value = greaterThan.value();
            string = new StringBuilder(3).append(this.quoted(attr)).append(" > ").append(this.compileValue(value, tz)).toString();
            return Option$.MODULE$.apply((Object)string);
        }
        if (filter instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter;
            String attr = lessThanOrEqual.attribute();
            Object value = lessThanOrEqual.value();
            string = new StringBuilder(4).append(this.quoted(attr)).append(" <= ").append(this.compileValue(value, tz)).toString();
            return Option$.MODULE$.apply((Object)string);
        }
        if (filter instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter;
            String attr = greaterThanOrEqual.attribute();
            Object value = greaterThanOrEqual.value();
            string = new StringBuilder(4).append(this.quoted(attr)).append(" >= ").append(this.compileValue(value, tz)).toString();
            return Option$.MODULE$.apply((Object)string);
        }
        if (filter instanceof IsNull) {
            IsNull isNull = (IsNull)filter;
            String attr = isNull.attribute();
            string = new StringBuilder(8).append(this.quoted(attr)).append(" IS NULL").toString();
            return Option$.MODULE$.apply((Object)string);
        }
        if (filter instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)filter;
            String attr = isNotNull.attribute();
            string = new StringBuilder(12).append(this.quoted(attr)).append(" IS NOT NULL").toString();
            return Option$.MODULE$.apply((Object)string);
        }
        if (filter instanceof StringStartsWith) {
            StringStartsWith stringStartsWith = (StringStartsWith)filter;
            String attr = stringStartsWith.attribute();
            String value = stringStartsWith.value();
            string = new StringBuilder(9).append(this.quoted(attr)).append(" LIKE '").append(value).append("%'").toString();
            return Option$.MODULE$.apply((Object)string);
        }
        if (filter instanceof StringEndsWith) {
            StringEndsWith stringEndsWith = (StringEndsWith)filter;
            String attr = stringEndsWith.attribute();
            String value = stringEndsWith.value();
            string = new StringBuilder(9).append(this.quoted(attr)).append(" LIKE '%").append(value).append("'").toString();
            return Option$.MODULE$.apply((Object)string);
        }
        if (filter instanceof StringContains) {
            StringContains stringContains = (StringContains)filter;
            String attr = stringContains.attribute();
            String value = stringContains.value();
            string = new StringBuilder(10).append(this.quoted(attr)).append(" LIKE '%").append(value).append("%'").toString();
            return Option$.MODULE$.apply((Object)string);
        }
        if (filter instanceof In) {
            bl = true;
            in = (In)filter;
            String attr = in.attribute();
            Object[] value = in.values();
            if (Predef$.MODULE$.genericArrayOps((Object)value).isEmpty()) {
                string = new StringBuilder(43).append("CASE WHEN ").append(this.quoted(attr)).append(" IS NULL THEN NULL ELSE FALSE END").toString();
                return Option$.MODULE$.apply((Object)string);
            }
        }
        if (bl) {
            String attr = in.attribute();
            Object[] value = in.values();
            string = new StringBuilder(6).append(this.quoted(attr)).append(" IN (").append(this.compileValue(value, tz)).append(")").toString();
            return Option$.MODULE$.apply((Object)string);
        }
        if (filter instanceof Not) {
            Not not = (Not)filter;
            Filter f3 = not.child();
            string = (String)this.compileFilter(f3, tz).map((Function1 & Serializable & scala.Serializable)p -> new StringBuilder(8).append("(NOT (").append((String)p).append("))").toString()).orNull(Predef$.MODULE$.$conforms());
            return Option$.MODULE$.apply((Object)string);
        }
        if (filter instanceof Or) {
            Filter f22;
            Or or = (Or)filter;
            Filter f1 = or.left();
            Seq or2 = (Seq)((TraversableLike)new .colon.colon((Object)f1, (List)new .colon.colon((Object)(f22 = or.right()), (List)Nil$.MODULE$))).flatMap((Function1 & Serializable & scala.Serializable)_f -> Option$.MODULE$.option2Iterable(this.compileFilter((Filter)_f, tz)), Seq$.MODULE$.canBuildFrom());
            string = or2.size() == 2 ? ((TraversableOnce)or2.map((Function1 & Serializable & scala.Serializable)p -> new StringBuilder(2).append("(").append((String)p).append(")").toString(), Seq$.MODULE$.canBuildFrom())).mkString(" OR ") : null;
            return Option$.MODULE$.apply((Object)string);
        }
        if (!(filter instanceof And)) {
            string = null;
            return Option$.MODULE$.apply((Object)string);
        }
        And and = (And)filter;
        Filter f1 = and.left();
        Seq and2 = (Seq)((TraversableLike)new .colon.colon((Object)f1, (List)new .colon.colon((Object)(f2 = and.right()), (List)Nil$.MODULE$))).flatMap((Function1 & Serializable & scala.Serializable)_f -> Option$.MODULE$.option2Iterable(this.compileFilter((Filter)_f, tz)), Seq$.MODULE$.canBuildFrom());
        string = and2.size() == 2 ? ((TraversableOnce)and2.map((Function1 & Serializable & scala.Serializable)p -> new StringBuilder(2).append("(").append((String)p).append(")").toString(), Seq$.MODULE$.canBuildFrom())).mkString(" AND ") : null;
        return Option$.MODULE$.apply((Object)string);
    }

    public static /* synthetic */ Option compileAggregate$(SQLHelper $this, AggregateFunc aggFunction) {
        return $this.compileAggregate(aggFunction);
    }

    default public Option<String> compileAggregate(AggregateFunc aggFunction) {
        Sum sum;
        Count count;
        Max max;
        Object object;
        Min min;
        AggregateFunc aggregateFunc = aggFunction;
        if (aggregateFunc instanceof Min && (min = (Min)aggregateFunc).column() instanceof NamedReference) {
            NamedReference col = (NamedReference)min.column();
            if (col.fieldNames().length != 1) {
                return None$.MODULE$;
            }
            object = new Some((Object)new StringBuilder(5).append("MIN(").append(this.quoted((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])col.fieldNames())).head())).append(")").toString());
        } else if (aggregateFunc instanceof Max && (max = (Max)aggregateFunc).column() instanceof NamedReference) {
            NamedReference col = (NamedReference)max.column();
            if (col.fieldNames().length != 1) {
                return None$.MODULE$;
            }
            object = new Some((Object)new StringBuilder(5).append("MAX(").append(this.quoted((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])col.fieldNames())).head())).append(")").toString());
        } else if (aggregateFunc instanceof Count && (count = (Count)aggregateFunc).column() instanceof NamedReference) {
            NamedReference col = (NamedReference)count.column();
            if (col.fieldNames().length != 1) {
                return None$.MODULE$;
            }
            String distinct = count.isDistinct() ? "DISTINCT " : "";
            String column = this.quoted((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])col.fieldNames())).head());
            object = new Some((Object)new StringBuilder(7).append("COUNT(").append(distinct).append(column).append(")").toString());
        } else if (aggregateFunc instanceof Sum && (sum = (Sum)aggregateFunc).column() instanceof NamedReference) {
            NamedReference col = (NamedReference)sum.column();
            if (col.fieldNames().length != 1) {
                return None$.MODULE$;
            }
            String distinct = sum.isDistinct() ? "DISTINCT " : "";
            String column = this.quoted((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])col.fieldNames())).head());
            object = new Some((Object)new StringBuilder(5).append("SUM(").append(distinct).append(column).append(")").toString());
        } else {
            object = aggregateFunc instanceof CountStar ? new Some((Object)"COUNT(*)") : None$.MODULE$;
        }
        return object;
    }

    public static /* synthetic */ String compileFilters$(SQLHelper $this, Seq filters, ZoneId tz) {
        return $this.compileFilters((Seq<Filter>)filters, tz);
    }

    default public String compileFilters(Seq<Filter> filters, ZoneId tz) {
        return ((TraversableOnce)((TraversableLike)filters.flatMap((Function1 & Serializable & scala.Serializable)_f -> Option$.MODULE$.option2Iterable(this.compileFilter((Filter)_f, tz)), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)p -> new StringBuilder(2).append("(").append((String)p).append(")").toString(), Seq$.MODULE$.canBuildFrom())).mkString(" AND ");
    }

    public static void $init$(SQLHelper $this) {
    }
}

