/*
 * Decompiled with CFR 0.152.
 */
package xenon.clickhouse;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.math.MathContext;
import java.math.RoundingMode;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import xenon.clickhouse.Logging;

public final class Utils$
implements Logging {
    public static Utils$ MODULE$;
    private transient DateTimeFormatter dateFmt;
    private transient DateTimeFormatter dateTimeFmt;
    private transient FastDateFormat legacyDateFmt;
    private transient FastDateFormat legacyDateTimeFmt;
    private transient Path tmpDirPath;
    private final String IS_TESTING;
    private final String PREFIX;
    private transient Logger log;
    private volatile transient byte bitmap$trans$0;

    static {
        new Utils$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    private Logger log$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if ((byte)(this.bitmap$trans$0 & 0x20) == 0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x20);
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        return (byte)(this.bitmap$trans$0 & 0x20) == 0 ? this.log$lzycompute() : this.log;
    }

    private DateTimeFormatter dateFmt$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.dateFmt = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.dateFmt;
    }

    public DateTimeFormatter dateFmt() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.dateFmt$lzycompute() : this.dateFmt;
    }

    private DateTimeFormatter dateTimeFmt$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.dateTimeFmt = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.dateTimeFmt;
    }

    public DateTimeFormatter dateTimeFmt() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.dateTimeFmt$lzycompute() : this.dateTimeFmt;
    }

    private FastDateFormat legacyDateFmt$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.legacyDateFmt = FastDateFormat.getInstance((String)"yyyy-MM-dd");
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.legacyDateFmt;
    }

    public FastDateFormat legacyDateFmt() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.legacyDateFmt$lzycompute() : this.legacyDateFmt;
    }

    private FastDateFormat legacyDateTimeFmt$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.legacyDateTimeFmt = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.legacyDateTimeFmt;
    }

    public FastDateFormat legacyDateTimeFmt() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.legacyDateTimeFmt$lzycompute() : this.legacyDateTimeFmt;
    }

    public ClassLoader defaultClassLoader() {
        return (ClassLoader)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Thread.currentThread().getContextClassLoader()).orElse((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.getClass().getClassLoader())).orElse((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ClassLoader.getSystemClassLoader())).get();
    }

    public URI classpathResource(String name) {
        return this.defaultClassLoader().getResource(name).toURI();
    }

    public InputStream classpathResourceAsStream(String name) {
        return this.defaultClassLoader().getResourceAsStream(name);
    }

    private Path tmpDirPath$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.tmpDirPath = Files.createTempDirectory("classpath_res_", new FileAttribute[0]);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.tmpDirPath;
    }

    public Path tmpDirPath() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.tmpDirPath$lzycompute() : this.tmpDirPath;
    }

    public File copyFileFromClasspath(String name) {
        Path copyPath = this.tmpDirPath().resolve(name);
        Files.createDirectories(copyPath.getParent(), new FileAttribute[0]);
        this.tryWithResource((Function0 & Serializable & scala.Serializable)() -> MODULE$.classpathResourceAsStream(name), (Function1 & Serializable & scala.Serializable)input -> BoxesRunTime.boxToLong((long)Utils$.$anonfun$copyFileFromClasspath$2(copyPath, input)));
        return copyPath.toFile();
    }

    public String load(String key, String defValue) {
        return (String)scala.sys.package$.MODULE$.props().getOrElse((Object)key, (Function0 & Serializable & scala.Serializable)() -> (String)scala.sys.package$.MODULE$.env().getOrElse((Object)key, (Function0 & Serializable & scala.Serializable)() -> defValue));
    }

    public String load$default$2() {
        return "";
    }

    public String stripSingleQuote(String maybeQuoted) {
        int until;
        int start;
        block2: {
            start = 0;
            until = maybeQuoted.length();
            if (maybeQuoted.startsWith("'")) {
                start = 1;
            }
            if (maybeQuoted.endsWith("'") && !maybeQuoted.endsWith("\\'")) {
                --until;
            }
            if (start <= until) break block2;
            until = start;
        }
        return maybeQuoted.substring(start, until);
    }

    public String wrapBackQuote(String identifier) {
        StringBuilder sb = new StringBuilder(identifier.length() + 2);
        Object object = !identifier.startsWith("`") ? sb.append('`') : BoxedUnit.UNIT;
        sb.append(identifier);
        String string = identifier;
        String string2 = "`";
        Object object2 = !(string == null ? string2 != null : !string.equals(string2)) || !identifier.endsWith("`") || identifier.endsWith("\\`") ? sb.append('`') : BoxedUnit.UNIT;
        return sb.mkString();
    }

    public <R, T extends Throwable> Try<R> retry(int retryTimes, Duration interval, Function0<R> f, ClassTag<T> evidence$1) {
        Success success;
        block4: {
            Try try_;
            Failure failure;
            boolean bl;
            while (true) {
                Predef$.MODULE$.assert(retryTimes >= 0);
                Try result = Try$.MODULE$.apply(f);
                bl = false;
                failure = null;
                try_ = result;
                if (try_ instanceof Success) {
                    Success success2 = (Success)try_;
                    Object result2 = success2.value();
                    success = new Success(result2);
                    break block4;
                }
                if (!(try_ instanceof Failure)) break;
                bl = true;
                failure = (Failure)try_;
                Throwable exception = failure.exception();
                Option option = evidence$1.unapply((Object)exception);
                if (option.isEmpty() || option.get() == null || retryTimes <= 0) break;
                this.log().warn("Execution failed caused by: ", exception);
                this.log().warn(new java.lang.StringBuilder(46).append(retryTimes).append(" times retry remaining, the next will be in ").append(interval.toMillis()).append("ms").toString());
                LockSupport.parkNanos(interval.toNanos());
                --retryTimes;
            }
            if (bl) {
                Throwable exception = failure.exception();
                success = new Failure(exception);
            } else {
                throw new MatchError((Object)try_);
            }
        }
        return success;
    }

    public String bytesToString(long size) {
        return this.bytesToString(package$.MODULE$.BigInt().apply(size));
    }

    public String bytesToString(BigInt size) {
        String string;
        long EiB = 0x1000000000000000L;
        long PiB = 0x4000000000000L;
        long TiB = 0x10000000000L;
        long GiB = 0x40000000L;
        long MiB = 0x100000L;
        long KiB = 1024L;
        if (size.$greater$eq((Object)package$.MODULE$.BigInt().apply(2048L).$times(BigInt$.MODULE$.long2bigInt(EiB)))) {
            string = new java.lang.StringBuilder(2).append(package$.MODULE$.BigDecimal().apply(size, new MathContext(3, RoundingMode.HALF_UP)).toString()).append(" B").toString();
        } else {
            Tuple2 tuple2;
            Tuple2 tuple22 = size.$greater$eq((Object)BigInt$.MODULE$.long2bigInt(2L * EiB)) ? new Tuple2((Object)package$.MODULE$.BigDecimal().apply(size).$div(BigDecimal$.MODULE$.long2bigDecimal(EiB)), (Object)"EiB") : (size.$greater$eq((Object)BigInt$.MODULE$.long2bigInt(2L * PiB)) ? new Tuple2((Object)package$.MODULE$.BigDecimal().apply(size).$div(BigDecimal$.MODULE$.long2bigDecimal(PiB)), (Object)"PiB") : (size.$greater$eq((Object)BigInt$.MODULE$.long2bigInt(2L * TiB)) ? new Tuple2((Object)package$.MODULE$.BigDecimal().apply(size).$div(BigDecimal$.MODULE$.long2bigDecimal(TiB)), (Object)"TiB") : (size.$greater$eq((Object)BigInt$.MODULE$.long2bigInt(2L * GiB)) ? new Tuple2((Object)package$.MODULE$.BigDecimal().apply(size).$div(BigDecimal$.MODULE$.long2bigDecimal(GiB)), (Object)"GiB") : (size.$greater$eq((Object)BigInt$.MODULE$.long2bigInt(2L * MiB)) ? new Tuple2((Object)package$.MODULE$.BigDecimal().apply(size).$div(BigDecimal$.MODULE$.long2bigDecimal(MiB)), (Object)"MiB") : (tuple2 = size.$greater$eq((Object)BigInt$.MODULE$.long2bigInt(2L * KiB)) ? new Tuple2((Object)package$.MODULE$.BigDecimal().apply(size).$div(BigDecimal$.MODULE$.long2bigDecimal(KiB)), (Object)"KiB") : new Tuple2((Object)package$.MODULE$.BigDecimal().apply(size), (Object)"B"))))));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BigDecimal value = (BigDecimal)tuple2._1();
            String unit = (String)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)value, (Object)unit);
            Tuple2 tuple24 = tuple23;
            BigDecimal value2 = (BigDecimal)tuple24._1();
            String unit2 = (String)tuple24._2();
            string = new StringOps(Predef$.MODULE$.augmentString("%.1f %s")).formatLocal(Locale.US, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value2, unit2}));
        }
        return string;
    }

    public String msDurationToString(long ms) {
        int second = 1000;
        int minute = 60 * second;
        int hour = 60 * minute;
        Locale locale = Locale.US;
        long l = ms;
        String string = l < (long)second ? new StringOps(Predef$.MODULE$.augmentString("%d ms")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)l)})) : (l < (long)minute ? new StringOps(Predef$.MODULE$.augmentString("%.1f s")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)second))})) : (l < (long)hour ? new StringOps(Predef$.MODULE$.augmentString("%.1f m")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)minute))})) : new StringOps(Predef$.MODULE$.augmentString("%.2f h")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)hour))}))));
        return string;
    }

    public <R extends AutoCloseable, T> T tryWithResource(Function0<R> createResource, Function1<R, T> f) {
        Object object;
        try (AutoCloseable resource = (AutoCloseable)createResource.apply();){
            object = f.apply((Object)resource);
        }
        return (T)object;
    }

    public <T> Tuple2<T, Object> timeTakenMs(Function0<T> body) {
        long startTime = System.nanoTime();
        Object result = body.apply();
        long endTime = System.nanoTime();
        return new Tuple2(result, (Object)BoxesRunTime.boxToLong((long)scala.math.package$.MODULE$.max(TimeUnit.NANOSECONDS.toMillis(endTime - startTime), 0L)));
    }

    public String IS_TESTING() {
        return this.IS_TESTING;
    }

    public String PREFIX() {
        return this.PREFIX;
    }

    public void setTesting() {
        System.setProperty(this.IS_TESTING(), "true");
    }

    public boolean isTesting() {
        String string = System.getProperty(this.IS_TESTING());
        String string2 = "true";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ long $anonfun$copyFileFromClasspath$2(Path copyPath$1, InputStream input) {
        return Files.copy(input, copyPath$1, StandardCopyOption.REPLACE_EXISTING);
    }

    private Utils$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.IS_TESTING = "spark.testing";
        this.PREFIX = "SPARK_ON_CLICKHOUSE";
    }
}

