/*
 * Decompiled with CFR 0.152.
 */
package xenon.clickhouse.client;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseCompression;
import com.clickhouse.client.ClickHouseCredentials;
import com.clickhouse.client.ClickHouseException;
import com.clickhouse.client.ClickHouseFormat;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseNodeSelector;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.config.ClickHouseOption;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.InputStream;
import java.io.Serializable;
import java.util.UUID;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import xenon.clickhouse.Logging;
import xenon.clickhouse.client.NodeClient$;
import xenon.clickhouse.exception.CHClientException;
import xenon.clickhouse.exception.CHException;
import xenon.clickhouse.exception.CHServerException;
import xenon.clickhouse.format.JSONCompactEachRowWithNamesAndTypesSimpleOutput$;
import xenon.clickhouse.format.JSONCompactEachRowWithNamesAndTypesStreamOutput$;
import xenon.clickhouse.format.JSONEachRowSimpleOutput$;
import xenon.clickhouse.format.SimpleOutput;
import xenon.clickhouse.format.StreamOutput;
import xenon.clickhouse.spec.NodeSpec;

@ScalaSignature(bytes="\u0006\u0001\tes!B\u0010!\u0011\u00039c!B\u0015!\u0011\u0003Q\u0003\"B\u0019\u0002\t\u0003\u0011\u0004\"B\u001a\u0002\t\u0003!d\u0001B\u0015!\u0001YB\u0001B\u0012\u0003\u0003\u0006\u0004%\ta\u0012\u0005\t\u001d\u0012\u0011\t\u0011)A\u0005\u0011\")\u0011\u0007\u0002C\u0001\u001f\"9\u0011\u000b\u0002b\u0001\n\u0013\u0011\u0006BB.\u0005A\u0003%1\u000bC\u0004\"\t\t\u0007I\u0011\u0002/\t\r\u0001$\u0001\u0015!\u0003^\u0011\u0015\tG\u0001\"\u0011c\u0011\u00151G\u0001\"\u0003h\u0011\u0015\u0019H\u0001\"\u0001u\u0011%\tI\u0004BI\u0001\n\u0003\tY\u0004C\u0004\u0002R\u0011!\t!a\u0015\t\u0013\u0005eC!%A\u0005\u0002\u0005m\u0002bBA.\t\u0011\u0005\u0011Q\f\u0005\n\u0003\u000f#\u0011\u0013!C\u0001\u0003\u0013C\u0011\"!$\u0005#\u0003%\t!a\u000f\t\u000f\u0005=E\u0001\"\u0001\u0002\u0012\"I\u00111\u0017\u0003\u0012\u0002\u0013\u0005\u00111\b\u0005\b\u0003k#A\u0011AA\\\u0011\u001d\ty\u000f\u0002C\u0001\u0003cDqAa\u0002\u0005\t\u0003\u0011I\u0001C\u0004\u0003\u001e\u0011!\tAa\b\t\u0013\t=B!%A\u0005\u0002\u0005%\u0005\"\u0003B\u0019\tE\u0005I\u0011AA\u001e\u0011\u001d\u0011\u0019\u0004\u0002C\u0001\u0005kAqA!\u0014\u0005\t\u0003\u0011y%\u0001\u0006O_\u0012,7\t\\5f]RT!!\t\u0012\u0002\r\rd\u0017.\u001a8u\u0015\t\u0019C%\u0001\u0006dY&\u001c7\u000e[8vg\u0016T\u0011!J\u0001\u0006q\u0016twN\\\u0002\u0001!\tA\u0013!D\u0001!\u0005)qu\u000eZ3DY&,g\u000e^\n\u0003\u0003-\u0002\"\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001(\u0003\u0015\t\u0007\u000f\u001d7z)\r)$q\u000b\t\u0003Q\u0011\u0019B\u0001B\u001c@\u0005B\u0011\u0001(P\u0007\u0002s)\u0011!hO\u0001\u0005Y\u0006twMC\u0001=\u0003\u0011Q\u0017M^1\n\u0005yJ$AB(cU\u0016\u001cG\u000f\u0005\u00029\u0001&\u0011\u0011)\u000f\u0002\u000e\u0003V$xn\u00117pg\u0016\f'\r\\3\u0011\u0005\r#U\"\u0001\u0012\n\u0005\u0015\u0013#a\u0002'pO\u001eLgnZ\u0001\t]>$Wm\u00159fGV\t\u0001\n\u0005\u0002J\u00196\t!J\u0003\u0002LE\u0005!1\u000f]3d\u0013\ti%J\u0001\u0005O_\u0012,7\u000b]3d\u0003%qw\u000eZ3Ta\u0016\u001c\u0007\u0005\u0006\u00026!\")ai\u0002a\u0001\u0011\u0006!an\u001c3f+\u0005\u0019\u0006C\u0001+Z\u001b\u0005)&BA\u0011W\u0015\t\u0019sKC\u0001Y\u0003\r\u0019w.\\\u0005\u00035V\u0013ab\u00117jG.Du.^:f\u001d>$W-A\u0003o_\u0012,\u0007%F\u0001^!\t!f,\u0003\u0002`+\n\u00012\t\\5dW\"{Wo]3DY&,g\u000e^\u0001\bG2LWM\u001c;!\u0003\u0015\u0019Gn\\:f)\u0005\u0019\u0007C\u0001\u0017e\u0013\t)WF\u0001\u0003V]&$\u0018a\u00038fqR\fV/\u001a:z\u0013\u0012$\u0012\u0001\u001b\t\u0003SBt!A\u001b8\u0011\u0005-lS\"\u00017\u000b\u000554\u0013A\u0002\u001fs_>$h(\u0003\u0002p[\u00051\u0001K]3eK\u001aL!!\u001d:\u0003\rM#(/\u001b8h\u0015\tyW&\u0001\u000ets:\u001c\u0017+^3ss>+H\u000f];u\u0015N{e*R1dQJ{w\u000fF\u0003v\u0003W\ty\u0003E\u0003wwz\fIA\u0004\u0002xs:\u00111\u000e_\u0005\u0002]%\u0011!0L\u0001\ba\u0006\u001c7.Y4f\u0013\taXP\u0001\u0004FSRDWM\u001d\u0006\u0003u6\u00022a`A\u0003\u001b\t\t\tAC\u0002\u0002\u0004\t\n\u0011\"\u001a=dKB$\u0018n\u001c8\n\t\u0005\u001d\u0011\u0011\u0001\u0002\f\u0007\"+\u0005pY3qi&|g\u000e\u0005\u0004\u0002\f\u0005E\u0011QC\u0007\u0003\u0003\u001bQ1!a\u0004#\u0003\u00191wN]7bi&!\u00111CA\u0007\u00051\u0019\u0016.\u001c9mK>+H\u000f];u!\u0011\t9\"a\n\u000e\u0005\u0005e!bA)\u0002\u001c)!\u0011QDA\u0010\u0003!!\u0017\r^1cS:$'\u0002BA\u0011\u0003G\tqA[1dWN|gNC\u0002\u0002&]\u000b\u0011BZ1ti\u0016\u0014\b0\u001c7\n\t\u0005%\u0012\u0011\u0004\u0002\u000b\u001f\nTWm\u0019;O_\u0012,\u0007BBA\u0017\u001d\u0001\u0007\u0001.A\u0002tc2D\u0011\"!\r\u000f!\u0003\u0005\r!a\r\u0002\u0011M,G\u000f^5oON\u0004R![A\u001bQ\"L1!a\u000es\u0005\ri\u0015\r]\u0001%gft7-U;fef|U\u000f\u001e9vi*\u001bvJT#bG\"\u0014vn\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\b\u0016\u0005\u0003g\tyd\u000b\u0002\u0002BA!\u00111IA'\u001b\t\t)E\u0003\u0003\u0002H\u0005%\u0013!C;oG\",7m[3e\u0015\r\tY%L\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA(\u0003\u000b\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\t\u001a\u0018P\\2Rk\u0016\u0014\u00180\u00118e\u0007\",7m[(viB,HOS*P\u001d\u0016\u000b7\r\u001b*poR1\u0011\u0011BA+\u0003/Ba!!\f\u0011\u0001\u0004A\u0007\"CA\u0019!A\u0005\t\u0019AA\u001a\u00031\u001a\u0018P\\2Rk\u0016\u0014\u00180\u00118e\u0007\",7m[(viB,HOS*P\u001d\u0016\u000b7\r\u001b*po\u0012\"WMZ1vYR$#'A\u000ets:\u001c\u0017J\\:feR|U\u000f\u001e9vi*\u001bvJT#bG\"\u0014vn\u001e\u000b\u000ek\u0006}\u00131MA4\u0003W\n)(!\"\t\r\u0005\u0005$\u00031\u0001i\u0003!!\u0017\r^1cCN,\u0007BBA3%\u0001\u0007\u0001.A\u0003uC\ndW\r\u0003\u0004\u0002jI\u0001\r\u0001[\u0001\fS:\u0004X\u000f\u001e$pe6\fG\u000fC\u0005\u0002nI\u0001\n\u00111\u0001\u0002p\u0005!\u0012N\u001c9vi\u000e{W\u000e\u001d:fgNLwN\u001c+za\u0016\u00042\u0001VA9\u0013\r\t\u0019(\u0016\u0002\u0016\u00072L7m\u001b%pkN,7i\\7qe\u0016\u001c8/[8o\u0011\u001d\t9H\u0005a\u0001\u0003s\nA\u0001Z1uCB!\u00111PAA\u001b\t\tiHC\u0002\u0002\u0000m\n!![8\n\t\u0005\r\u0015Q\u0010\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000eC\u0005\u00022I\u0001\n\u00111\u0001\u00024\u0005)3/\u001f8d\u0013:\u001cXM\u001d;PkR\u0004X\u000f\u001e&T\u001f:+\u0015m\u00195S_^$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u0017SC!a\u001c\u0002@\u0005)3/\u001f8d\u0013:\u001cXM\u001d;PkR\u0004X\u000f\u001e&T\u001f:+\u0015m\u00195S_^$C-\u001a4bk2$HEN\u0001;gft7-U;fef\fe\u000eZ\"iK\u000e\\w*\u001e;qkRT5k\u0014(D_6\u0004\u0018m\u0019;FC\u000eD'k\\<XSRDg*Y7fg\u0006sG\rV=qKN$b!a%\u00020\u0006E&CBAK\u00033\u000bIK\u0002\u0004\u0002\u0018\u0012\u0001\u00111\u0013\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\t\u0007\u0003\u0017\t\t\"a'\u0011\u000b1\ni*!)\n\u0007\u0005}UFA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002$\u0006\u0015VBAA\u000e\u0013\u0011\t9+a\u0007\u0003\u0011)\u001bxN\u001c(pI\u0016\u0004B!a\u0003\u0002,&!\u0011QVA\u0007\u00055q\u0015-\\3t\u0003:$G+\u001f9fg\"1\u0011QF\u000bA\u0002!D\u0011\"!\r\u0016!\u0003\u0005\r!a\r\u0002\tNLhnY)vKJL\u0018I\u001c3DQ\u0016\u001c7nT;uaV$(jU(O\u0007>l\u0007/Y2u\u000b\u0006\u001c\u0007NU8x/&$\bNT1nKN\fe\u000e\u001a+za\u0016\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0002\u0015MLhnY%og\u0016\u0014H/\u0006\u0003\u0002:\u0006\rGCEA^\u0003+\f9.!7\u0002\\\u0006u\u0017q\\Ar\u0003[\u0004RA^>\u007f\u0003{\u0003b!a\u0003\u0002\u0012\u0005}\u0006\u0003BAa\u0003\u0007d\u0001\u0001B\u0004\u0002F^\u0011\r!a2\u0003\u0007=+F+\u0005\u0003\u0002J\u0006=\u0007c\u0001\u0017\u0002L&\u0019\u0011QZ\u0017\u0003\u000f9{G\u000f[5oOB\u0019A&!5\n\u0007\u0005MWFA\u0002B]fDa!!\u0019\u0018\u0001\u0004A\u0007BBA3/\u0001\u0007\u0001\u000e\u0003\u0004\u0002j]\u0001\r\u0001\u001b\u0005\b\u0003[:\u0002\u0019AA8\u0011\u001d\t9h\u0006a\u0001\u0003sBa!!9\u0018\u0001\u0004A\u0017\u0001D8viB,HOR8s[\u0006$\bbBAs/\u0001\u0007\u0011q]\u0001\rI\u0016\u001cXM]5bY&TXM\u001d\t\bY\u0005%\u0018\u0011PA_\u0013\r\tY/\f\u0002\n\rVt7\r^5p]FBq!!\r\u0018\u0001\u0004\t\u0019$A\u0005ts:\u001c\u0017+^3ssV!\u00111_A~))\t)0!@\u0002\u0000\n\u0005!Q\u0001\t\u0006mnt\u0018q\u001f\t\u0007\u0003\u0017\t\t\"!?\u0011\t\u0005\u0005\u00171 \u0003\b\u0003\u000bD\"\u0019AAd\u0011\u0019\ti\u0003\u0007a\u0001Q\"1\u0011\u0011\u001d\rA\u0002!Dq!!:\u0019\u0001\u0004\u0011\u0019\u0001E\u0004-\u0003S\fI(a>\t\u000f\u0005E\u0002\u00041\u0001\u00024\u0005\t2/\u001f8d#V,'/_!oI\u000eCWmY6\u0016\t\t-!\u0011\u0003\u000b\u000b\u0005\u001b\u0011\u0019B!\u0006\u0003\u0018\tm\u0001CBA\u0006\u0003#\u0011y\u0001\u0005\u0003\u0002B\nEAaBAc3\t\u0007\u0011q\u0019\u0005\u0007\u0003[I\u0002\u0019\u00015\t\r\u0005\u0005\u0018\u00041\u0001i\u0011\u001d\t)/\u0007a\u0001\u00053\u0001r\u0001LAu\u0003s\u0012i\u0001C\u0004\u00022e\u0001\r!a\r\u0002\u0001NLhnY*ue\u0016\fW.U;fef\fe\u000eZ\"iK\u000e\\w*\u001e;qkRT5k\u0014(D_6\u0004\u0018m\u0019;FC\u000eD'k\\<XSRDg*Y7fg\u0006sG\rV=qKN$\u0002B!\t\u0003(\t%\"Q\u0006\t\u0007\u0003\u0017\u0011\u0019#a'\n\t\t\u0015\u0012Q\u0002\u0002\r'R\u0014X-Y7PkR\u0004X\u000f\u001e\u0005\u0007\u0003[Q\u0002\u0019\u00015\t\u0013\t-\"\u0004%AA\u0002\u0005=\u0014!F8viB,HoQ8naJ,7o]5p]RK\b/\u001a\u0005\n\u0003cQ\u0002\u0013!a\u0001\u0003g\t!j]=oGN#(/Z1n#V,'/_!oI\u000eCWmY6PkR\u0004X\u000f\u001e&T\u001f:\u001bu.\u001c9bGR,\u0015m\u00195S_^<\u0016\u000e\u001e5OC6,7/\u00118e)f\u0004Xm\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005Q5/\u001f8d'R\u0014X-Y7Rk\u0016\u0014\u00180\u00118e\u0007\",7m[(viB,HOS*P\u001d\u000e{W\u000e]1di\u0016\u000b7\r\u001b*po^KG\u000f\u001b(b[\u0016\u001c\u0018I\u001c3UsB,7\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003]\u0019\u0018P\\2TiJ,\u0017-\\)vKJL\u0018I\u001c3DQ\u0016\u001c7.\u0006\u0003\u00038\tuB\u0003\u0004B\u001d\u0005\u007f\u0011\tEa\u0011\u0003F\t-\u0003CBA\u0006\u0005G\u0011Y\u0004\u0005\u0003\u0002B\nuBaBAc;\t\u0007\u0011q\u0019\u0005\u0007\u0003[i\u0002\u0019\u00015\t\r\u0005\u0005X\u00041\u0001i\u0011\u001d\u0011Y#\ba\u0001\u0003_BqAa\u0012\u001e\u0001\u0004\u0011I%\u0001\rpkR\u0004X\u000f^*ue\u0016\fW\u000eR3tKJL\u0017\r\\5{KJ\u0004r\u0001LAu\u0003s\u0012I\u0004C\u0004\u00022u\u0001\r!a\r\u0002\u001d=tW\t_3dkR,\u0017+^3ssR)1M!\u0015\u0003V!1!1\u000b\u0010A\u0002!\fq!];fefLE\r\u0003\u0004\u0002.y\u0001\r\u0001\u001b\u0005\u0006#\u000e\u0001\r\u0001\u0013")
public class NodeClient
implements AutoCloseable,
Logging {
    private final NodeSpec nodeSpec;
    private final ClickHouseNode node;
    private final ClickHouseClient client;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    public static NodeClient apply(NodeSpec nodeSpec) {
        return NodeClient$.MODULE$.apply(nodeSpec);
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    private Logger log$lzycompute() {
        NodeClient nodeClient = this;
        synchronized (nodeClient) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    public NodeSpec nodeSpec() {
        return this.nodeSpec;
    }

    private ClickHouseNode node() {
        return this.node;
    }

    private ClickHouseClient client() {
        return this.client;
    }

    @Override
    public void close() {
        this.client().close();
    }

    private String nextQueryId() {
        return UUID.randomUUID().toString();
    }

    public Either<CHException, SimpleOutput<ObjectNode>> syncQueryOutputJSONEachRow(String sql, Map<String, String> settings) {
        return this.syncQuery(sql, "JSONEachRow", (Function1 & Serializable & scala.Serializable)input -> JSONEachRowSimpleOutput$.MODULE$.deserialize((InputStream)input), settings);
    }

    public SimpleOutput<ObjectNode> syncQueryAndCheckOutputJSONEachRow(String sql, Map<String, String> settings) {
        return this.syncQueryAndCheck(sql, "JSONEachRow", (Function1 & Serializable & scala.Serializable)input -> JSONEachRowSimpleOutput$.MODULE$.deserialize((InputStream)input), settings);
    }

    public Either<CHException, SimpleOutput<ObjectNode>> syncInsertOutputJSONEachRow(String database, String table, String inputFormat, ClickHouseCompression inputCompressionType, InputStream data, Map<String, String> settings) {
        return this.syncInsert(database, table, inputFormat, inputCompressionType, data, "JSONEachRow", (Function1 & Serializable & scala.Serializable)input -> JSONEachRowSimpleOutput$.MODULE$.deserialize((InputStream)input), settings);
    }

    public SimpleOutput<JsonNode[]> syncQueryAndCheckOutputJSONCompactEachRowWithNamesAndTypes(String sql, Map<String, String> settings) {
        return this.syncQueryAndCheck(sql, "JSONCompactEachRowWithNamesAndTypes", (Function1 & Serializable & scala.Serializable)input -> JSONCompactEachRowWithNamesAndTypesSimpleOutput$.MODULE$.deserialize((InputStream)input), settings);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <OUT> Either<CHException, SimpleOutput<OUT>> syncInsert(String database, String table, String inputFormat, ClickHouseCompression inputCompressionType, InputStream data, String outputFormat, Function1<InputStream, SimpleOutput<OUT>> deserializer, Map<String, String> settings) {
        String queryId = this.nextQueryId();
        String sql = new StringBuilder(25).append("INSERT INTO `").append(database).append("`.`").append(table).append("` FORMAT ").append(inputFormat).toString();
        this.onExecuteQuery(queryId, sql);
        ClickHouseRequest.Mutation req = ((ClickHouseRequest.Mutation)this.client().connect(this.node()).write().query(sql, queryId).decompressClientRequest(inputCompressionType)).format(ClickHouseFormat.valueOf((String)outputFormat));
        settings.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            ClickHouseRequest.Mutation mutation = (ClickHouseRequest.Mutation)req.set(k, v);
            return mutation;
        });
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> req.data(data).executeAndWait());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            ClickHouseResponse resp = (ClickHouseResponse)success.value();
            return package$.MODULE$.Right().apply(deserializer.apply((Object)resp.getInputStream()));
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable ex = failure.exception();
            if (ex instanceof ClickHouseException) {
                ClickHouseException clickHouseException = (ClickHouseException)ex;
                return package$.MODULE$.Left().apply((Object)new CHServerException(clickHouseException.getErrorCode(), clickHouseException.getMessage(), (Option<NodeSpec>)new Some((Object)this.nodeSpec()), (Option<Throwable>)new Some((Object)clickHouseException)));
            }
        }
        if (!bl) throw new MatchError((Object)try_);
        Throwable ex = failure.exception();
        return package$.MODULE$.Left().apply((Object)new CHClientException(ex.getMessage(), (Option<NodeSpec>)new Some((Object)this.nodeSpec()), (Option<Throwable>)new Some((Object)ex)));
    }

    public ClickHouseCompression syncInsertOutputJSONEachRow$default$4() {
        return ClickHouseCompression.NONE;
    }

    public Map<String, String> syncInsertOutputJSONEachRow$default$6() {
        return Predef$.MODULE$.Map().empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <OUT> Either<CHException, SimpleOutput<OUT>> syncQuery(String sql, String outputFormat, Function1<InputStream, SimpleOutput<OUT>> deserializer, Map<String, String> settings) {
        String queryId = this.nextQueryId();
        this.onExecuteQuery(queryId, sql);
        ClickHouseRequest req = this.client().connect(this.node()).query(sql, queryId).format(ClickHouseFormat.valueOf((String)outputFormat));
        settings.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            ClickHouseRequest clickHouseRequest = req.set(k, v);
            return clickHouseRequest;
        });
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> req.executeAndWait());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            ClickHouseResponse resp = (ClickHouseResponse)success.value();
            return package$.MODULE$.Right().apply(deserializer.apply((Object)resp.getInputStream()));
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable ex = failure.exception();
            if (ex instanceof ClickHouseException) {
                ClickHouseException clickHouseException = (ClickHouseException)ex;
                return package$.MODULE$.Left().apply((Object)new CHServerException(clickHouseException.getErrorCode(), clickHouseException.getMessage(), (Option<NodeSpec>)new Some((Object)this.nodeSpec()), (Option<Throwable>)new Some((Object)clickHouseException)));
            }
        }
        if (!bl) throw new MatchError((Object)try_);
        Throwable ex = failure.exception();
        return package$.MODULE$.Left().apply((Object)new CHClientException(ex.getMessage(), (Option<NodeSpec>)new Some((Object)this.nodeSpec()), (Option<Throwable>)new Some((Object)ex)));
    }

    public Map<String, String> syncQueryOutputJSONEachRow$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public <OUT> SimpleOutput<OUT> syncQueryAndCheck(String sql, String outputFormat, Function1<InputStream, SimpleOutput<OUT>> deserializer, Map<String, String> settings) {
        SimpleOutput output;
        Either<CHException, SimpleOutput<OUT>> either = this.syncQuery(sql, outputFormat, deserializer, settings);
        if (either instanceof Left) {
            Left left = (Left)either;
            CHException rethrow = (CHException)left.value();
            throw rethrow;
        }
        if (!(either instanceof Right)) {
            throw new MatchError(either);
        }
        Right right = (Right)either;
        SimpleOutput simpleOutput = output = (SimpleOutput)right.value();
        return simpleOutput;
    }

    public Map<String, String> syncQueryAndCheckOutputJSONEachRow$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public Map<String, String> syncQueryAndCheckOutputJSONCompactEachRowWithNamesAndTypes$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public StreamOutput<JsonNode[]> syncStreamQueryAndCheckOutputJSONCompactEachRowWithNamesAndTypes(String sql, ClickHouseCompression outputCompressionType, Map<String, String> settings) {
        return this.syncStreamQueryAndCheck(sql, "JSONCompactEachRowWithNamesAndTypes", outputCompressionType, (Function1 & Serializable & scala.Serializable)input -> JSONCompactEachRowWithNamesAndTypesStreamOutput$.MODULE$.deserializeStream((InputStream)input), settings);
    }

    public <OUT> StreamOutput<OUT> syncStreamQueryAndCheck(String sql, String outputFormat, ClickHouseCompression outputCompressionType, Function1<InputStream, StreamOutput<OUT>> outputStreamDeserializer, Map<String, String> settings) {
        String queryId = this.nextQueryId();
        this.onExecuteQuery(queryId, sql);
        ClickHouseRequest req = this.client().connect(this.node()).query(sql, queryId).compressServerResponse(outputCompressionType).format(ClickHouseFormat.valueOf((String)outputFormat));
        settings.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            ClickHouseRequest clickHouseRequest = req.set(k, v);
            return clickHouseRequest;
        });
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> req.executeAndWait());
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                bl = true;
                failure = (Failure)try_;
                Throwable ex = failure.exception();
                if (ex instanceof ClickHouseException) {
                    ClickHouseException clickHouseException = (ClickHouseException)ex;
                    throw new CHServerException(clickHouseException.getErrorCode(), clickHouseException.getMessage(), (Option<NodeSpec>)new Some((Object)this.nodeSpec()), (Option<Throwable>)new Some((Object)clickHouseException));
                }
            }
            if (bl) {
                Throwable ex = failure.exception();
                throw new CHClientException(ex.getMessage(), (Option<NodeSpec>)new Some((Object)this.nodeSpec()), (Option<Throwable>)new Some((Object)ex));
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        ClickHouseResponse resp = (ClickHouseResponse)success.value();
        StreamOutput streamOutput = (StreamOutput)outputStreamDeserializer.apply((Object)resp.getInputStream());
        return streamOutput;
    }

    public ClickHouseCompression syncStreamQueryAndCheckOutputJSONCompactEachRowWithNamesAndTypes$default$2() {
        return ClickHouseCompression.NONE;
    }

    public Map<String, String> syncStreamQueryAndCheckOutputJSONCompactEachRowWithNamesAndTypes$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public void onExecuteQuery(String queryId, String sql) {
        this.log().debug(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(44).append("Execute ClickHouse SQL [").append(queryId).append("]:\n       |").append(sql).append("\n       |").toString())).stripMargin());
    }

    public NodeClient(NodeSpec nodeSpec) {
        this.nodeSpec = nodeSpec;
        Logging.$init$(this);
        this.node = ClickHouseNode.builder().host(nodeSpec.host()).port(nodeSpec.protocol(), Predef$.MODULE$.int2Integer(nodeSpec.port())).database(nodeSpec.database()).credentials(ClickHouseCredentials.fromUserAndPassword((String)nodeSpec.username(), (String)nodeSpec.password())).build();
        this.client = ClickHouseClient.builder().option((ClickHouseOption)ClickHouseClientOption.ASYNC, (Serializable)Predef$.MODULE$.boolean2Boolean(false)).option((ClickHouseOption)ClickHouseClientOption.FORMAT, (Serializable)ClickHouseFormat.RowBinary).nodeSelector(ClickHouseNodeSelector.of((ClickHouseProtocol)this.node().getProtocol(), (ClickHouseProtocol[])new ClickHouseProtocol[0])).build();
    }
}

