/*
 * Decompiled with CFR 0.152.
 */
package xenon.clickhouse.read;

import com.clickhouse.client.ClickHouseCompression;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.clickhouse.ClickHouseSQLConf$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import xenon.clickhouse.ClickHouseHelper;
import xenon.clickhouse.Logging;
import xenon.clickhouse.Utils$;
import xenon.clickhouse.client.NodeClient;
import xenon.clickhouse.client.NodesClient;
import xenon.clickhouse.client.NodesClient$;
import xenon.clickhouse.exception.CHClientException;
import xenon.clickhouse.exception.CHClientException$;
import xenon.clickhouse.format.StreamOutput;
import xenon.clickhouse.read.ClickHouseInputPartition;
import xenon.clickhouse.read.ScanJobDescription;
import xenon.clickhouse.spec.ClusterSpec;
import xenon.clickhouse.spec.DatabaseSpec;
import xenon.clickhouse.spec.NodeSpec;
import xenon.clickhouse.spec.PartitionSpec;
import xenon.clickhouse.spec.TableSpec;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001B\r\u001b\u0001\u0005B\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u001f\")!\u000b\u0001C\u0001'\"9q\u000b\u0001b\u0001\n\u0003A\u0006BB0\u0001A\u0003%\u0011\fC\u0004a\u0001\t\u0007I\u0011\u0001-\t\r\u0005\u0004\u0001\u0015!\u0003Z\u0011\u001d\u0011\u0007A1A\u0005\u0002\rDaa\u001c\u0001!\u0002\u0013!\u0007b\u00029\u0001\u0005\u0004%\ta\u0019\u0005\u0007c\u0002\u0001\u000b\u0011\u00023\t\u000fI\u0004!\u0019!C\u0001g\"1Q\u0010\u0001Q\u0001\nQDQA \u0001\u0005\u0002}D!\"!\u0004\u0001\u0011\u000b\u0007I\u0011BA\b\u0011\u001d\tY\u0002\u0001C\u0001\u0003;A!\"!\n\u0001\u0011\u000b\u0007I\u0011AA\u0014\u0011-\ty\u0005\u0001a\u0001\u0002\u0004%I!!\u0015\t\u0017\u0005M\u0003\u00011AA\u0002\u0013%\u0011Q\u000b\u0005\f\u0003C\u0002\u0001\u0019!A!B\u0013\t)\u0004C\u0004\u0002d\u0001!\t%!\u001a\t\u000f\u0005\u001d\u0004\u0001\"\u0011\u0002j!9\u00111\u000e\u0001\u0005\n\u00055\u0004bBAB\u0001\u0011\u0005\u0013Q\u0011\u0002\u0011\u00072L7m\u001b%pkN,'+Z1eKJT!a\u0007\u000f\u0002\tI,\u0017\r\u001a\u0006\u0003;y\t!b\u00197jG.Dw.^:f\u0015\u0005y\u0012!\u0002=f]>t7\u0001A\n\u0007\u0001\tRsh\u0011$\u0011\u0005\rBS\"\u0001\u0013\u000b\u0005\u00152\u0013\u0001\u00027b]\u001eT\u0011aJ\u0001\u0005U\u00064\u0018-\u0003\u0002*I\t1qJ\u00196fGR\u00042aK\u001c:\u001b\u0005a#BA\u000e.\u0015\tqs&A\u0005d_:tWm\u0019;pe*\u0011\u0001'M\u0001\u0004gFd'B\u0001\u001a4\u0003\u0015\u0019\b/\u0019:l\u0015\t!T'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0005\u0019qN]4\n\u0005ab#a\u0004)beRLG/[8o%\u0016\fG-\u001a:\u0011\u0005ijT\"A\u001e\u000b\u0005qz\u0013\u0001C2bi\u0006d\u0017p\u001d;\n\u0005yZ$aC%oi\u0016\u0014h.\u00197S_^\u0004\"\u0001Q!\u000e\u0003qI!A\u0011\u000f\u0003!\rc\u0017nY6I_V\u001cX\rS3ma\u0016\u0014\bC\u0001\u001eE\u0013\t)5HA\u0007T#2\u001buN\u001c4IK2\u0004XM\u001d\t\u0003\u0001\u001eK!\u0001\u0013\u000f\u0003\u000f1{wmZ5oO\u000691oY1o\u0015>\u0014\u0007CA&M\u001b\u0005Q\u0012BA'\u001b\u0005I\u00196-\u00198K_\n$Um]2sSB$\u0018n\u001c8\u0002\tA\f'\u000f\u001e\t\u0003\u0017BK!!\u0015\u000e\u00031\rc\u0017nY6I_V\u001cX-\u00138qkR\u0004\u0016M\u001d;ji&|g.\u0001\u0004=S:LGO\u0010\u000b\u0004)V3\u0006CA&\u0001\u0011\u0015I5\u00011\u0001K\u0011\u0015q5\u00011\u0001P\u0003y\u0011X-\u00193ESN$(/\u001b2vi\u0016$Wk]3DYV\u001cH/\u001a:O_\u0012,7/F\u0001Z!\tQV,D\u0001\\\u0015\u0005a\u0016!B:dC2\f\u0017B\u00010\\\u0005\u001d\u0011un\u001c7fC:\fqD]3bI\u0012K7\u000f\u001e:jEV$X\rZ+tK\u000ecWo\u001d;fe:{G-Z:!\u0003m\u0011X-\u00193ESN$(/\u001b2vi\u0016$7i\u001c8wKJ$Hj\\2bY\u0006a\"/Z1e\t&\u001cHO]5ckR,GmQ8om\u0016\u0014H\u000fT8dC2\u0004\u0013\u0001\u00033bi\u0006\u0014\u0017m]3\u0016\u0003\u0011\u0004\"!\u001a7\u000f\u0005\u0019T\u0007CA4\\\u001b\u0005A'BA5!\u0003\u0019a$o\\8u}%\u00111nW\u0001\u0007!J,G-\u001a4\n\u00055t'AB*ue&twM\u0003\u0002l7\u0006IA-\u0019;bE\u0006\u001cX\rI\u0001\u0006i\u0006\u0014G.Z\u0001\u0007i\u0006\u0014G.\u001a\u0011\u0002\u000b\r|G-Z2\u0016\u0003Q\u0004\"!^>\u000e\u0003YT!a\u001e=\u0002\r\rd\u0017.\u001a8u\u0015\ti\u0012PC\u0001{\u0003\r\u0019w.\\\u0005\u0003yZ\u0014Qc\u00117jG.Du.^:f\u0007>l\u0007O]3tg&|g.\u0001\u0004d_\u0012,7\rI\u0001\u000be\u0016\fGmU2iK6\fWCAA\u0001!\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u0004_\u0005)A/\u001f9fg&!\u00111BA\u0003\u0005)\u0019FO];diRK\b/Z\u0001\f]>$Wm]\"mS\u0016tG/\u0006\u0002\u0002\u0012A!\u00111CA\f\u001b\t\t)B\u0003\u0002x9%!\u0011\u0011DA\u000b\u0005-qu\u000eZ3t\u00072LWM\u001c;\u0002\u00159|G-Z\"mS\u0016tG/\u0006\u0002\u0002 A!\u00111CA\u0011\u0013\u0011\t\u0019#!\u0006\u0003\u00159{G-Z\"mS\u0016tG/\u0001\u0007tiJ,\u0017-\\(viB,H/\u0006\u0002\u0002*A1\u00111FA\u0019\u0003ki!!!\f\u000b\u0007\u0005=B$\u0001\u0004g_Jl\u0017\r^\u0005\u0005\u0003g\tiC\u0001\u0007TiJ,\u0017-\\(viB,H\u000fE\u0003[\u0003o\tY$C\u0002\u0002:m\u0013Q!\u0011:sCf\u0004B!!\u0010\u0002L5\u0011\u0011q\b\u0006\u0005\u0003\u0003\n\u0019%\u0001\u0005eCR\f'-\u001b8e\u0015\u0011\t)%a\u0012\u0002\u000f)\f7m[:p]*\u0019\u0011\u0011J=\u0002\u0013\u0019\f7\u000f^3sq6d\u0017\u0002BA'\u0003\u007f\u0011\u0001BS:p]:{G-Z\u0001\u000bGV\u0014(/\u001a8u%><XCAA\u001b\u00039\u0019WO\u001d:f]R\u0014vn^0%KF$B!a\u0016\u0002^A\u0019!,!\u0017\n\u0007\u0005m3L\u0001\u0003V]&$\b\"CA0'\u0005\u0005\t\u0019AA\u001b\u0003\rAH%M\u0001\fGV\u0014(/\u001a8u%><\b%\u0001\u0003oKb$H#A-\u0002\u0007\u001d,G\u000fF\u0001:\u0003\u0019!WmY8eKR1\u0011qNA;\u0003s\u00022AWA9\u0013\r\t\u0019h\u0017\u0002\u0004\u0003:L\bbBA</\u0001\u0007\u00111H\u0001\tUN|gNT8eK\"9\u00111P\fA\u0002\u0005u\u0014aC:ueV\u001cGOR5fY\u0012\u0004B!a\u0001\u0002\u0000%!\u0011\u0011QA\u0003\u0005-\u0019FO];di\u001aKW\r\u001c3\u0002\u000b\rdwn]3\u0015\u0005\u0005]\u0003")
public class ClickHouseReader
implements PartitionReader<InternalRow>,
ClickHouseHelper,
SQLConfHelper {
    private NodesClient nodesClient;
    private StreamOutput<JsonNode[]> streamOutput;
    private final ScanJobDescription scanJob;
    private final ClickHouseInputPartition part;
    private final boolean readDistributedUseClusterNodes;
    private final boolean readDistributedConvertLocal;
    private final String database;
    private final String table;
    private final ClickHouseCompression codec;
    private JsonNode[] currentRow;
    private volatile Function1<String, BoxedUnit> DEFAULT_ACTION_IF_NO_SUCH_DATABASE;
    private volatile Function2<String, String, BoxedUnit> DEFAULT_ACTION_IF_NO_SUCH_TABLE;
    private transient Logger log;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public Option<Tuple2<String, String>> unwrap(Identifier ident) {
        return ClickHouseHelper.unwrap$(this, ident);
    }

    @Override
    public NodeSpec buildNodeSpec(CaseInsensitiveStringMap options) {
        return ClickHouseHelper.buildNodeSpec$(this, options);
    }

    @Override
    public Seq<ClusterSpec> queryClusterSpecs(NodeSpec nodeSpec, NodeClient nodeClient) {
        return ClickHouseHelper.queryClusterSpecs$(this, nodeSpec, nodeClient);
    }

    @Override
    public DatabaseSpec queryDatabaseSpec(String database, Function1<String, BoxedUnit> actionIfNoSuchDatabase, NodeClient nodeClient) {
        return ClickHouseHelper.queryDatabaseSpec$(this, database, actionIfNoSuchDatabase, nodeClient);
    }

    @Override
    public Function1<String, BoxedUnit> queryDatabaseSpec$default$2() {
        return ClickHouseHelper.queryDatabaseSpec$default$2$(this);
    }

    @Override
    public TableSpec queryTableSpec(String database, String table, Function2<String, String, BoxedUnit> actionIfNoSuchTable, NodeClient nodeClient, ZoneId tz) {
        return ClickHouseHelper.queryTableSpec$(this, database, table, actionIfNoSuchTable, nodeClient, tz);
    }

    @Override
    public Function2<String, String, BoxedUnit> queryTableSpec$default$3() {
        return ClickHouseHelper.queryTableSpec$default$3$(this);
    }

    @Override
    public StructType queryTableSchema(String database, String table, Function2<String, String, BoxedUnit> actionIfNoSuchTable, NodeClient nodeClient) {
        return ClickHouseHelper.queryTableSchema$(this, database, table, actionIfNoSuchTable, nodeClient);
    }

    @Override
    public Function2<String, String, BoxedUnit> queryTableSchema$default$3() {
        return ClickHouseHelper.queryTableSchema$default$3$(this);
    }

    @Override
    public Seq<PartitionSpec> queryPartitionSpec(String database, String table, NodeClient nodeClient) {
        return ClickHouseHelper.queryPartitionSpec$(this, database, table, nodeClient);
    }

    @Override
    public StructType getQueryOutputSchema(String sql, NodeClient nodeClient) {
        return ClickHouseHelper.getQueryOutputSchema$(this, sql, nodeClient);
    }

    @Override
    public boolean dropPartition(String database, String table, String partitionExpr, Option<String> cluster, NodeClient nodeClient) {
        return ClickHouseHelper.dropPartition$(this, database, table, partitionExpr, cluster, nodeClient);
    }

    @Override
    public Option<String> dropPartition$default$4() {
        return ClickHouseHelper.dropPartition$default$4$(this);
    }

    @Override
    public boolean delete(String database, String table, String deleteExpr, Option<String> cluster, NodeClient nodeClient) {
        return ClickHouseHelper.delete$(this, database, table, deleteExpr, cluster, nodeClient);
    }

    @Override
    public Option<String> delete$default$4() {
        return ClickHouseHelper.delete$default$4$(this);
    }

    @Override
    public boolean truncateTable(String database, String table, Option<String> cluster, NodeClient nodeClient) {
        return ClickHouseHelper.truncateTable$(this, database, table, cluster, nodeClient);
    }

    @Override
    public Option<String> truncateTable$default$3() {
        return ClickHouseHelper.truncateTable$default$3$(this);
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    public CustomTaskMetric[] currentMetricsValues() {
        return super.currentMetricsValues();
    }

    private Function1<String, BoxedUnit> DEFAULT_ACTION_IF_NO_SUCH_DATABASE$lzycompute() {
        ClickHouseReader clickHouseReader = this;
        synchronized (clickHouseReader) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.DEFAULT_ACTION_IF_NO_SUCH_DATABASE = ClickHouseHelper.DEFAULT_ACTION_IF_NO_SUCH_DATABASE$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.DEFAULT_ACTION_IF_NO_SUCH_DATABASE;
    }

    @Override
    public Function1<String, BoxedUnit> DEFAULT_ACTION_IF_NO_SUCH_DATABASE() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.DEFAULT_ACTION_IF_NO_SUCH_DATABASE$lzycompute() : this.DEFAULT_ACTION_IF_NO_SUCH_DATABASE;
    }

    private Function2<String, String, BoxedUnit> DEFAULT_ACTION_IF_NO_SUCH_TABLE$lzycompute() {
        ClickHouseReader clickHouseReader = this;
        synchronized (clickHouseReader) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.DEFAULT_ACTION_IF_NO_SUCH_TABLE = ClickHouseHelper.DEFAULT_ACTION_IF_NO_SUCH_TABLE$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.DEFAULT_ACTION_IF_NO_SUCH_TABLE;
    }

    @Override
    public Function2<String, String, BoxedUnit> DEFAULT_ACTION_IF_NO_SUCH_TABLE() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.DEFAULT_ACTION_IF_NO_SUCH_TABLE$lzycompute() : this.DEFAULT_ACTION_IF_NO_SUCH_TABLE;
    }

    private Logger log$lzycompute() {
        ClickHouseReader clickHouseReader = this;
        synchronized (clickHouseReader) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    public boolean readDistributedUseClusterNodes() {
        return this.readDistributedUseClusterNodes;
    }

    public boolean readDistributedConvertLocal() {
        return this.readDistributedConvertLocal;
    }

    public String database() {
        return this.database;
    }

    public String table() {
        return this.table;
    }

    public ClickHouseCompression codec() {
        return this.codec;
    }

    public StructType readSchema() {
        return this.scanJob.readSchema();
    }

    private NodesClient nodesClient$lzycompute() {
        ClickHouseReader clickHouseReader = this;
        synchronized (clickHouseReader) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.nodesClient = NodesClient$.MODULE$.apply(this.part.candidateNodes());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.nodesClient;
    }

    private NodesClient nodesClient() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.nodesClient$lzycompute() : this.nodesClient;
    }

    public NodeClient nodeClient() {
        return this.nodesClient().node();
    }

    private StreamOutput<JsonNode[]> streamOutput$lzycompute() {
        ClickHouseReader clickHouseReader = this;
        synchronized (clickHouseReader) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                String selectItems = this.readSchema().isEmpty() ? "1" : ((TraversableOnce)this.readSchema().map((Function1 & Serializable & scala.Serializable)field -> $this.scanJob.groupByClause().isDefined() ? field.name() : new StringBuilder(2).append("`").append(field.name()).append("`").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
                NodeClient qual$1 = this.nodeClient();
                String x$1 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(87).append("SELECT ").append(selectItems).append("\n         |FROM `").append(this.database()).append("`.`").append(this.table()).append("`\n         |WHERE (").append(this.part.partFilterExpr()).append(") AND (").append(this.scanJob.filtersExpr()).append(")\n         |").append(this.scanJob.groupByClause().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("\n         |").append(this.scanJob.limit().map((Function1 & Serializable & scala.Serializable)n -> ClickHouseReader.$anonfun$streamOutput$3(BoxesRunTime.unboxToInt((Object)n))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("\n         |").toString())).stripMargin();
                ClickHouseCompression x$2 = this.codec();
                scala.collection.immutable.Map<String, String> x$3 = qual$1.syncStreamQueryAndCheckOutputJSONCompactEachRowWithNamesAndTypes$default$3();
                this.streamOutput = qual$1.syncStreamQueryAndCheckOutputJSONCompactEachRowWithNamesAndTypes(x$1, x$2, x$3);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.streamOutput;
    }

    public StreamOutput<JsonNode[]> streamOutput() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.streamOutput$lzycompute() : this.streamOutput;
    }

    private JsonNode[] currentRow() {
        return this.currentRow;
    }

    private void currentRow_$eq(JsonNode[] x$1) {
        this.currentRow = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean next() {
        void var1_1;
        block0: {
            boolean hasNext = this.streamOutput().hasNext();
            if (!hasNext) break block0;
            this.currentRow_$eq((JsonNode[])this.streamOutput().next());
        }
        return (boolean)var1_1;
    }

    public InternalRow get() {
        return InternalRow$.MODULE$.fromSeq((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.currentRow())).zip((GenIterable)this.readSchema(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            JsonNode jsonNode = (JsonNode)tuple2._1();
            StructField structField = (StructField)tuple2._2();
            Object object = this.decode(jsonNode, structField);
            return object;
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object decode(JsonNode jsonNode, StructField structField) {
        if (jsonNode == null) return null;
        if (jsonNode.isNull()) {
            return null;
        }
        DataType dataType = structField.dataType();
        if (BooleanType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToBoolean((boolean)jsonNode.asBoolean());
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToByte((byte)((byte)jsonNode.asInt()));
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToShort((short)((short)jsonNode.asInt()));
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToInteger((int)jsonNode.asInt());
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToLong((long)jsonNode.asLong());
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToFloat((float)((float)jsonNode.asDouble()));
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToDouble((double)jsonNode.asDouble());
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            return Decimal$.MODULE$.apply(BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(jsonNode.decimalValue()).setScale(decimalType.scale(), BigDecimal.RoundingMode$.MODULE$.HALF_UP()));
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToLong((long)(ZonedDateTime.parse(jsonNode.asText(), Utils$.MODULE$.dateTimeFmt().withZone(this.scanJob.tz())).withZoneSameInstant(ZoneOffset.UTC).toEpochSecond() * 1000L * 1000L));
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return UTF8String.fromString((String)jsonNode.asText());
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToInteger((int)((int)LocalDate.parse(jsonNode.asText(), Utils$.MODULE$.dateFmt()).toEpochDay()));
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return jsonNode.binaryValue();
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType _dataType = arrayType.elementType();
            boolean _nullable = arrayType.containsNull();
            StructField _structField = new StructField(new StringBuilder(17).append(structField.name()).append("__array_element__").toString(), _dataType, _nullable, StructField$.MODULE$.apply$default$4());
            return new GenericArrayData(((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)jsonNode).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> this.decode((JsonNode)x$1, _structField), Iterable$.MODULE$.canBuildFrom()));
        }
        if (!(dataType instanceof MapType)) throw new CHClientException(new StringBuilder(28).append("Unsupported catalyst type ").append(structField.name()).append("[").append(structField.dataType()).append("]").toString(), CHClientException$.MODULE$.apply$default$2(), CHClientException$.MODULE$.apply$default$3());
        MapType mapType = (MapType)dataType;
        DataType dataType2 = mapType.keyType();
        DataType _valueType = mapType.valueType();
        boolean _valueNullable = mapType.valueContainsNull();
        if (!StringType$.MODULE$.equals(dataType2)) throw new CHClientException(new StringBuilder(28).append("Unsupported catalyst type ").append(structField.name()).append("[").append(structField.dataType()).append("]").toString(), CHClientException$.MODULE$.apply$default$2(), CHClientException$.MODULE$.apply$default$3());
        scala.collection.immutable.Map mapData = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(jsonNode.fields()).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> {
            StructField _structField = new StructField(new StringBuilder(13).append(structField.name()).append("__map_value__").toString(), _valueType, _valueNullable, StructField$.MODULE$.apply$default$4());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)UTF8String.fromString((String)((String)entry.getKey()))), this.decode((JsonNode)entry.getValue(), _structField));
        }).toMap(Predef$.MODULE$.$conforms());
        return ArrayBasedMapData$.MODULE$.apply((Map)mapData, ArrayBasedMapData$.MODULE$.apply$default$2(), ArrayBasedMapData$.MODULE$.apply$default$3());
    }

    public void close() {
        this.nodesClient().close();
    }

    public static final /* synthetic */ String $anonfun$streamOutput$3(int n) {
        return new StringBuilder(6).append("LIMIT ").append(n).toString();
    }

    public ClickHouseReader(ScanJobDescription scanJob, ClickHouseInputPartition part) {
        this.scanJob = scanJob;
        this.part = part;
        Logging.$init$(this);
        ClickHouseHelper.$init$(this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        this.readDistributedUseClusterNodes = BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(ClickHouseSQLConf$.MODULE$.READ_DISTRIBUTED_USE_CLUSTER_NODES()));
        this.readDistributedConvertLocal = BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(ClickHouseSQLConf$.MODULE$.READ_DISTRIBUTED_CONVERT_LOCAL()));
        this.database = part.table().database();
        this.table = part.table().name();
        this.codec = scanJob.readOptions().compressionCodec();
    }
}

