/*
 * Decompiled with CFR 0.152.
 */
package xenon.clickhouse.write.format;

import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.clickhouse.SparkUtils$;
import org.apache.spark.sql.execution.arrow.ArrowWriter;
import org.apache.spark.sql.execution.arrow.ArrowWriter$;
import scala.reflect.ScalaSignature;
import xenon.clickhouse.write.ClickHouseWriter;
import xenon.clickhouse.write.WriteJobDescription;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001\u0002\t\u0012\u0001iA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\u0006G\u0001!\t\u0001\n\u0005\u0006%\u0001!\t\u0005\u000b\u0005\bm\u0001\u0011\r\u0011\"\u00018\u0011\u0019!\u0005\u0001)A\u0005q!9Q\t\u0001b\u0001\n\u00031\u0005BB)\u0001A\u0003%q\tC\u0004S\u0001\t\u0007I\u0011A*\t\ra\u0003\u0001\u0015!\u0003U\u0011\u001dI\u0006A1A\u0005\u0002iCaA\u001a\u0001!\u0002\u0013Y\u0006\"B4\u0001\t\u0003B\u0007\"B;\u0001\t\u00032\b\"B?\u0001\t\u0003r\b\"B@\u0001\t\u0003r(aG\"mS\u000e\\\u0007j\\;tK\u0006\u0013(o\\<TiJ,\u0017-\\,sSR,'O\u0003\u0002\u0013'\u00051am\u001c:nCRT!\u0001F\u000b\u0002\u000b]\u0014\u0018\u000e^3\u000b\u0005Y9\u0012AC2mS\u000e\\\u0007n\\;tK*\t\u0001$A\u0003yK:|gn\u0001\u0001\u0014\u0005\u0001Y\u0002C\u0001\u000f\u001e\u001b\u0005\u0019\u0012B\u0001\u0010\u0014\u0005A\u0019E.[2l\u0011>,8/Z,sSR,'/\u0001\u0005xe&$XMS8c!\ta\u0012%\u0003\u0002#'\t\u0019rK]5uK*{'\rR3tGJL\u0007\u000f^5p]\u00061A(\u001b8jiz\"\"!J\u0014\u0011\u0005\u0019\u0002Q\"A\t\t\u000b}\u0011\u0001\u0019\u0001\u0011\u0016\u0003%\u0002\"AK\u001a\u000f\u0005-\n\u0004C\u0001\u00170\u001b\u0005i#B\u0001\u0018\u001a\u0003\u0019a$o\\8u})\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\u00051\u0001K]3eK\u001aL!\u0001N\u001b\u0003\rM#(/\u001b8h\u0015\t\u0011t&A\u0005bY2|7-\u0019;peV\t\u0001\b\u0005\u0002:\u00056\t!H\u0003\u0002<y\u00051Q.Z7pefT!!\u0010 \u0002\u000b\u0005\u0014(o\\<\u000b\u0005}\u0002\u0015AB1qC\u000eDWMC\u0001B\u0003\ry'oZ\u0005\u0003\u0007j\u0012qBQ;gM\u0016\u0014\u0018\t\u001c7pG\u0006$xN]\u0001\u000bC2dwnY1u_J\u0004\u0013aC1se><8k\u00195f[\u0006,\u0012a\u0012\t\u0003\u0011>k\u0011!\u0013\u0006\u0003\u0015.\u000bA\u0001]8k_*\u0011A*T\u0001\u0006if\u0004Xm\u001d\u0006\u0003\u001dr\naA^3di>\u0014\u0018B\u0001)J\u0005\u0019\u00196\r[3nC\u0006a\u0011M\u001d:poN\u001b\u0007.Z7bA\u0005!!o\\8u+\u0005!\u0006CA+W\u001b\u0005i\u0015BA,N\u0005A1Vm\u0019;peN\u001b\u0007.Z7b%>|G/A\u0003s_>$\b%A\u0006beJ|wo\u0016:ji\u0016\u0014X#A.\u0011\u0005q#W\"A/\u000b\u0005ur&BA0a\u0003%)\u00070Z2vi&|gN\u0003\u0002bE\u0006\u00191/\u001d7\u000b\u0005\rt\u0014!B:qCJ\\\u0017BA3^\u0005-\t%O]8x/JLG/\u001a:\u0002\u0019\u0005\u0014(o\\<Xe&$XM\u001d\u0011\u0002\u0011]\u0014\u0018\u000e^3S_^$\"![7\u0011\u0005)\\W\"A\u0018\n\u00051|#\u0001B+oSRDQA\u001c\u0007A\u0002=\faA]3d_J$\u0007C\u00019t\u001b\u0005\t(B\u0001:a\u0003!\u0019\u0017\r^1msN$\u0018B\u0001;r\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u0017\u0011|7+\u001a:jC2L'0\u001a\u000b\u0002oB\u0019!\u000e\u001f>\n\u0005e|#!B!se\u0006L\bC\u00016|\u0013\taxF\u0001\u0003CsR,\u0017!\u0002:fg\u0016$H#A5\u0002\u000b\rdwn]3")
public class ClickHouseArrowStreamWriter
extends ClickHouseWriter {
    private final BufferAllocator allocator = SparkUtils$.MODULE$.spawnArrowAllocator("writer for ClickHouse");
    private final Schema arrowSchema;
    private final VectorSchemaRoot root;
    private final ArrowWriter arrowWriter;

    @Override
    public String format() {
        return "ArrowStream";
    }

    public BufferAllocator allocator() {
        return this.allocator;
    }

    public Schema arrowSchema() {
        return this.arrowSchema;
    }

    public VectorSchemaRoot root() {
        return this.root;
    }

    public ArrowWriter arrowWriter() {
        return this.arrowWriter;
    }

    @Override
    public void writeRow(InternalRow record) {
        this.arrowWriter().write(record);
    }

    @Override
    public byte[] doSerialize() {
        this.arrowWriter().finish();
        ArrowStreamWriter arrowStreamWriter = new ArrowStreamWriter(this.root(), null, this.output());
        arrowStreamWriter.writeBatch();
        arrowStreamWriter.end();
        this.output().flush();
        this.output().close();
        return this.serializedBuffer().toByteArray();
    }

    @Override
    public void reset() {
        super.reset();
        this.arrowWriter().reset();
    }

    @Override
    public void close() {
        this.root().close();
        this.allocator().close();
        super.close();
    }

    public ClickHouseArrowStreamWriter(WriteJobDescription writeJob) {
        super(writeJob);
        this.arrowSchema = SparkUtils$.MODULE$.toArrowSchema(this.revisedDataSchema(), writeJob.tz().getId());
        this.root = VectorSchemaRoot.create((Schema)this.arrowSchema(), (BufferAllocator)this.allocator());
        this.arrowWriter = ArrowWriter$.MODULE$.create(this.root());
    }
}

