/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.id;

import com.github.hugh.util.DateUtils;
import com.github.hugh.util.EmptyUtils;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.HashMap;
import java.util.Map;

public class Snowflake {
    private static final long START_STMP = 1288834974657L;
    private static final long SEQUENCE_BIT = 12L;
    private static final long MACHINE_BIT = 5L;
    private static final long DATA_CENTER_BIT = 5L;
    private static final long MAX_DATA_CENTER_NUM = 31L;
    private static final long MAX_MACHINE_NUM = 31L;
    private static final long MAX_SEQUENCE = 4095L;
    private static final long MACHINE_LEFT = 12L;
    private static final long DATA_CENTER_LEFT = 17L;
    private static final long TIMESTMP_LEFT = 22L;
    private long dataCenterId;
    private long machineId;
    private long sequence = 0L;
    private long lastStmp = -1L;

    public Snowflake() {
        this.dataCenterId = Snowflake.getDataCenterId(31L);
        this.machineId = Snowflake.getMaxWorkerId(this.dataCenterId, 31L);
    }

    public Snowflake(long dataCenterId, long machineId) {
        if (dataCenterId > 31L || dataCenterId < 0L) {
            throw new IllegalArgumentException("dataCenterId can't be greater than MAX_DATA_CENTER_NUM or less than 0");
        }
        if (machineId > 31L || machineId < 0L) {
            throw new IllegalArgumentException("machineId can't be greater than MAX_MACHINE_NUM or less than 0");
        }
        this.dataCenterId = dataCenterId;
        this.machineId = machineId;
    }

    protected static long getMaxWorkerId(long dataCenterId, long maxWorkerId) {
        StringBuilder mpid = new StringBuilder();
        mpid.append(dataCenterId);
        String name = ManagementFactory.getRuntimeMXBean().getName();
        if (EmptyUtils.isNotEmpty(name)) {
            mpid.append(name.split("@")[0]);
        }
        return (long)(mpid.toString().hashCode() & 0xFFFF) % (maxWorkerId + 1L);
    }

    private static long getDataCenterId(long maxDataCenterId) {
        long id = 0L;
        try {
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            if (network == null) {
                id = 1L;
            } else {
                byte[] mac = network.getHardwareAddress();
                if (null != mac) {
                    id = (0xFFL & (long)mac[mac.length - 1] | 0xFF00L & (long)mac[mac.length - 2] << 8) >> 6;
                    id %= maxDataCenterId + 1L;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return id;
    }

    public synchronized long nextId() {
        long currStmp = this.timeGen();
        if (currStmp < this.lastStmp) {
            throw new RuntimeException("Clock moved backwards.  Refusing to generate id");
        }
        if (currStmp == this.lastStmp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                currStmp = this.getNextMill();
            }
        } else {
            this.sequence = 0L;
        }
        this.lastStmp = currStmp;
        long time = currStmp - 1288834974657L << 22;
        return time | this.dataCenterId << 17 | this.machineId << 12 | this.sequence;
    }

    private long getNextMill() {
        long mill = this.timeGen();
        while (mill <= this.lastStmp) {
            mill = this.timeGen();
        }
        return mill;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }

    public static Map<String, Object> decompile(long id) {
        String binaryId = Long.toBinaryString(id);
        int len = binaryId.length();
        int sequenceStart = (int)((long)len < 12L ? 0L : (long)len - 12L);
        int workerStart = (int)((long)len < 17L ? 0L : (long)len - 17L);
        int timeStart = (int)((long)len < 22L ? 0L : (long)len - 22L);
        String sequence = binaryId.substring(sequenceStart, len);
        String workerId = sequenceStart == 0 ? "0" : binaryId.substring(workerStart, sequenceStart);
        String dataCenterId = workerStart == 0 ? "0" : binaryId.substring(timeStart, workerStart);
        String time = timeStart == 0 ? "0" : binaryId.substring(0, timeStart);
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put("sequence", Integer.valueOf(sequence, 2));
        item.put("workerId", Integer.valueOf(workerId, 2));
        item.put("dataCenter", Integer.valueOf(dataCenterId, 2));
        long diffTime = Long.parseLong(time, 2);
        long timeLong = diffTime + 1288834974657L;
        item.put("date", DateUtils.formatTimestamp(timeLong));
        return item;
    }
}

