/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.id;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class Uuid {
    private static final char[] CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();

    public static String genId(int size) {
        List<String> uuidUnits = Uuid.uuidUnits(size);
        StringBuilder stringBuilder = new StringBuilder();
        for (String unit : uuidUnits) {
            int x = Integer.parseInt(unit, 16);
            stringBuilder.append(CHARS[x % 62]);
        }
        return stringBuilder.toString();
    }

    private static List<String> uuidUnits(int size) {
        UUID uuid = UUID.randomUUID();
        String uuid32 = uuid.toString().replace("-", "");
        ArrayList<String> units = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            units.add(uuid32.substring(i * 2, i * 2 + 2));
        }
        return units;
    }
}

