/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.support.instance;

import com.github.hugh.util.common.AssertUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;

public class Instance {
    private static volatile Instance instance;
    private static CacheLoader<String, Object> INSTANCE_CACHE_LOADER;
    public static LoadingCache<String, Object> SINGLETON_CACHE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Instance getInstance() {
        if (instance != null) return instance;
        Class<Instance> clazz = Instance.class;
        synchronized (Instance.class) {
            if (instance != null) return instance;
            instance = new Instance();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public <T> T singleton(Class<T> tClass) {
        AssertUtils.notNull(tClass, "class");
        String fullClassName = tClass.getName();
        try {
            return (T)SINGLETON_CACHE.get((Object)fullClassName);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        INSTANCE_CACHE_LOADER = CacheLoader.from(key -> {
            try {
                return Class.forName(key).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                return null;
            }
        });
        SINGLETON_CACHE = CacheBuilder.newBuilder().build(INSTANCE_CACHE_LOADER);
    }
}

