/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.util;

import com.github.hugh.model.dto.GgaDTO;
import com.github.hugh.model.dto.GpsDTO;
import com.github.hugh.util.DoubleMathUtils;
import com.github.hugh.util.EmptyUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class CoordinatesUtils {
    private static final double pi = Math.PI;
    private static final double CALC_PI = 52.35987755982988;
    private static final DecimalFormat decimalFormat = new DecimalFormat("#.00000000");

    public static GpsDTO gcj02ToBd09(double longitude, double latitude) {
        double z = Math.sqrt(longitude * longitude + latitude * latitude) + 2.0E-5 * Math.sin(latitude * 52.35987755982988);
        double theta = Math.atan2(latitude, longitude) + 3.0E-6 * Math.cos(longitude * 52.35987755982988);
        double bdlon = z * Math.cos(theta) + 0.0065;
        double bdlat = z * Math.sin(theta) + 0.006;
        return new GpsDTO(Double.parseDouble(decimalFormat.format(bdlat)), Double.parseDouble(decimalFormat.format(bdlon)));
    }

    public static GpsDTO bd09ToGcj02(double longitude, double latitude) {
        double x = longitude - 0.0065;
        double y = latitude - 0.006;
        double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * 52.35987755982988);
        double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * 52.35987755982988);
        String gcjLon = decimalFormat.format(z * Math.cos(theta));
        String gcjLat = decimalFormat.format(z * Math.sin(theta));
        return new GpsDTO(Double.parseDouble(gcjLon), Double.parseDouble(gcjLat));
    }

    public static String formatDegreeMinutes(double degreeMinutes) {
        double number = Math.floor(degreeMinutes / 100.0);
        String number2 = String.valueOf(degreeMinutes / 100.0);
        number2 = number2.substring(number2.indexOf("."));
        double v = Double.parseDouble("0" + number2) * 100.0;
        double number3 = DoubleMathUtils.div(v, 60.0, 8);
        BigDecimal b1 = new BigDecimal(Double.toString(number));
        BigDecimal b2 = new BigDecimal(Double.toString(number3));
        return b2.add(b1).toString();
    }

    public static GgaDTO parseGga(String gga) {
        if (EmptyUtils.isEmpty(gga)) {
            return null;
        }
        GgaDTO ggaDTO = new GgaDTO();
        String[] arr = gga.split(",");
        block15: for (int i = 0; i < arr.length; ++i) {
            String str = arr[i];
            switch (i) {
                case 0: {
                    ggaDTO.setName(str);
                    continue block15;
                }
                case 1: {
                    ggaDTO.setDate(str);
                    continue block15;
                }
                case 2: {
                    ggaDTO.setLatitude(str);
                    continue block15;
                }
                case 3: {
                    ggaDTO.setLatitudeBearing(str);
                    continue block15;
                }
                case 4: {
                    ggaDTO.setLongitude(str);
                    continue block15;
                }
                case 5: {
                    ggaDTO.setLongitudeBearing(str);
                    continue block15;
                }
                case 6: {
                    ggaDTO.setGpsStatus(str);
                    continue block15;
                }
                case 7: {
                    ggaDTO.setNumberOfSatellites(str);
                    continue block15;
                }
                case 8: {
                    ggaDTO.setHdopHorizontalAccuracyFactor(str);
                    continue block15;
                }
                case 9: {
                    ggaDTO.setAltitude(str);
                    continue block15;
                }
                case 10: {
                    ggaDTO.setWaterSurfaceAltitude(str);
                    continue block15;
                }
                case 11: {
                    ggaDTO.setDifferentialTime(str);
                    continue block15;
                }
                case 12: {
                    ggaDTO.setDifferentialStationId(str);
                    continue block15;
                }
            }
        }
        ggaDTO.setCalibrationValue(arr[arr.length - 1]);
        return ggaDTO;
    }
}

