/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.util;

import com.github.hugh.constant.DateCode;
import com.github.hugh.exception.ToolboxException;
import com.github.hugh.util.EmptyUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateUtils
extends DateCode {
    private DateUtils() {
    }

    public static String ofPattern(Date date) {
        return DateUtils.format(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String format(Date date) {
        return DateUtils.format(date, "yyyy-MM-dd");
    }

    public static String format(Date date, String pattern) {
        if (date == null) {
            return null;
        }
        if (pattern == null) {
            return DateUtils.format(date);
        }
        return new SimpleDateFormat(pattern).format(date);
    }

    public static String getDate() {
        return DateUtils.format(new Date());
    }

    public static String getDateSign() {
        return DateUtils.format(new Date(), "yyyyMMdd");
    }

    public static String getDate(String format) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        return simpleDateFormat.format(new Date());
    }

    public static Date getDate(int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, day);
        DateUtils.set(calendar, 0, 0, 0, 0);
        return calendar.getTime();
    }

    public static String toStringTime(String dateTime) {
        if (dateTime == null) {
            return "";
        }
        return dateTime.replace("-", "").replace(" ", "").replace(":", "");
    }

    public static String toStringDate(String strDate) {
        if (strDate == null) {
            return "";
        }
        String reg = "(\\d{4})(\\d{2})(\\d{2})(\\d{2})(\\d{2})(\\d{2})";
        return strDate.replaceAll(reg, "$1-$2-$3 $4:$5:$6");
    }

    public static <T> Date parse(T value) {
        return DateUtils.parse(value, "yyyy-MM-dd HH:mm:ss");
    }

    public static <T> Date parse(T value, String format) {
        if (value instanceof Date) {
            return (Date)value;
        }
        return DateUtils.parseDate(String.valueOf(value), format);
    }

    public static Date parseDate(String dateStr) {
        return DateUtils.parseDate(dateStr, "yyyy-MM-dd");
    }

    public static Date parseDate(String dateStr, String format) {
        if (EmptyUtils.isEmpty(dateStr)) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        try {
            return simpleDateFormat.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String formatTimestamp(long timestamp) {
        return DateUtils.formatTimestamp(timestamp, "yyyy-MM-dd HH:mm:ss");
    }

    public static String formatTimestamp(long timestamp, String format) {
        if (timestamp < 0L) {
            return null;
        }
        return new SimpleDateFormat(format).format(timestamp);
    }

    public static Date parseTimestamp(long timestamp) {
        if (timestamp < 0L) {
            return null;
        }
        String strTime = DateUtils.formatTimestamp(timestamp);
        return DateUtils.parse(strTime);
    }

    public static boolean isThisTime(long time, String pattern) {
        Date date = new Date(time);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        String param = simpleDateFormat.format(date);
        String now = simpleDateFormat.format(new Date());
        return param.equals(now);
    }

    public static Date getDayBeforeStartTime() {
        Date date = new Date();
        String dateStr = DateUtils.format(date, "yyyy-MM-dd");
        return DateUtils.getDayBeforeStartTime(dateStr);
    }

    public static Date getDayBeforeStartTime(String dateStr) {
        Calendar calendar = Calendar.getInstance();
        Date date = DateUtils.parseDate(dateStr, "yyyy-MM-dd");
        if (date == null) {
            return null;
        }
        calendar.setTime(date);
        calendar.add(5, -1);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getDayBeforeEndTime() {
        Date date = new Date();
        String dateStr = DateUtils.format(date, "yyyy-MM-dd");
        return DateUtils.getDayBeforeEndTime(dateStr);
    }

    public static Date getDayBeforeEndTime(String dateStr) {
        Calendar calendar = Calendar.getInstance();
        Date date = DateUtils.parseDate(dateStr, "yyyy-MM-dd");
        if (date == null) {
            return null;
        }
        calendar.setTime(date);
        calendar.add(5, -1);
        calendar.set(10, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static boolean isSameMonth(Date beginDate, Date endDate) {
        try {
            Calendar cal1 = Calendar.getInstance();
            cal1.setTime(beginDate);
            int month1 = cal1.get(2) + 1;
            Calendar cal2 = Calendar.getInstance();
            cal2.setTime(endDate);
            int month2 = cal2.get(2) + 1;
            boolean isSameYear = cal1.get(1) == cal2.get(1);
            return isSameYear && month1 == month2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String setMonthFirstDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        } else {
            calendar.setTime(new Date());
        }
        calendar.add(2, 0);
        calendar.set(5, 1);
        return DateUtils.format(calendar.getTime(), "yyyy-MM-dd HH:mm:ss");
    }

    public static String setMonthLastDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        } else {
            calendar.setTime(new Date());
        }
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return DateUtils.format(calendar.getTime(), "yyyy-MM-dd HH:mm:ss");
    }

    public static Date getMonthBeforeStartTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getMonthBeforeEndTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        calendar.set(5, calendar.getActualMaximum(5));
        DateUtils.set(calendar, 23, 59, 59, 999);
        return calendar.getTime();
    }

    public static Date getStartTime(String dateStr) {
        Date date = EmptyUtils.isEmpty(dateStr) ? new Date() : DateUtils.parseDate(dateStr, "yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.set(calendar, 0, 0, 0, 0);
        return calendar.getTime();
    }

    public static Date getTodayStartTime() {
        return DateUtils.getStartTime(null);
    }

    public static Date getEndTime(String dateStr) {
        Date date = EmptyUtils.isEmpty(dateStr) ? new Date() : DateUtils.parseDate(dateStr, "yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.set(calendar, 23, 59, 59, 999);
        return calendar.getTime();
    }

    public static Date getTodayEndTime() {
        return DateUtils.getEndTime(null);
    }

    public static Date getHourAgo() {
        return DateUtils.getHourAgo(null);
    }

    public static Date getHourAgo(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (date == null) {
            calendar.setTime(new Date());
        } else {
            calendar.setTime(date);
        }
        calendar.set(10, calendar.get(10) - 1);
        return calendar.getTime();
    }

    public static Date getOneMonthAgo() {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(2, -1);
        return c.getTime();
    }

    public static Date getWeekAgo() {
        return DateUtils.getWeekAgo(null);
    }

    public static Date getWeekAgo(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (date == null) {
            calendar.setTime(new Date());
        } else {
            calendar.setTime(date);
        }
        calendar.add(5, -7);
        return calendar.getTime();
    }

    public static Date setStartHouMinSec(String dateStr) {
        Date date = DateUtils.parseDate(dateStr, "yyyy-MM-dd");
        if (date == null) {
            throw new ToolboxException("data is null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date setEndHouMinSec(String dateStr) {
        Date date = DateUtils.parseDate(dateStr, "yyyy-MM-dd");
        if (date == null) {
            throw new ToolboxException("data is null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public static int getYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int getYear() {
        return LocalDateTime.now().getYear();
    }

    public static int getMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2) + 1;
    }

    public static int getMonth() {
        return LocalDateTime.now().getMonthValue();
    }

    public static int getDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static int getDay() {
        return LocalDateTime.now().getDayOfMonth();
    }

    public static String substring(String strDate) {
        if (EmptyUtils.isEmpty(strDate)) {
            return null;
        }
        return strDate.substring(0, 6);
    }

    public static boolean isEarlyMonth() {
        return DateUtils.isEarlyMonth(new Date());
    }

    public static boolean isEarlyMonth(Date date) {
        if (date == null) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5) == 1;
    }

    public static boolean isNowadays(Date date, String format) {
        if (date == null) {
            return false;
        }
        Date nowDate = new Date();
        String tem = DateUtils.format(nowDate, format);
        String tem1 = DateUtils.format(date, format);
        return tem.equals(tem1);
    }

    public static boolean checkTimeOut(Date date, int hour) {
        Date nowDate;
        long time;
        if (date == null || hour <= 0) {
            return true;
        }
        long mill = 3600000L;
        if (hour > 1) {
            mill = (long)hour * mill;
        }
        return (time = (nowDate = new Date()).getTime()) - date.getTime() > mill;
    }

    public static Date getStartDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.set(calendar, 0, 0, 0, 0);
        return calendar.getTime();
    }

    public static Date getEndDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.set(calendar, 23, 59, 59, 999);
        return calendar.getTime();
    }

    public static boolean exceedSystem(Date date) {
        if (date == null) {
            return true;
        }
        Date current = new Date();
        return date.getTime() > current.getTime();
    }

    public static boolean belowSystem(Date date) {
        if (date == null) {
            return true;
        }
        Date current = new Date();
        return date.getTime() < current.getTime();
    }

    public static Date getMonthStartTime() {
        return DateUtils.getMonthStartTime(new Date());
    }

    public static Date getMonthStartTime(Date date) {
        if (date == null) {
            return null;
        }
        int month = DateUtils.getMonth(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, month - 1);
        calendar.set(5, 1);
        DateUtils.set(calendar, 0, 0, 0, 0);
        return calendar.getTime();
    }

    public static Date getMonthEndTime(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int month = DateUtils.getMonth(date);
        calendar.set(2, month - 1);
        calendar.set(5, calendar.getActualMaximum(5));
        DateUtils.set(calendar, 23, 59, 59, 999);
        return calendar.getTime();
    }

    public static boolean isToday(Date date) {
        if (date == null) {
            return false;
        }
        String time = DateUtils.format(date, "yyyy-MM-dd HH:mm:ss");
        return DateUtils.isToday(time, "yyyy-MM-dd HH:mm:ss");
    }

    public static boolean isToday(String time) {
        return DateUtils.isToday(time, "yyyy-MM-dd HH:mm:ss");
    }

    public static boolean isToday(String time, String formatStr) {
        Date date = DateUtils.parseDate(time, formatStr);
        if (date == null) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year1 = calendar.get(1);
        int month1 = calendar.get(2) + 1;
        int day1 = calendar.get(5);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(new Date());
        int year2 = c2.get(1);
        int month2 = c2.get(2) + 1;
        int day2 = c2.get(5);
        return year1 == year2 && month1 == month2 && day1 == day2;
    }

    public static boolean isValidDate(String time, String format) {
        if (EmptyUtils.isEmpty(time) || EmptyUtils.isEmpty(format)) {
            return false;
        }
        try {
            Date date = DateUtils.parseDate(time, format);
            return time.equals(DateUtils.format(date, format));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Date getIniHour() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getEndHour() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static boolean lessThanStartDate(Date start, Date end) {
        if (start == null) {
            throw new ToolboxException(" start date is null ! ");
        }
        if (end == null) {
            throw new ToolboxException(" end date is null ! ");
        }
        return end.getTime() < start.getTime();
    }

    public static boolean greaterThanStartDate(Date start, Date end) {
        if (start == null) {
            throw new ToolboxException(" start date is null ! ");
        }
        if (end == null) {
            throw new ToolboxException(" end date is null ! ");
        }
        return end.getTime() > start.getTime();
    }

    public static boolean isDateFormat(String timeStr) {
        return DateUtils.isDateFormat(timeStr, "yyyy-MM-dd HH:mm:ss");
    }

    public static boolean isDateFormat(String timeStr, String pattern) {
        if (EmptyUtils.isEmpty(timeStr)) {
            return false;
        }
        try {
            String regex = "yyyy-MM".equals(pattern) ? "\\d{4}-\\d{2}" : ("yyyy-MM-dd".equals(pattern) ? "\\d{4}-\\d{2}-\\d{2}" : "\\d{4}-\\d{2}-\\d{2}\\s{1}\\d{2}:\\d{2}:\\d{2}");
            Pattern patternObj = Pattern.compile(regex);
            Matcher matcher = patternObj.matcher(timeStr);
            if (matcher.matches()) {
                Date date = DateUtils.parseDate(timeStr, pattern);
                return timeStr.equals(DateUtils.format(date, pattern));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void set(Calendar calendar, int hour, int minute, int second, int milliSecond) {
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, milliSecond);
    }

    public static boolean isValidDate(Date date) {
        return DateUtils.isValidDate(date, 30);
    }

    public static boolean isValidDate(Date date, int day) {
        if (date == null) {
            return false;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String nowDate = format.format(new Date());
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -day);
        String minDate = format.format(calendar.getTime());
        try {
            format.setLenient(false);
            String strDate = format.format(date);
            return nowDate.compareTo(strDate) >= 0 && strDate.compareTo(minDate) >= 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isAcrossYear(String startStr, String endStr) {
        Date end;
        Date start;
        if (DateUtils.isDateFormat(startStr)) {
            start = DateUtils.parseDate(startStr, "yyyy-MM-dd HH:mm:ss");
        } else if (DateUtils.isDateFormat(startStr, "yyyy-MM-dd")) {
            start = DateUtils.parseDate(startStr);
        } else {
            return true;
        }
        if (DateUtils.isDateFormat(endStr)) {
            end = DateUtils.parseDate(endStr, "yyyy-MM-dd HH:mm:ss");
        } else if (DateUtils.isDateFormat(endStr, "yyyy-MM-dd")) {
            end = DateUtils.parseDate(endStr);
        } else {
            return true;
        }
        return DateUtils.isAcrossYear(start, end);
    }

    private static boolean isAcrossYear(Date start, Date end) {
        if (start == null) {
            return true;
        }
        int year = DateUtils.getYear(start);
        if (end == null) {
            end = new Date();
        }
        return year != DateUtils.getYear(end);
    }

    public static long getEarlyMorningSec() {
        long overTime;
        long now = System.currentTimeMillis();
        SimpleDateFormat sdfOne = new SimpleDateFormat("yyyy-MM-dd");
        try {
            overTime = (now - sdfOne.parse(sdfOne.format(now)).getTime()) / 1000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return -1L;
        }
        return 86400L - overTime;
    }

    public static Date dateStrToDate(String dataStr) {
        try {
            return new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US).parse(dataStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static long minutesDifference(Date begin, Date end) {
        if (begin == null) {
            throw new ToolboxException(" start date is null ! ");
        }
        if (end == null) {
            throw new ToolboxException(" end date is null ! ");
        }
        long between = (end.getTime() - begin.getTime()) / 1000L;
        return between / 60L;
    }

    public static Date getMin(Date date, int min) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, min);
        return calendar.getTime();
    }

    public static int secondsDifference(Date begin, Date end) {
        long a = end.getTime();
        long b = begin.getTime();
        return (int)((a - b) / 1000L);
    }
}

