/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class DoubleMathUtils {
    private static final int DEF_DIV_SCALE = 10;
    public static final NumberFormat numberFormat = NumberFormat.getNumberInstance();
    public static final NumberFormat numberGiveUp;

    private DoubleMathUtils() {
    }

    public static double add(double v1, double v2) {
        BigDecimal bigDecimal1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return bigDecimal1.add(b2).doubleValue();
    }

    public static double sub(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.subtract(b2).doubleValue();
    }

    public static double mul(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.multiply(b2).doubleValue();
    }

    public static double div(double v1, double v2) {
        return DoubleMathUtils.div(v1, v2, 10);
    }

    public static double div(double v1, double v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.divide(b2, scale, 4).doubleValue();
    }

    public static double round(double v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(Double.toString(v));
        BigDecimal one = new BigDecimal("1");
        return b.divide(one, scale, 4).doubleValue();
    }

    public static String getString(double number) {
        String numberStr;
        if ((int)number * 1000 == (int)(number * 1000.0)) {
            numberStr = String.valueOf((int)number);
        } else {
            DecimalFormat decimalFormat = new DecimalFormat("######0.00");
            numberStr = decimalFormat.format(number);
        }
        return numberStr;
    }

    static {
        int maximum = 2;
        numberFormat.setMaximumFractionDigits(maximum);
        numberFormat.setRoundingMode(RoundingMode.DOWN);
        numberFormat.setGroupingUsed(false);
        numberGiveUp = NumberFormat.getNumberInstance();
        maximum = 5;
        numberGiveUp.setMaximumFractionDigits(maximum);
        numberGiveUp.setRoundingMode(RoundingMode.DOWN);
        numberGiveUp.setGroupingUsed(false);
    }
}

