/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.util;

import com.github.binarywang.java.emoji.EmojiConverter;

public class EmojiUtils {
    private static final EmojiConverter emojiConverter = EmojiConverter.getInstance();

    private EmojiUtils() {
    }

    public static boolean isEmoji(String source) {
        int len = source.length();
        for (int i = 0; i < len; ++i) {
            char codePoint = source.charAt(i);
            if (EmojiUtils.notEmojiCharacter(codePoint)) continue;
            return true;
        }
        return false;
    }

    private static boolean notEmojiCharacter(char codePoint) {
        return codePoint == '\u0000' || codePoint == '\t' || codePoint == '\n' || codePoint == '\r' || codePoint >= ' ' && codePoint <= '\ud7ff' || codePoint >= '\ue000' && codePoint <= '\ufffd';
    }

    public static String toHtml(String value) {
        return emojiConverter.toHtml(value);
    }

    private static String replace(String value) {
        StringBuilder buf = new StringBuilder();
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char codePoint = value.charAt(i);
            if (EmojiUtils.notEmojiCharacter(codePoint)) {
                buf.append(codePoint);
                continue;
            }
            buf.append("\ue424");
        }
        return buf.toString();
    }

    public static String complete(String value) {
        String result = EmojiUtils.toHtml(value);
        if (EmojiUtils.isEmoji(result)) {
            return EmojiUtils.replace(result);
        }
        return result;
    }
}

