/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.util;

import com.github.hugh.exception.ToolboxException;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;

public class ListUtils {
    private static final CharMatcher LIST_CHAR_MATCHER = CharMatcher.anyOf((CharSequence)"[]\" \"");

    private ListUtils() {
    }

    public static <T> boolean isEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T> boolean isNotEmpty(Collection<T> collection) {
        return !ListUtils.isEmpty(collection);
    }

    public static <T> List<T> guavaPartitionList(List<T> originList, int page, int size) {
        if (ListUtils.isEmpty(originList)) {
            throw new ToolboxException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        List pagedList = Lists.partition(originList, (int)size);
        return (List)pagedList.get(page);
    }

    public static List<String> guavaStringToList(String string) {
        return ListUtils.guavaStringToList(string, ",");
    }

    public static List<String> guavaStringToList(String string, String separator) {
        return ListUtils.guavaStringToList(string, separator, LIST_CHAR_MATCHER);
    }

    public static List<String> guavaStringToList(String string, String separator, CharMatcher charMatcher) {
        return Splitter.on((String)separator).trimResults().trimResults(charMatcher).omitEmptyStrings().splitToList((CharSequence)string);
    }
}

