/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.util;

import com.github.hugh.exception.ToolboxException;
import com.github.hugh.util.DateUtils;
import com.github.hugh.util.EmptyUtils;
import com.github.hugh.util.common.AssertUtils;
import com.google.common.base.Splitter;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class MapUtils {
    public static <K, V> boolean isSuccess(Map<K, V> map, K key, String code) {
        if (map == null) {
            return false;
        }
        if (EmptyUtils.isEmpty(code)) {
            return false;
        }
        return code.equals(String.valueOf(map.get(key)));
    }

    public static <K, V> boolean isFailure(Map<K, V> map, K key, String code) {
        return !MapUtils.isSuccess(map, key, code);
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.size() == 0;
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !MapUtils.isEmpty(map);
    }

    @Deprecated
    public static Map<String, Object> cyclePar(HttpServletRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (request == null) {
            return map;
        }
        Enumeration isKey = request.getParameterNames();
        while (isKey.hasMoreElements()) {
            String key = (String)isKey.nextElement();
            String value = request.getParameter(key);
            map.put(key, value);
        }
        return map;
    }

    @Deprecated
    public static Map<String, Object> cycleQueryPar(HttpServletRequest request) {
        return MapUtils.cycleQueryPar(request, "page", "size");
    }

    @Deprecated
    public static Map<String, Object> cycleQueryPar(HttpServletRequest request, String ... keys) {
        Map<String, Object> map = MapUtils.cyclePar(request);
        for (String key : keys) {
            map.remove(key);
        }
        return map;
    }

    public static <T, K, V> T toEntityNotEmpty(Class<T> cls, Map<K, V> params) throws Exception {
        AssertUtils.notNull(cls, "class");
        T obj = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return MapUtils.convertObjects(obj, params, true);
    }

    public static <T, K, V> T toEntityNotEmpty(T object, Map<K, V> params) throws Exception {
        AssertUtils.notNull(object, "object");
        return MapUtils.convertObjects(object, params, true);
    }

    public static <T, K, V> T convertEntity(Class<T> cls, Map<K, V> params) throws Exception {
        AssertUtils.notNull(cls, "class");
        T obj = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return MapUtils.convertObjects(obj, params, false);
    }

    public static <T, K, V> T convertEntity(T object, Map<K, V> params) throws Exception {
        AssertUtils.notNull(object, "object");
        return MapUtils.convertObjects(object, params, false);
    }

    private static <T> T convertObjects(T bean, Map params, boolean empty) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        PropertyDescriptor[] propertyDescriptors;
        Class<?> aClass = bean.getClass();
        BeanInfo beanInfo = Introspector.getBeanInfo(aClass);
        for (PropertyDescriptor descriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
            boolean flag;
            String propertyName = descriptor.getName();
            Object value = params.get(propertyName);
            if (empty) {
                flag = EmptyUtils.isNotEmpty(value);
            } else {
                boolean bl = flag = value != null;
            }
            if (!flag) continue;
            switch (descriptor.getPropertyType().getSimpleName()) {
                case "String": {
                    break;
                }
                case "int": 
                case "Integer": {
                    value = Integer.parseInt(String.valueOf(value).strip());
                    break;
                }
                case "long": 
                case "Long": {
                    value = Long.parseLong(String.valueOf(value));
                    break;
                }
                case "double": 
                case "Double": {
                    value = Double.parseDouble(String.valueOf(value));
                    break;
                }
                case "Date": {
                    if (value instanceof Date || !DateUtils.isDateFormat(String.valueOf(value))) break;
                    value = DateUtils.parse(String.valueOf(value));
                    break;
                }
                case "List": {
                    String trim = MapUtils.trim(String.valueOf(value));
                    value = Splitter.on((String)",").trimResults().splitToList((CharSequence)trim);
                    break;
                }
                default: {
                    throw new ToolboxException("Unknown type : " + descriptor.getPropertyType().getSimpleName());
                }
            }
            descriptor.getWriteMethod().invoke(bean, value);
        }
        return bean;
    }

    private static String trim(String source) {
        if (EmptyUtils.isEmpty(source)) {
            return "";
        }
        String s1 = source.substring(1);
        return s1.substring(0, s1.length() - 1);
    }

    public static <K> String getString(Map<? super K, ?> map, K key) {
        return org.apache.commons.collections4.MapUtils.getString(map, key);
    }

    public static <K> Long getLong(Map<? super K, ?> map, K key) {
        return org.apache.commons.collections4.MapUtils.getLong(map, key);
    }

    public static <K> Integer getInt(Map<? super K, ?> map, K key) {
        return org.apache.commons.collections4.MapUtils.getInteger(map, key);
    }

    public static <K> Double getDouble(Map<? super K, ?> map, K key) {
        return org.apache.commons.collections4.MapUtils.getDouble(map, key);
    }

    public static <K> Map getMap(Map<? super K, ?> map, K key) {
        return org.apache.commons.collections4.MapUtils.getMap(map, key);
    }

    public static <K, V> void setValue(Map<? super K, V> map, K key, V value) {
        if (map == null) {
            return;
        }
        if (EmptyUtils.isEmpty(key) || EmptyUtils.isEmpty(value)) {
            return;
        }
        map.put(key, value);
    }

    public static <K, V> void removeKeys(Map<K, V> map, String ... keys) {
        if (keys == null) {
            return;
        }
        for (String key : keys) {
            map.remove(key);
        }
    }
}

