/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.util;

import com.github.hugh.exception.ToolboxException;
import com.github.hugh.support.instance.Instance;
import com.github.hugh.util.MapUtils;
import com.github.hugh.util.common.AssertUtils;
import com.github.hugh.util.gson.JsonObjectUtils;
import com.github.hugh.util.gson.JsonObjects;
import com.github.hugh.util.lang.UrlUtils;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.sf.json.JSONObject;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpUtils {
    private static final Logger log = LoggerFactory.getLogger(OkHttpUtils.class);
    private static final int CONNECT_TIMEOUT = 10;
    private static final int READ_TIMEOUT = 10;
    private static final String APPLICATION_FORM_URLENCODED_VALUE = "application/x-www-form-urlencoded";
    private static final String APPLICATION_JSON_UTF8_VALUE = "application/json;charset=UTF-8";
    private static final String MULTIPART_FORM_DATA = "multipart/form-data";
    private static final ConcurrentHashMap<String, List<Cookie>> COOKIE_STORE = new ConcurrentHashMap();
    private static final MediaType FORM_TYPE = MediaType.parse((String)"application/x-www-form-urlencoded");
    private static final MediaType JSON_TYPE = MediaType.get((String)"application/json;charset=UTF-8");
    private static final OkHttpClient COOKIE_CLIENT = new OkHttpClient.Builder().cookieJar(new CookieJar(){

        public void saveFromResponse(HttpUrl httpUrl, List<Cookie> list) {
            COOKIE_STORE.put(httpUrl.host(), list);
        }

        public List<Cookie> loadForRequest(HttpUrl httpUrl) {
            ArrayList cookies = COOKIE_STORE.get(httpUrl.host());
            return cookies != null ? cookies : new ArrayList();
        }
    }).connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).build();

    private OkHttpUtils() {
    }

    public static OkHttpClient buildClient() {
        return OkHttpUtils.buildClient(10, 10);
    }

    public static OkHttpClient buildClient(int connectTimeout, int readTimeout) {
        OkHttpClient client = Instance.getInstance().singleton(OkHttpClient.class);
        client.newBuilder().connectTimeout((long)connectTimeout, TimeUnit.SECONDS).readTimeout((long)readTimeout, TimeUnit.SECONDS).retryOnConnectionFailure(true).build();
        return client;
    }

    public static String postForm(String url) throws IOException {
        return OkHttpUtils.postForm(url, null, OkHttpUtils.buildClient());
    }

    public static <T> String postForm(String url, T params) throws IOException {
        return OkHttpUtils.postForm(url, JSONObject.fromObject(params), OkHttpUtils.buildClient());
    }

    public static <T> String postForm(String url, T params, OkHttpClient okHttpClient) throws IOException {
        AssertUtils.notEmpty(url, "url");
        JSONObject jsonObject = JSONObject.fromObject(params);
        String urlParams = UrlUtils.jsonParse(jsonObject);
        return OkHttpUtils.post(url, urlParams, FORM_TYPE, okHttpClient);
    }

    public static <T> String postForm(String url, T params, Map<String, String> headerContent) throws IOException {
        return OkHttpUtils.postForm(url, params, headerContent, OkHttpUtils.buildClient());
    }

    public static <T> String postForm(String url, T params, Map<String, String> headerContent, OkHttpClient okHttpClient) throws IOException {
        JSONObject jsonObject = JSONObject.fromObject(params);
        String urlParams = UrlUtils.jsonParse(jsonObject);
        RequestBody body = RequestBody.create((MediaType)FORM_TYPE, (String)urlParams);
        Headers headers = Headers.of(headerContent);
        Request request = new Request.Builder().url(url).headers(headers).post(body).build();
        return OkHttpUtils.send(request, okHttpClient);
    }

    public static String postFormCookie(String url, JSONObject json) throws IOException {
        String params = UrlUtils.jsonParse(json);
        return OkHttpUtils.post(url, params, FORM_TYPE, COOKIE_CLIENT);
    }

    public static <T> String postJson(String url, T params) throws IOException {
        if (params instanceof String) {
            return OkHttpUtils.post(url, String.valueOf(params), JSON_TYPE);
        }
        return OkHttpUtils.post(url, JSONObject.fromObject(params).toString(), JSON_TYPE);
    }

    @Deprecated
    public static <T> JsonObject postFormReJsonObject(String url, T params) throws IOException {
        String result = OkHttpUtils.postForm(url, params);
        try {
            return JsonObjectUtils.parse(result);
        }
        catch (Exception e) {
            throw new ToolboxException("url:" + url + ",\u8fd4\u56de\u7ed3\u679c\u53c2\u6570\u683c\u5f0f\u9519\u8bef:" + result);
        }
    }

    public static JsonObjects postJsonReJsonObjects(String url) throws IOException {
        return OkHttpUtils.postJsonReJsonObjects(url, null);
    }

    public static <T> JsonObjects postJsonReJsonObjects(String url, T params) throws IOException {
        String result = OkHttpUtils.postJson(url, params);
        try {
            return new JsonObjects(result);
        }
        catch (Exception e) {
            throw new ToolboxException("url:" + url + ",\u8fd4\u56de\u7ed3\u679c\u53c2\u6570\u683c\u5f0f\u9519\u8bef:" + result);
        }
    }

    public static JsonObjects postFormReJsonObjects(String url) throws IOException {
        return OkHttpUtils.postFormReJsonObjects(url, null);
    }

    public static <T> JsonObjects postFormReJsonObjects(String url, T params) throws IOException {
        String result = OkHttpUtils.postForm(url, params);
        try {
            return new JsonObjects(result);
        }
        catch (Exception e) {
            throw new ToolboxException("url:" + url + ",\u8fd4\u56de\u7ed3\u679c\u53c2\u6570\u683c\u5f0f\u9519\u8bef:" + result);
        }
    }

    public static JsonObjects getReJsonObjects(String url) throws IOException {
        return OkHttpUtils.getReJsonObjects(url, null);
    }

    public static <T> JsonObjects getReJsonObjects(String url, T params) throws IOException {
        String result = OkHttpUtils.get(url, params);
        try {
            return new JsonObjects(result);
        }
        catch (Exception e) {
            throw new ToolboxException("url:" + url + ",\u8fd4\u56de\u7ed3\u679c\u53c2\u6570\u683c\u5f0f\u9519\u8bef:" + result);
        }
    }

    public static <T> String get(String url, T params) throws IOException {
        AssertUtils.notEmpty(url, "url");
        JSONObject jsonObject = JSONObject.fromObject(params);
        url = UrlUtils.urlParam(url, jsonObject);
        return OkHttpUtils.get(url);
    }

    public static String get(String url) throws IOException {
        AssertUtils.notEmpty(url, "url");
        Request request = new Request.Builder().url(url).build();
        return OkHttpUtils.send(request, OkHttpUtils.buildClient());
    }

    public static String get(String url, JSONObject data, Map<String, String> headerContent) throws IOException {
        url = UrlUtils.urlParam(url, data);
        Headers headers = Headers.of(headerContent);
        Request request = new Request.Builder().url(url).headers(headers).build();
        return OkHttpUtils.send(request);
    }

    private static String post(String url, String params, MediaType mediaType) throws IOException {
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)params);
        Request request = new Request.Builder().url(url).post(body).build();
        return OkHttpUtils.send(request, OkHttpUtils.buildClient());
    }

    private static String post(String url, String params, MediaType mediaType, OkHttpClient okHttpClient) throws IOException {
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)params);
        Request request = new Request.Builder().url(url).post(body).build();
        return OkHttpUtils.send(request, okHttpClient);
    }

    private static String send(Request request) throws IOException {
        return OkHttpUtils.send(request, OkHttpUtils.buildClient());
    }

    private static String send(Request request, OkHttpClient okHttpClient) throws IOException {
        try (Response response = okHttpClient.newCall(request).execute();){
            ResponseBody body1 = response.body();
            if (body1 == null) {
                throw new ToolboxException("result params is null ");
            }
            String string = body1.string();
            return string;
        }
    }

    public static <K, V> String upload(String url, Map<K, V> params, String fileName, Map<K, V> fileMap) throws IOException {
        String name;
        MultipartBody.Builder requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM);
        if (MapUtils.isNotEmpty(params)) {
            for (Map.Entry<K, V> entry : params.entrySet()) {
                name = String.valueOf(entry.getKey());
                String value = String.valueOf(entry.getValue());
                requestBody.addFormDataPart(name, value);
            }
        }
        if (MapUtils.isNotEmpty(fileMap)) {
            for (Map.Entry<K, V> entry : fileMap.entrySet()) {
                name = String.valueOf(entry.getKey());
                String path = String.valueOf(entry.getValue());
                RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)MULTIPART_FORM_DATA), (File)new File(path));
                requestBody.addFormDataPart(fileName, name, fileBody);
            }
        }
        Request request = new Request.Builder().url(url).post((RequestBody)requestBody.build()).build();
        return OkHttpUtils.send(request);
    }
}

