/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.util;

import com.github.hugh.model.dto.PingDTO;
import com.github.hugh.util.EmptyUtils;
import com.github.hugh.util.system.OsUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PingUtils {
    private PingUtils() {
    }

    public static boolean send(String ipAddress, int pingCount, int timeOut) {
        try {
            return PingUtils.getConnectedCount(ipAddress, pingCount, timeOut) == pingCount;
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
            return false;
        }
    }

    public static int getConnectedCount(String ipAddress, int pingCount, int timeOut) throws IOException {
        String pingCommand;
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(pingCommand = PingUtils.appendCmd(ipAddress, pingCount, timeOut));
        if (process == null) {
            return -1;
        }
        InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
        try (BufferedReader in = new BufferedReader(inputStreamReader);){
            String line;
            int connectedCount = 0;
            while ((line = in.readLine()) != null) {
                connectedCount += PingUtils.getCheckResult(line);
            }
            int n = connectedCount;
            return n;
        }
    }

    private static int getCheckResult(String line) {
        Pattern pattern = OsUtils.isWindows() ? Pattern.compile("(\\d+ms)(\\s+)(TTL=\\d+)", 2) : Pattern.compile("(\\d+|\\s+ms)(\\s+)(ttl=\\d+)", 2);
        Matcher matcher = pattern.matcher(line);
        return matcher.find() ? 1 : 0;
    }

    public static List<String> batch(String ipAddress, int pingCount, int timeOut) {
        ArrayList<String> strs = new ArrayList<String>();
        String pingCommand = PingUtils.appendCmd(ipAddress, pingCount, timeOut);
        try {
            String line;
            Process pro = Runtime.getRuntime().exec(pingCommand);
            BufferedReader buf = new BufferedReader(new InputStreamReader(pro.getInputStream(), "GBK"));
            while ((line = buf.readLine()) != null) {
                if ("".equals(line)) continue;
                strs.add(line);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return strs;
    }

    private static String appendCmd(String ip, int count, int timeOut) {
        String pingCommand = OsUtils.isWindows() ? "ping " + ip + " -n " + count + " -w " + timeOut : "ping " + ip + " -c " + count;
        return pingCommand;
    }

    public static PingDTO ping(String ip) {
        return PingUtils.ping(ip, 4, 10000);
    }

    public static PingDTO ping(String ip, int count, int timeOut) {
        String cmd = PingUtils.appendCmd(ip, count, timeOut);
        return PingUtils.send(cmd);
    }

    private static PingDTO send(String cmd) {
        PingDTO ping = new PingDTO();
        String loss = "";
        String delay = "";
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(cmd);
            try (InputStream inputStream = process.getInputStream();
                 InputStreamReader isReader = new InputStreamReader(inputStream, "GB2312");
                 BufferedReader reader = new BufferedReader(isReader);){
                StringBuilder buffer = new StringBuilder();
                if (OsUtils.isWindows()) {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (line.contains("%") && (loss = line.substring(line.lastIndexOf("=") + 1, line.indexOf("%") + 1)).contains("(")) {
                            loss = loss.substring(loss.indexOf("(") + 1).strip();
                        }
                        if ((line.contains(",") || line.contains("\uff0c")) && line.contains("=") && line.contains("ms")) {
                            delay = line.substring(line.lastIndexOf("=") + 1, line.lastIndexOf("ms") + 2).strip();
                        }
                        buffer.append(line).append("\n");
                    }
                } else {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        String[] msg;
                        if (line.contains("%")) {
                            msg = null;
                            if (line.contains(",")) {
                                msg = line.split(",");
                            } else if (line.contains("\uff0c")) {
                                msg = line.split("\uff0c");
                            }
                            assert (msg != null);
                            if (msg.length > 0) {
                                loss = msg[2].substring(0, msg[2].indexOf("%") + 1).strip();
                            }
                        }
                        if (line.contains("/")) {
                            msg = line.split("=");
                            String[] names = msg[0].split("/");
                            String[] values = msg[1].split("/");
                            for (int i = 0; i < names.length; ++i) {
                                String str = names[i];
                                if (!"avg".equalsIgnoreCase(str)) continue;
                                delay = values[i];
                                break;
                            }
                        }
                        buffer.append(line).append("\n");
                    }
                }
                loss = loss.replace("%", "");
                delay = delay.replace("ms", "");
                if (EmptyUtils.isNotEmpty(loss)) {
                    ping.setLoss(Integer.parseInt(loss));
                }
                if (EmptyUtils.isNotEmpty(delay)) {
                    ping.setDelay(Double.parseDouble(delay));
                } else {
                    ping.setDelay(-1.0);
                    ping.setStatus(-1);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            ping.setStatus(-2);
        }
        return ping;
    }
}

