/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.util;

import com.github.hugh.exception.ToolboxException;
import com.github.hugh.util.ListUtils;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class RandomUtils {
    private static final String BASE_NUMBER = "0123456789";
    private static final String BASE_CHAR = "abcdefghijklmnopqrstuvwxyz";
    private static final String BASE_CHAR_NUMBER = "abcdefghijklmnopqrstuvwxyz0123456789";

    private RandomUtils() {
    }

    public static ThreadLocalRandom getRandom() {
        return ThreadLocalRandom.current();
    }

    public static SecureRandom getSecureRandom() {
        try {
            return SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ToolboxException(e);
        }
    }

    public static Random getRandom(boolean isSecure) {
        return isSecure ? RandomUtils.getSecureRandom() : RandomUtils.getRandom();
    }

    public static String randomChar(int length) {
        return RandomUtils.randomString(BASE_CHAR, length);
    }

    public static String randomNumber(int length) {
        return RandomUtils.randomString(BASE_NUMBER, length);
    }

    public static int number(int length) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int number = RandomUtils.getRandom().nextInt(10);
            stringBuilder.append(number);
        }
        return stringBuilder.charAt(0) == '0' ? RandomUtils.number(length) : Integer.parseInt(stringBuilder.toString());
    }

    public static String randomString(int length) {
        return RandomUtils.randomString(BASE_CHAR_NUMBER, length);
    }

    public static String randomString(String baseString, int length) {
        StringBuilder stringBuilder = new StringBuilder();
        if (length < 1) {
            length = 1;
        }
        int baseLength = baseString.length();
        for (int i = 0; i < length; ++i) {
            int number = RandomUtils.getRandom().nextInt(baseLength);
            stringBuilder.append(baseString.charAt(number));
        }
        return stringBuilder.toString();
    }

    public static <T> T random(List<T> list) {
        if (ListUtils.isEmpty(list)) {
            return null;
        }
        int size = list.size();
        int index = RandomUtils.getRandom().nextInt(size);
        return list.get(index);
    }

    public static int randomInt(int min, int max) {
        return RandomUtils.getRandom().nextInt(min, max);
    }
}

