/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.util;

import javax.servlet.http.HttpServletRequest;

public class RequestUtils {
    public static String getSystemType(HttpServletRequest request) {
        String userAgent = request.getHeader("user-agent").toLowerCase();
        if (userAgent.contains("micromessenger")) {
            return "wx";
        }
        if (userAgent.contains("android")) {
            return "android";
        }
        if (userAgent.contains("iphone") || userAgent.contains("ipad") || userAgent.contains("ipod")) {
            return "ios";
        }
        return "pc";
    }

    public static boolean isWeChat(HttpServletRequest request) {
        return "wx".equals(RequestUtils.getSystemType(request));
    }

    public static boolean isAndroid(HttpServletRequest request) {
        return "android".equals(RequestUtils.getSystemType(request));
    }

    public static boolean isIos(HttpServletRequest request) {
        return "ios".equals(RequestUtils.getSystemType(request));
    }

    public static boolean isPc(HttpServletRequest request) {
        return "pc".equals(RequestUtils.getSystemType(request));
    }
}

