/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.util;

import com.github.hugh.constant.guava.CharMatchers;
import com.github.hugh.util.EmptyUtils;
import com.google.common.base.CaseFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jodd.util.StringUtil;

public class StringUtils {
    private static final Pattern BLANK_PATTERN = Pattern.compile("\\s*|\t|\r|\n");
    private static final String EMPTY = "";

    private StringUtils() {
    }

    private static boolean isChinese(char car) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(car);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }

    public static boolean isContainChinese(String string) {
        char[] ch;
        if (EmptyUtils.isEmpty(string)) {
            return false;
        }
        for (char c : ch = string.toCharArray()) {
            if (!StringUtils.isChinese(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotContainChinese(String string) {
        return !StringUtils.isContainChinese(string);
    }

    public static String getNumber(String str) {
        return CharMatchers.NUMBER_CHAR_MATCHER.retainFrom((CharSequence)str);
    }

    public static String getDouble(String str) {
        return CharMatchers.NUMBERS_AND_DECIMAL_POINTS.retainFrom((CharSequence)str);
    }

    public static String before(String value, String cha) {
        if (EmptyUtils.isEmpty(value)) {
            return value;
        }
        if (value.contains(cha)) {
            int lastIndexOf = value.lastIndexOf(cha);
            return value.substring(0, lastIndexOf);
        }
        return value;
    }

    public static String after(String value, String cha) {
        if (EmptyUtils.isEmpty(value)) {
            return value;
        }
        if (value.contains(cha)) {
            int lastIndexOf = value.lastIndexOf(cha) + 1;
            return value.substring(lastIndexOf);
        }
        return value;
    }

    public static int varcharSize(String value) {
        int length = 0;
        String chinese = "[\u0391-\uffe5]";
        for (int i = 0; i < value.length(); ++i) {
            String temp = value.substring(i, i + 1);
            if (temp.matches(chinese)) {
                length += 2;
                continue;
            }
            ++length;
        }
        return length;
    }

    public static String leftPadding(String original, int targetLength, char unit) {
        int originalLength = original.length();
        if (originalLength >= targetLength) {
            return original;
        }
        return String.valueOf(unit).repeat(targetLength - originalLength) + original;
    }

    public static String leftPadding(String original, int targetLength) {
        return StringUtils.leftPadding(original, targetLength, '0');
    }

    public static String camelToUnderline(String camelStr) {
        if (StringUtil.isEmpty((CharSequence)camelStr)) {
            return null;
        }
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, camelStr);
    }

    public static String camelToUnderlineUppercase(String camelStr) {
        String str = StringUtils.camelToUnderline(camelStr);
        return str == null ? null : str.toUpperCase();
    }

    public static String getCamelCase(String inputString, boolean firstCharacterUppercase) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean nextUpperCase = false;
        block3: for (int i = 0; i < inputString.length(); ++i) {
            char charAt = inputString.charAt(i);
            switch (charAt) {
                case ' ': 
                case '#': 
                case '$': 
                case '&': 
                case '-': 
                case '/': 
                case '@': 
                case '_': {
                    if (stringBuilder.length() <= 0) continue block3;
                    nextUpperCase = true;
                    continue block3;
                }
                default: {
                    if (nextUpperCase) {
                        stringBuilder.append(Character.toUpperCase(charAt));
                        nextUpperCase = false;
                        continue block3;
                    }
                    stringBuilder.append(Character.toLowerCase(charAt));
                }
            }
        }
        if (firstCharacterUppercase) {
            stringBuilder.setCharAt(0, Character.toUpperCase(stringBuilder.charAt(0)));
        }
        return stringBuilder.toString();
    }

    public static String replaceAnyBlank(String string, String replacement) {
        if (StringUtil.isEmpty((CharSequence)string)) {
            return string;
        }
        Matcher matcher = BLANK_PATTERN.matcher(string);
        String result = matcher.replaceAll(replacement);
        result = result.replace("\\u00A0", replacement);
        return result;
    }

    public static String replaceAnyBlank(String string) {
        return StringUtils.replaceAnyBlank(string, EMPTY);
    }

    public static String trim(String value) {
        return value.trim().strip();
    }

    public static String trim(String source, String beTrim) {
        String endChar;
        if (source == null) {
            return EMPTY;
        }
        if ((source = source.strip().trim()).isEmpty()) {
            return EMPTY;
        }
        String beginChar = source.substring(0, 1);
        if (beginChar.equalsIgnoreCase(beTrim)) {
            source = source.substring(1);
        }
        if ((endChar = source.substring(source.length() - 1)).equalsIgnoreCase(beTrim)) {
            source = source.substring(0, source.length() - 1);
        }
        return source;
    }

    public static String after(String string, String chr, int index) {
        int index1 = StringUtils.indexOf(string, chr, index);
        return string.substring(index1);
    }

    public static int indexOf(String string, String chr, int index) {
        Pattern pattern = Pattern.compile(chr);
        Matcher findMatcher = pattern.matcher(string);
        int number = 0;
        while (findMatcher.find() && ++number != index) {
        }
        return findMatcher.start();
    }
}

