/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.util;

import com.github.hugh.constant.DateCode;
import com.github.hugh.util.EmptyUtils;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TimeUtils
extends DateCode {
    private TimeUtils() {
    }

    private static String ofPattern(String format, LocalDateTime time) {
        if (EmptyUtils.isEmpty(format)) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        return DateTimeFormatter.ofPattern(format).format(time);
    }

    public static LocalDateTime parseTime(String timeStr) {
        return TimeUtils.parseTime(timeStr, "yyyy-MM-dd HH:mm:ss");
    }

    private static LocalDateTime parseTime(String strTime, String format) {
        try {
            return LocalDateTime.parse(strTime, DateTimeFormatter.ofPattern(format));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getYear() {
        return LocalDateTime.now().getYear();
    }

    public static boolean isThisYear(int year) {
        return TimeUtils.getYear() == year;
    }

    public static int getMonth() {
        return LocalDateTime.now().getMonthValue();
    }

    public static int getDay() {
        return LocalDateTime.now().getDayOfMonth();
    }

    public static String getTime() {
        return TimeUtils.getTime("yyyy-MM-dd HH:mm:ss");
    }

    public static String getTime(String pattern) {
        return TimeUtils.ofPattern(pattern, LocalDateTime.now());
    }

    public static String firstDayOfMonth() {
        LocalDate localDate = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
        LocalDateTime dateTime = LocalDateTime.of(localDate, LocalTime.MIN);
        return TimeUtils.ofPattern("yyyy-MM-dd HH:mm:ss", dateTime);
    }

    public static String lastDayOfMonth() {
        LocalDate localDate = LocalDate.now().with(TemporalAdjusters.lastDayOfMonth());
        LocalDateTime dateTime = LocalDateTime.of(localDate, LocalTime.MAX);
        return TimeUtils.ofPattern("yyyy-MM-dd HH:mm:ss", dateTime);
    }

    public static String endOfLastMonth() {
        return TimeUtils.endOfLastMonth("yyyy-MM-dd HH:mm:ss");
    }

    public static String endOfLastMonth(String pattern) {
        LocalDate earlyLastMonth = LocalDate.now().minusMonths(1L).with(TemporalAdjusters.lastDayOfMonth());
        LocalDateTime localDateTime = LocalDateTime.of(earlyLastMonth, LocalTime.MAX);
        return TimeUtils.ofPattern(pattern, localDateTime);
    }

    public static String earlyLastMonth() {
        return TimeUtils.earlyLastMonth("yyyy-MM-dd HH:mm:ss");
    }

    public static String earlyLastMonth(String pattern) {
        LocalDate earlyLastMonth = LocalDate.now().minusMonths(1L).with(TemporalAdjusters.firstDayOfMonth());
        LocalDateTime localDateTime = LocalDateTime.of(earlyLastMonth, LocalTime.MIN);
        return TimeUtils.ofPattern(pattern, localDateTime);
    }

    private static String getYesterday(String format, LocalTime time) {
        if (format == null || "".equals(format)) {
            format = "yyyy-MM-dd";
        }
        if (time == null) {
            time = LocalTime.MIN;
        }
        LocalDateTime localDateTime = LocalDateTime.of(LocalDate.now().plusDays(-1L), time);
        return TimeUtils.ofPattern(format, localDateTime);
    }

    public static String getStartedYesterday() {
        return TimeUtils.getYesterday("yyyy-MM-dd HH:mm:ss", LocalTime.MIN);
    }

    public static String getEndedYesterday() {
        return TimeUtils.getYesterday("yyyy-MM-dd HH:mm:ss", LocalTime.MAX);
    }

    public static boolean exceedSystem(String time) {
        LocalDateTime t = LocalDateTime.parse(time, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        return t.isBefore(LocalDateTime.now());
    }

    public static boolean checkTimestamp(String clientTime, long maxAllow) {
        if (clientTime.length() != 13) {
            return false;
        }
        long sys = System.currentTimeMillis();
        try {
            long time = Long.parseLong(clientTime);
            if (sys - time > maxAllow || time - sys > maxAllow) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static String getYesterdayStartTime() {
        LocalDateTime localDateTime = LocalDateTime.now().withHour(0).withMinute(0).withSecond(0).withNano(0).plusDays(-1L);
        return TimeUtils.ofPattern("yyyy-MM-dd HH:mm:ss", localDateTime);
    }

    public static String getYesterdayEndTime() {
        LocalDateTime localDateTime = LocalDateTime.now().withHour(23).withMinute(59).withSecond(59).withNano(999).plusDays(-1L);
        return TimeUtils.ofPattern("yyyy-MM-dd HH:mm:ss", localDateTime);
    }

    public static long differMilli(String startTime, String endTime) {
        if (EmptyUtils.isEmpty(startTime) || EmptyUtils.isEmpty(endTime)) {
            return -1L;
        }
        LocalDateTime start = TimeUtils.parseTime(startTime);
        if (start == null) {
            return -1L;
        }
        LocalDateTime end = TimeUtils.parseTime(endTime);
        if (end == null) {
            return -1L;
        }
        Instant s = start.toInstant(ZoneOffset.ofHours(8));
        Instant e = end.toInstant(ZoneOffset.ofHours(8));
        return ChronoUnit.MILLIS.between(s, e);
    }

    public static LocalDate getNextNDay(LocalDate localDate, int days) {
        return localDate.with(temporal -> temporal.plus(days, ChronoUnit.DAYS));
    }

    public static boolean isCrossDay(String start, String end) {
        return TimeUtils.isCrossDay(start, end, 1);
    }

    public static boolean isCrossDay(String start, String end, int days) {
        LocalDate startDate = LocalDate.parse(start, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        LocalDate endDate = LocalDate.parse(end, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        startDate = TimeUtils.getNextNDay(startDate, days);
        return startDate.isEqual(ChronoLocalDate.from(endDate));
    }

    public static List<String> collectLocalDates(String timeStart, String timeEnd) {
        return TimeUtils.collectLocalDates(LocalDate.parse(timeStart), LocalDate.parse(timeEnd));
    }

    public static List<String> collectLocalDates(LocalDate start, LocalDate end) {
        return Stream.iterate(start, localDate -> localDate.plusDays(1L)).limit(ChronoUnit.DAYS.between(start, end) + 1L).map(LocalDate::toString).collect(Collectors.toList());
    }
}

