/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.util.base;

import com.github.hugh.exception.ToolboxException;
import java.io.UnsupportedEncodingException;

public class BaseConvertUtils {
    private static final String HEX_STRING = "0123456789ABCDEF";
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    private BaseConvertUtils() {
    }

    public static String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(BaseConvertUtils.byteToHex(b));
        }
        return sb.toString();
    }

    public static String byteToHex(byte b) {
        int n = b;
        if (n < 0) {
            n += 256;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        String charOne = String.valueOf(HEX_ARRAY[d1]);
        String charTwo = String.valueOf(HEX_ARRAY[d2]);
        return charOne + charTwo;
    }

    public static String decToHex(int decimal) {
        return Integer.toHexString(decimal);
    }

    public static String decToHex(String decimal) {
        return BaseConvertUtils.decToHex(Integer.parseInt(decimal));
    }

    public static String decToBinary(int decimal) {
        return Integer.toBinaryString(decimal);
    }

    public static String decToBinary(String str) {
        return BaseConvertUtils.decToBinary(Integer.parseInt(str), 0);
    }

    public static String decToBinary(String str, int digits) {
        return BaseConvertUtils.decToBinary(Integer.parseInt(str), digits);
    }

    public static String decToBinary(int num, int digits) {
        String str = Integer.toBinaryString(num);
        return BaseConvertUtils.complement(str, digits);
    }

    public static String binaryToDec(String binary) {
        return Integer.valueOf(binary, 2).toString();
    }

    public static String hexToString(String hexStr, String interval) {
        if (interval == null) {
            throw new ToolboxException(" interval is null ");
        }
        String[] array = hexStr.split(interval);
        byte[] bytes = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            bytes[i] = Byte.parseByte(array[i], 16);
        }
        return new String(bytes);
    }

    public static String hexToBinary(String num) {
        return BaseConvertUtils.hexToBinary(num, 0);
    }

    public static String hexToBinary(String num, int digits) {
        String str = Integer.toBinaryString(Integer.valueOf(num, 16));
        return BaseConvertUtils.complement(str, digits);
    }

    private static String complement(String str, int digits) {
        String cover = Integer.toBinaryString(1 << digits).substring(1);
        return str.length() < digits ? cover.substring(str.length()) + str : str;
    }

    public static int hexToDec(String hex) {
        return Integer.parseInt(hex, 16);
    }

    public static String hexToDecString(String hex) {
        return String.valueOf(BaseConvertUtils.hexToDec(hex));
    }

    public static byte[] hexToBytes(String hexString) {
        byte[] result;
        int hexLen = ((String)hexString).length();
        if (hexLen % 2 == 1) {
            result = new byte[++hexLen / 2];
            hexString = "0" + (String)hexString;
        } else {
            result = new byte[hexLen / 2];
        }
        int j = 0;
        for (int i = 0; i < hexLen; i += 2) {
            result[j] = BaseConvertUtils.hexToByte(((String)hexString).substring(i, i + 2));
            ++j;
        }
        return result;
    }

    public static byte hexToByte(String hexString) {
        return (byte)Integer.parseInt(hexString, 16);
    }

    public static String hexToAscii(String hexStr) {
        char[] hexChar = hexStr.toUpperCase().toCharArray();
        int length = hexStr.length() / 2;
        byte[] bytes = new byte[length];
        for (int i = 0; i < bytes.length; ++i) {
            int position = i * 2;
            int n = HEX_STRING.indexOf(hexChar[position]) * 16;
            bytes[i] = (byte)((n += HEX_STRING.indexOf(hexChar[position + 1])) & 0xFF);
        }
        try {
            return new String(bytes, "GB2312");
        }
        catch (UnsupportedEncodingException e) {
            throw new ToolboxException(e);
        }
    }

    public static String asciiToHex(String str) {
        return BaseConvertUtils.asciiToHex(str, null);
    }

    public static String asciiToHex(String str, String split) {
        byte[] bytes;
        StringBuilder sb = new StringBuilder();
        try {
            bytes = str.getBytes("GB2312");
        }
        catch (UnsupportedEncodingException e) {
            throw new ToolboxException(e);
        }
        for (byte b : bytes) {
            int bit = (b & 0xF0) >> 4;
            sb.append(HEX_ARRAY[bit]);
            bit = b & 0xF;
            sb.append(HEX_ARRAY[bit]);
            if (split == null) continue;
            sb.append(split);
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static byte[] hexArrToBytes(String[] strings) {
        byte[] bytes = new byte[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            bytes[i] = BaseConvertUtils.hexToByte(strings[i]);
        }
        return bytes;
    }

    public static byte[] hexArrToBytes(String string, String split) {
        return BaseConvertUtils.hexArrToBytes(string.split(split));
    }
}

