/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.util.common;

import com.github.hugh.exception.ToolboxException;
import com.github.hugh.util.EmptyUtils;
import com.github.hugh.util.common.IdCardValidator;

public class IdCardUtils {
    public static boolean isIdCard(String idCard) {
        if (EmptyUtils.isEmpty(idCard)) {
            return false;
        }
        if (idCard.length() == 15) {
            return IdCardValidator.is15Place(idCard);
        }
        return IdCardValidator.is18Place(idCard);
    }

    public static boolean isNotIdCard(String idCard) {
        return !IdCardUtils.isIdCard(idCard);
    }

    public static boolean is18Place(String idCard) {
        return IdCardValidator.is18Place(idCard);
    }

    public static boolean isNot18Place(String idCard) {
        return !IdCardValidator.is18Place(idCard);
    }

    public static String encrypt(String idCard) {
        return IdCardUtils.encrypt(idCard, 3, 4);
    }

    public static String encrypt(String idCard, int before, int rear) {
        if (EmptyUtils.isEmpty(idCard)) {
            return idCard;
        }
        int length = idCard.length();
        if (before < 0) {
            throw new ToolboxException("number before error !");
        }
        if (rear < 0) {
            throw new ToolboxException("number rear error !");
        }
        int total = before + rear;
        if (length <= total) {
            throw new ToolboxException("id card number length error !");
        }
        return idCard.replaceAll("(?<=\\w{" + before + "})\\w(?=\\w{" + rear + "})", "*");
    }
}

