/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.util.common;

import com.github.hugh.util.EmptyUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class IdCardValidator {
    private static String[] cityCode = new String[]{"11", "12", "13", "14", "15", "21", "22", "23", "31", "32", "33", "34", "35", "36", "37", "41", "42", "43", "44", "45", "46", "50", "51", "52", "53", "54", "61", "62", "63", "64", "65", "71", "81", "82", "91"};
    private static int[] power = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};

    public static boolean is18Place(String idCard) {
        if (EmptyUtils.isEmpty(idCard)) {
            return false;
        }
        if (idCard.length() != 18) {
            return false;
        }
        String idCard17 = idCard.substring(0, 17);
        if (!IdCardValidator.isDigital(idCard17)) {
            return false;
        }
        String provinceId = idCard.substring(0, 2);
        if (!IdCardValidator.checkProvinceId(provinceId)) {
            return false;
        }
        String birthday = idCard.substring(6, 14);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        try {
            Date birthDate = sdf.parse(birthday);
            String tmpDate = sdf.format(birthDate);
            if (!tmpDate.equals(birthday)) {
                return false;
            }
        }
        catch (ParseException e1) {
            return false;
        }
        String idCard18Code = idCard.substring(17, 18);
        char[] c = idCard17.toCharArray();
        int[] bit = IdCardValidator.converCharToInt(c);
        int sum17 = IdCardValidator.getPowerSum(bit);
        String checkCode = IdCardValidator.getCheckCodeBySum(sum17);
        if (null == checkCode) {
            return false;
        }
        return idCard18Code.equalsIgnoreCase(checkCode);
    }

    public static boolean is15Place(String idCard) {
        if (EmptyUtils.isEmpty(idCard)) {
            return false;
        }
        if (idCard.length() != 15) {
            return false;
        }
        if (!IdCardValidator.isDigital(idCard)) {
            return false;
        }
        String provinceId = idCard.substring(0, 2);
        if (!IdCardValidator.checkProvinceId(provinceId)) {
            return false;
        }
        String birthday = idCard.substring(6, 12);
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd");
        try {
            Date birthDate = sdf.parse(birthday);
            String tmpDate = sdf.format(birthDate);
            if (!tmpDate.equals(birthday)) {
                return false;
            }
        }
        catch (ParseException e1) {
            return false;
        }
        return true;
    }

    public static String convertIdCarBy15bit(String idCard) {
        Date birthdate;
        if (idCard == null) {
            return null;
        }
        if (idCard.length() != 15) {
            return null;
        }
        if (!IdCardValidator.isDigital(idCard)) {
            return null;
        }
        String provinceId = idCard.substring(0, 2);
        if (!IdCardValidator.checkProvinceId(provinceId)) {
            return null;
        }
        String birthday = idCard.substring(6, 12);
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd");
        try {
            birthdate = sdf.parse(birthday);
            String tmpDate = sdf.format(birthdate);
            if (!tmpDate.equals(birthday)) {
                return null;
            }
        }
        catch (ParseException e1) {
            return null;
        }
        Calendar cday = Calendar.getInstance();
        cday.setTime(birthdate);
        String year = String.valueOf(cday.get(1));
        String idCard17 = idCard.substring(0, 6) + year + idCard.substring(8);
        char[] c = idCard17.toCharArray();
        int[] bit = IdCardValidator.converCharToInt(c);
        int sum17 = IdCardValidator.getPowerSum(bit);
        String checkCode = IdCardValidator.getCheckCodeBySum(sum17);
        if (null == checkCode) {
            return null;
        }
        idCard17 = idCard17 + checkCode;
        return idCard17;
    }

    private static boolean checkProvinceId(String provinceId) {
        for (String id : cityCode) {
            if (!id.equals(provinceId)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDigital(String str) {
        return str.matches("^[0-9]*$");
    }

    private static int getPowerSum(int[] bit) {
        int sum = 0;
        if (power.length != bit.length) {
            return sum;
        }
        for (int i = 0; i < bit.length; ++i) {
            for (int j = 0; j < power.length; ++j) {
                if (i != j) continue;
                sum += bit[i] * power[j];
            }
        }
        return sum;
    }

    private static String getCheckCodeBySum(int sum17) {
        String checkCode = null;
        switch (sum17 % 11) {
            case 10: {
                checkCode = "2";
                break;
            }
            case 9: {
                checkCode = "3";
                break;
            }
            case 8: {
                checkCode = "4";
                break;
            }
            case 7: {
                checkCode = "5";
                break;
            }
            case 6: {
                checkCode = "6";
                break;
            }
            case 5: {
                checkCode = "7";
                break;
            }
            case 4: {
                checkCode = "8";
                break;
            }
            case 3: {
                checkCode = "9";
                break;
            }
            case 2: {
                checkCode = "x";
                break;
            }
            case 1: {
                checkCode = "0";
                break;
            }
            case 0: {
                checkCode = "1";
            }
        }
        return checkCode;
    }

    private static int[] converCharToInt(char[] chars) throws NumberFormatException {
        int[] intArr = new int[chars.length];
        int k = 0;
        for (char temp : chars) {
            intArr[k++] = Integer.parseInt(String.valueOf(temp));
        }
        return intArr;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String[] validateIdCard10(String idCard) {
        String[] info = new String[3];
        String card = idCard.replaceAll("[(|)]", "");
        if (card.length() != 8 && card.length() != 9 && idCard.length() != 10) {
            return null;
        }
        if (idCard.matches("^[a-zA-Z][0-9]{9}$")) {
            info[0] = "\u53f0\u6e7e";
            String char2 = idCard.substring(1, 2);
            if (char2.equals("1")) {
                info[1] = "M";
                System.out.println("MMMMMMM");
                return info;
            }
            if (char2.equals("2")) {
                info[1] = "F";
                System.out.println("FFFFFFF");
                return info;
            }
            info[1] = "N";
            info[2] = "false";
            System.out.println("NNNN");
            return info;
        }
        if (idCard.matches("^[1|5|7][0-9]{6}\\(?[0-9A-Z]\\)?$")) {
            info[0] = "\u6fb3\u95e8";
            info[1] = "N";
            return info;
        }
        if (!idCard.matches("^[A-Z]{1,2}[0-9]{6}\\(?[0-9A]\\)?$")) return null;
        info[0] = "\u9999\u6e2f";
        info[1] = "N";
        info[2] = IdCardValidator.validateHKCard(idCard) ? "true" : "false";
        return info;
    }

    public static boolean validateHKCard(String idCard) {
        String card = idCard.replaceAll("[(|)]", "");
        int sum = 0;
        char[] chars1 = card.substring(0, 1).toUpperCase().toCharArray();
        if (card.length() == 9) {
            sum = (chars1[0] - 55) * 9 + (card.substring(1, 2).toUpperCase().toCharArray()[0] - 55) * 8;
            card = card.substring(1, 9);
        } else {
            sum = 522 + (chars1[0] - 55) * 8;
        }
        String mid = card.substring(1, 7);
        String end = card.substring(7, 8);
        char[] chars = mid.toCharArray();
        int iflag = 7;
        for (char c : chars) {
            sum += Integer.parseInt("" + c) * iflag;
            --iflag;
        }
        sum = "A".equalsIgnoreCase(end) ? (sum += 10) : (sum += Integer.parseInt(end));
        return sum % 11 == 0;
    }
}

