/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.util.common;

import com.google.common.base.Strings;
import org.apache.commons.lang.StringUtils;

public class NamesUtils {
    private static final String EMPTY = "";
    private static final int ZERO = 0;
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int THREE = 3;
    private static final int FOUR = 4;

    public static String encrypt(String str) {
        String mid;
        if (str == null) {
            return null;
        }
        int length = str.length();
        if (length == 1) {
            return str;
        }
        if (length == 2) {
            return "*" + NamesUtils.right(str, 1);
        }
        if (length == 3) {
            return NamesUtils.left(str, 1) + "*" + NamesUtils.right(str, 1);
        }
        if (length == 4) {
            return NamesUtils.left(str, 1) + "**" + NamesUtils.right(str, 1);
        }
        if (length > 4 && str.contains(mid = "\u00b7")) {
            String[] arr = str.split(mid);
            StringBuilder t = new StringBuilder(arr[0]);
            t.append(mid);
            int last = arr[1].length();
            for (int i = 0; i < last; ++i) {
                t.append("*");
            }
            str = t.toString();
        }
        return str;
    }

    private static String left(String str, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return EMPTY;
        }
        if (str.length() <= len) {
            return str;
        }
        return str.substring(0, len);
    }

    private static String right(String str, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return EMPTY;
        }
        if (str.length() <= len) {
            return str;
        }
        return str.substring(str.length() - len);
    }

    public static String desensitized(String fullName) {
        if (Strings.isNullOrEmpty((String)fullName)) {
            return fullName;
        }
        int length = fullName.length();
        int index = length == 4 ? 2 : 1;
        String name = StringUtils.left((String)fullName, (int)index);
        return StringUtils.rightPad((String)name, (int)StringUtils.length((String)fullName), (String)"*");
    }
}

