/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.util.file;

import com.github.hugh.exception.ToolboxException;
import com.github.hugh.util.EmptyUtils;
import com.github.hugh.util.StringUtils;
import com.google.common.io.Files;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

public class FileUtils {
    public static void createDir(String path) {
        File file = new File(path);
        if (file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            return;
        }
        file.mkdirs();
    }

    public static boolean urlFileExist(String url) {
        if (EmptyUtils.isEmpty(url)) {
            return false;
        }
        try {
            URL u = new URL(url);
            URLConnection uc = u.openConnection();
            InputStream in = uc.getInputStream();
            if (url.equalsIgnoreCase(uc.getURL().toString())) {
                in.close();
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean urlNotFileExist(String url) {
        return !FileUtils.urlFileExist(url);
    }

    public static void delEmptyDir(File dir) {
        File[] dirs = dir.listFiles();
        assert (dirs != null);
        for (File file : dirs) {
            if (!file.isDirectory()) continue;
            FileUtils.delEmptyDir(file);
        }
        if (dir.isDirectory()) {
            dir.delete();
        }
    }

    public static void delEmptyDir(String path) {
        FileUtils.delEmptyDir(new File(path));
    }

    public static void deleteDir(File file) {
        if (file == null) {
            throw new ToolboxException("file is null ");
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                return;
            }
            for (File f : files) {
                FileUtils.deleteDir(f);
            }
        }
        file.delete();
    }

    public static void deleteDir(String path) {
        if (path == null) {
            return;
        }
        FileUtils.deleteDir(new File(path));
    }

    public static void delFile(String path) throws IOException {
        if (path == null) {
            return;
        }
        File file = new File(path);
        if (file.exists() && file.delete()) {
            String directory = StringUtils.before(file.getCanonicalPath(), File.separator);
            FileUtils.delEmptyDir(directory);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean downloadByStream(String fileUrl, String savePath) {
        try {
            URL url = new URL(fileUrl);
            HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
            DataInputStream dataInputStream = new DataInputStream(httpURLConnection.getInputStream());
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(savePath));
            try (DataInputStream dataInputStream2 = dataInputStream;){
                boolean bl;
                block15: {
                    DataOutputStream dataOutputStream2 = dataOutputStream;
                    try {
                        int count;
                        byte[] buffer = new byte[4096];
                        while ((count = dataInputStream.read(buffer)) > 0) {
                            dataOutputStream.write(buffer, 0, count);
                        }
                        httpURLConnection.disconnect();
                        bl = true;
                        if (dataOutputStream2 == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (dataOutputStream2 != null) {
                            try {
                                dataOutputStream2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    dataOutputStream2.close();
                }
                return bl;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean downloadByNio(String uri, String path) {
        if (FileUtils.urlNotFileExist(uri)) {
            return false;
        }
        try {
            URL url = new URL(uri);
            ReadableByteChannel readableByteChannel = Channels.newChannel(url.openStream());
            FileOutputStream fileOutputStream = new FileOutputStream(path);
            try (ReadableByteChannel readableByteChannel2 = readableByteChannel;){
                boolean bl;
                block15: {
                    FileOutputStream fileOutputStream2 = fileOutputStream;
                    try {
                        fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
                        bl = true;
                        if (fileOutputStream2 == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (fileOutputStream2 != null) {
                            try {
                                fileOutputStream2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    fileOutputStream2.close();
                }
                return bl;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static byte[] toByteArray(String path) throws IOException {
        File file = new File(path);
        return FileUtils.toByteArray(file);
    }

    public static byte[] toByteArray(File file) throws IOException {
        if (file == null) {
            throw new ToolboxException("file is null !");
        }
        if (!file.exists()) {
            throw new ToolboxException("file not exists !");
        }
        return Files.asByteSource((File)file).read();
    }
}

