/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.util.gson;

import com.github.hugh.exception.ToolboxException;
import com.github.hugh.support.instance.Instance;
import com.github.hugh.util.gson.adapter.MapTypeAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class JsonObjectUtils {
    public static Gson gson() {
        return Instance.getInstance().singleton(Gson.class);
    }

    public static String getString(JsonObject jsonObject, String key) {
        JsonElement jsonElement = JsonObjectUtils.get(jsonObject, key);
        return JsonObjectUtils.isJsonNull(jsonElement) ? null : jsonElement.getAsString();
    }

    public static Integer getInteger(JsonObject jsonObject, String key) {
        JsonElement jsonElement = JsonObjectUtils.get(jsonObject, key);
        return JsonObjectUtils.isJsonNull(jsonElement) ? null : Integer.valueOf(jsonElement.getAsInt());
    }

    public static int getInt(JsonObject jsonObject, String key) {
        Integer integer = JsonObjectUtils.getInteger(jsonObject, key);
        return integer == null ? 0 : integer;
    }

    public static Long getLong(JsonObject jsonObject, String key) {
        JsonElement jsonElement = JsonObjectUtils.get(jsonObject, key);
        return JsonObjectUtils.isJsonNull(jsonElement) ? null : Long.valueOf(jsonElement.getAsLong());
    }

    public static long getLongValue(JsonObject jsonObject, String key) {
        Long aLong = JsonObjectUtils.getLong(jsonObject, key);
        return aLong == null ? 0L : aLong;
    }

    public static Double getDouble(JsonObject jsonObject, String key) {
        JsonElement jsonElement = JsonObjectUtils.get(jsonObject, key);
        return JsonObjectUtils.isJsonNull(jsonElement) ? null : Double.valueOf(jsonElement.getAsDouble());
    }

    public static double getDoubleValue(JsonObject jsonObject, String key) {
        Double aDouble = JsonObjectUtils.getDouble(jsonObject, key);
        return aDouble == null ? 0.0 : aDouble;
    }

    public static JsonObject getJsonObject(JsonObject jsonObject, String key) {
        JsonElement jsonElement = JsonObjectUtils.get(jsonObject, key);
        return JsonObjectUtils.isJsonNull(jsonElement) ? null : jsonElement.getAsJsonObject();
    }

    public static JsonArray getJsonArray(JsonObject jsonObject, String key) {
        JsonElement jsonElement = JsonObjectUtils.get(jsonObject, key);
        return JsonObjectUtils.isJsonNull(jsonElement) ? null : jsonElement.getAsJsonArray();
    }

    public static BigDecimal getBigDecimal(JsonObject jsonObject, String key) {
        JsonElement jsonElement = JsonObjectUtils.get(jsonObject, key);
        return JsonObjectUtils.isJsonNull(jsonElement) ? null : jsonElement.getAsBigDecimal();
    }

    private static JsonElement get(JsonObject jsonObject, String key) {
        if (jsonObject == null) {
            throw new ToolboxException("JsonObject is null !");
        }
        return jsonObject.get(key);
    }

    public static boolean isJsonNull(JsonElement jsonElement) {
        return jsonElement == null || jsonElement.isJsonNull();
    }

    public static <T> JsonObject parse(T object) {
        JsonElement jsonElement = JsonParser.parseString((String)String.valueOf(object));
        return JsonObjectUtils.isJsonNull(jsonElement) ? null : jsonElement.getAsJsonObject();
    }

    public static <T> JsonArray parseArray(T object) {
        JsonElement jsonElement = JsonParser.parseString((String)String.valueOf(object));
        return JsonObjectUtils.isJsonNull(jsonElement) ? null : jsonElement.getAsJsonArray();
    }

    public static <T> List<T> toArrayList(JsonArray jsonArray) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Type type = new TypeToken<ArrayList<T>>(){}.getType();
        Gson gson = gsonBuilder.registerTypeAdapter(type, (Object)new MapTypeAdapter()).create();
        return (List)gson.fromJson((JsonElement)jsonArray, type);
    }

    public static <K, V> Map<K, V> toMap(JsonObject jsonObject) {
        String strJson = JsonObjectUtils.toJson(jsonObject);
        Type type = new TypeToken<Map<K, V>>(){}.getType();
        Gson gson = new GsonBuilder().registerTypeAdapter(type, (Object)new MapTypeAdapter()).create();
        return (Map)gson.fromJson(strJson, type);
    }

    public static <T> T fromJson(JsonElement json, Class<T> classOfT) {
        return (T)JsonObjectUtils.gson().fromJson(json, classOfT);
    }

    public static <T> T fromJson(String json, Class<T> classOfT) {
        return (T)JsonObjectUtils.gson().fromJson(json, classOfT);
    }

    public static <T> T fromJson(String json, Class<T> classOfT, String dateFormat) {
        Gson gson = new GsonBuilder().setDateFormat(dateFormat).create();
        return (T)gson.fromJson(json, classOfT);
    }

    public static <T> String toJson(T entity) {
        return JsonObjectUtils.toJson(entity, "yyyy-MM-dd HH:mm:ss");
    }

    public static <T> String toJson(T entity, String dateFormat) {
        Gson gson = new GsonBuilder().setDateFormat(dateFormat).create();
        return gson.toJson(entity);
    }

    public static <T> T fromJsonTimeStamp(String value, Class<T> classOfT) {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Date.class, (jsonElement, typeOfT, context) -> new Date(jsonElement.getAsJsonPrimitive().getAsLong()));
        Gson gson = builder.create();
        return (T)gson.fromJson(value, classOfT);
    }
}

