/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.util.gson;

import com.alibaba.fastjson.JSON;
import com.github.hugh.util.EmptyUtils;
import com.github.hugh.util.gson.JsonObjectUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public class JsonObjects
extends JsonObjectUtils {
    private JsonObject jsonObject;

    public JsonObjects() {
        this.jsonObject = new JsonObject();
    }

    public <T> JsonObjects(T object) {
        this.jsonObject = object instanceof String ? JsonObjects.parse(object) : JsonObjects.parse(JsonObjects.toJson(object));
    }

    public boolean isNull() {
        return JsonObjects.isJsonNull((JsonElement)this.jsonObject);
    }

    public boolean isNotNull() {
        return !JsonObjects.isJsonNull((JsonElement)this.jsonObject);
    }

    public JsonObjects getThis(String key) {
        return new JsonObjects(JsonObjects.getJsonObject(this.jsonObject, key));
    }

    public JsonArray getJsonArray(String key) {
        return JsonObjects.getJsonArray(this.jsonObject, key);
    }

    public JsonObject getJsonObject(String key) {
        return JsonObjects.getJsonObject(this.jsonObject, key);
    }

    public String getString(String key) {
        return JsonObjects.getString(this.jsonObject, key);
    }

    public int getInt(String key) {
        return JsonObjects.getInt(this.jsonObject, key);
    }

    public Integer getInteger(String key) {
        return JsonObjects.getInteger(this.jsonObject, key);
    }

    public double getDoubleValue(String key) {
        return JsonObjects.getDoubleValue(this.jsonObject, key);
    }

    public Double getDouble(String key) {
        return JsonObjects.getDouble(this.jsonObject, key);
    }

    public long getLongValue(String key) {
        return JsonObjects.getLongValue(this.jsonObject, key);
    }

    public Long getLong(String key) {
        return JsonObjects.getLong(this.jsonObject, key);
    }

    public boolean isEquals(String key, String value) {
        if (this.isNull()) {
            return false;
        }
        String string = this.getString(key);
        if (EmptyUtils.isEmpty(string)) {
            return false;
        }
        return string.equals(value);
    }

    public String toJson() {
        return JsonObjects.toJson(this.jsonObject);
    }

    public <T> T formJson(Class<T> classOfT) {
        return JsonObjects.fromJson((JsonElement)this.jsonObject, classOfT);
    }

    public <T> T fromJsonTimeStamp(Class<T> classOfT) {
        return JsonObjects.fromJsonTimeStamp(this.jsonObject.toString(), classOfT);
    }

    public String toString() {
        return this.jsonObject.toString();
    }

    public <E> void addProperty(String key, E value) {
        if (this.jsonObject == null) {
            this.jsonObject = new JsonObject();
        }
        if (value instanceof String) {
            this.jsonObject.addProperty(key, (String)value);
        }
    }

    public JsonElement removeProperty(String key) {
        return this.jsonObject.remove(key);
    }

    public <E> List<E> toList(String key, Class<E> clazz) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        JsonArray jsonArray = JsonObjects.getJsonArray(this.jsonObject, key);
        assert (jsonArray != null);
        if (clazz == null) {
            return JsonObjects.toArrayList(jsonArray);
        }
        for (JsonElement jsonElement : jsonArray) {
            Object e = JSON.parseObject((String)jsonElement.toString(), clazz);
            resultList.add(e);
        }
        return resultList;
    }

    public <E> List<E> toList(String key) {
        return this.toList(key, null);
    }
}

