/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.util.io;

import com.github.hugh.exception.ToolboxException;
import com.github.hugh.util.system.OsUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import jodd.io.StreamUtil;

public class StreamUtils {
    public static InputStream getInputStream(String filePath) {
        InputStream inputStream;
        try {
            inputStream = new URL(filePath).openStream();
        }
        catch (MalformedURLException localMalformedURLException) {
            try {
                inputStream = new FileInputStream(filePath);
            }
            catch (Exception localException2) {
                ClassLoader localClassLoader = Thread.currentThread().getContextClassLoader();
                if (localClassLoader == null) {
                    localClassLoader = StreamUtil.class.getClassLoader();
                }
                if ((inputStream = OsUtils.isWindows() ? localClassLoader.getClass().getResourceAsStream(filePath) : localClassLoader.getResourceAsStream(filePath)) == null) {
                    throw new ToolboxException("Could not find file: " + filePath);
                }
            }
        }
        catch (IOException localIOException1) {
            throw new ToolboxException(localIOException1);
        }
        return inputStream;
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        int n;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }

    public static void toFile(InputStream inputStream, String filePath) {
        StreamUtils.toFile(inputStream, new File(filePath));
    }

    public static void toFile(InputStream inputStream, File file) {
        try (FileOutputStream os = new FileOutputStream(file);){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = inputStream.read(buffer, 0, 8192)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String toString(InputStream inputStream, String charset) {
        String string;
        ByteArrayOutputStream boa = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) != -1) {
                boa.write(buffer, 0, len);
            }
            byte[] result = boa.toByteArray();
            string = new String(result, charset);
        }
        catch (Throwable throwable) {
            try {
                try {
                    boa.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new ToolboxException(e);
            }
        }
        boa.close();
        return string;
    }

    public static String toString(InputStream inputStream) {
        return StreamUtils.toString(inputStream, "UTF-8");
    }

    public InputStream toInputStream(String str) {
        return new ByteArrayInputStream(str.getBytes());
    }

    public void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            throw new ToolboxException(e);
        }
    }

    public static byte[] resourceToByteArray(String path) {
        byte[] byArray;
        block8: {
            InputStream inputStream = StreamUtils.getInputStream(path);
            try {
                byArray = StreamUtils.toByteArray(inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new ToolboxException(ioe);
                }
            }
            inputStream.close();
        }
        return byArray;
    }
}

