/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.util.ip;

import com.github.hugh.model.dto.Ip2regionDTO;
import com.github.hugh.util.gson.JsonObjectUtils;
import com.github.hugh.util.io.StreamUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.lionsoul.ip2region.DataBlock;
import org.lionsoul.ip2region.DbConfig;
import org.lionsoul.ip2region.DbSearcher;

public class Ip2regionUtils {
    private static final String DB_PATH = "/ip2region/ip2region.db";

    private Ip2regionUtils() {
    }

    private static String getCityInfo(String ip) {
        try {
            DbConfig config = new DbConfig();
            byte[] bytes = StreamUtils.resourceToByteArray(DB_PATH);
            DbSearcher searcher = new DbSearcher(config, bytes);
            DataBlock dataBlock = searcher.memorySearch(ip);
            return dataBlock.getRegion();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JsonObject get(String ip) {
        String str = Ip2regionUtils.getCityInfo(ip);
        if (str == null) {
            return null;
        }
        String[] arr = str.split("\\|");
        JsonObject item = new JsonObject();
        item.addProperty("country", arr[0]);
        item.addProperty("region", arr[1]);
        item.addProperty("province", arr[2]);
        item.addProperty("city", arr[3]);
        item.addProperty("isp", arr[4]);
        return item;
    }

    public static Ip2regionDTO parse(String ip) {
        JsonObject jsonObject = Ip2regionUtils.get(ip);
        return JsonObjectUtils.fromJson((JsonElement)jsonObject, Ip2regionDTO.class);
    }
}

