/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.util.ip;

import com.github.hugh.util.regex.RegexUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;

public class IpUtils {
    private static final String REGEX_IP = "\\.";

    private IpUtils() {
    }

    public static String get(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip != null && ip.length() != 0) {
            ip = ip.split(",")[0];
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static String random() {
        int[][] range = new int[][]{{607649792, 608174079}, {1038614528, 1039007743}, {1783627776, 1784676351}, {2035023872, 2035154943}, {2078801920, 2079064063}, {-1950089216, -1948778497}, {-1425539072, -1425014785}, {-1236271104, -1235419137}, {-770113536, -768606209}, {-569376768, -564133889}};
        Random random = new Random();
        int index = random.nextInt(10);
        return IpUtils.num2ip(range[index][0] + new Random().nextInt(range[index][1] - range[index][0]));
    }

    private static String num2ip(int ip) {
        int[] b = new int[]{ip >> 24 & 0xFF, ip >> 16 & 0xFF, ip >> 8 & 0xFF, ip & 0xFF};
        return b[0] + "." + b[1] + "." + b[2] + "." + b[3];
    }

    public static boolean isInRange(String ip, String cidr) {
        String cidrIp;
        String[] cidrIps;
        int cidrIpAddr;
        int type;
        int mask;
        String[] ips = ip.split(REGEX_IP);
        int ipAddr = Integer.parseInt(ips[0]) << 24 | Integer.parseInt(ips[1]) << 16 | Integer.parseInt(ips[2]) << 8 | Integer.parseInt(ips[3]);
        return (ipAddr & (mask = -1 << 32 - (type = Integer.parseInt(cidr.replaceAll(".*/", ""))))) == ((cidrIpAddr = Integer.parseInt((cidrIps = (cidrIp = cidr.replaceAll("/.*", "")).split(REGEX_IP))[0]) << 24 | Integer.parseInt(cidrIps[1]) << 16 | Integer.parseInt(cidrIps[2]) << 8 | Integer.parseInt(cidrIps[3])) & mask);
    }

    public static int getIpCount(String mask) {
        return BigDecimal.valueOf(Math.pow(2.0, 32 - Integer.parseInt(mask))).setScale(0, 1).intValue();
    }

    public static String getIpFromLong(Long ip) {
        String s1 = String.valueOf((ip & 0xFF000000L) / 0x1000000L);
        String s2 = String.valueOf((ip & 0xFF0000L) / 65536L);
        String s3 = String.valueOf((ip & 0xFF00L) / 256L);
        String s4 = String.valueOf(ip & 0xFFL);
        return s1 + "." + s2 + "." + s3 + "." + s4;
    }

    public static Long getIpFromString(String ip) {
        String ipTemp = ip;
        long ipLong = Long.parseLong(ipTemp.substring(0, ipTemp.indexOf(46)));
        ipTemp = ipTemp.substring(ipTemp.indexOf(46) + 1);
        ipLong = ipLong * 256L + Long.parseLong(ipTemp.substring(0, ipTemp.indexOf(46)));
        ipTemp = ipTemp.substring(ipTemp.indexOf(".") + 1);
        ipLong = ipLong * 256L + Long.parseLong(ipTemp.substring(0, ipTemp.indexOf(46)));
        ipTemp = ipTemp.substring(ipTemp.indexOf(46) + 1);
        ipLong = ipLong * 256L + Long.parseLong(ipTemp);
        return ipLong;
    }

    public static String getMaskByMaskBit(String maskBit) {
        return "".equals(maskBit) ? "error, maskBit is null !" : IpUtils.getNetmask(maskBit);
    }

    public static String calcBeginIp(String ip, String maskBit) {
        return IpUtils.getIpFromLong(IpUtils.getBeginIpLong(ip, maskBit));
    }

    public static Long getBeginIpLong(String ip, String maskBit) {
        return IpUtils.getIpFromString(ip) & IpUtils.getIpFromString(IpUtils.getMaskByMaskBit(maskBit));
    }

    public static String calcEndIp(String ip, String maskBit) {
        return IpUtils.getIpFromLong(IpUtils.getEndIpLong(ip, maskBit));
    }

    public static Long getEndIpLong(String ip, String maskBit) {
        return IpUtils.getBeginIpLong(ip, maskBit) + (IpUtils.getIpFromString(IpUtils.getMaskByMaskBit(maskBit)) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static String getNetmask(String maskBit) {
        switch (maskBit) {
            case "1": {
                return "128.0.0.0";
            }
            case "2": {
                return "192.0.0.0";
            }
            case "3": {
                return "224.0.0.0";
            }
            case "4": {
                return "240.0.0.0";
            }
            case "5": {
                return "248.0.0.0";
            }
            case "6": {
                return "252.0.0.0";
            }
            case "7": {
                return "254.0.0.0";
            }
            case "8": {
                return "255.0.0.0";
            }
            case "9": {
                return "255.128.0.0";
            }
            case "10": {
                return "255.192.0.0";
            }
            case "11": {
                return "255.224.0.0";
            }
            case "12": {
                return "255.240.0.0";
            }
            case "13": {
                return "255.248.0.0";
            }
            case "14": {
                return "255.252.0.0";
            }
            case "15": {
                return "255.254.0.0";
            }
            case "16": {
                return "255.255.0.0";
            }
            case "17": {
                return "255.255.128.0";
            }
            case "18": {
                return "255.255.192.0";
            }
            case "19": {
                return "255.255.224.0";
            }
            case "20": {
                return "255.255.240.0";
            }
            case "21": {
                return "255.255.248.0";
            }
            case "22": {
                return "255.255.252.0";
            }
            case "23": {
                return "255.255.254.0";
            }
            case "24": {
                return "255.255.255.0";
            }
            case "25": {
                return "255.255.255.128";
            }
            case "26": {
                return "255.255.255.192";
            }
            case "27": {
                return "255.255.255.224";
            }
            case "28": {
                return "255.255.255.240";
            }
            case "29": {
                return "255.255.255.248";
            }
            case "30": {
                return "255.255.255.252";
            }
            case "31": {
                return "255.255.255.254";
            }
            case "32": {
                return "255.255.255.255";
            }
        }
        return "-1";
    }

    public static List<String> parseIpMaskRange(String ip, String mask) {
        List<String> list = new ArrayList<String>();
        if ("32".equals(mask)) {
            list.add(ip);
        } else {
            Object startIp = IpUtils.getBeginIpStr(ip, mask);
            Object endIp = IpUtils.calcEndIp(ip, mask);
            if (!"31".equals(mask)) {
                String subStart = ((String)startIp).split(REGEX_IP)[0] + "." + ((String)startIp).split(REGEX_IP)[1] + "." + ((String)startIp).split(REGEX_IP)[2] + ".";
                String subEnd = ((String)endIp).split(REGEX_IP)[0] + "." + ((String)endIp).split(REGEX_IP)[1] + "." + ((String)endIp).split(REGEX_IP)[2] + ".";
                startIp = subStart + (Integer.parseInt(((String)startIp).split(REGEX_IP)[3]) + 1);
                endIp = subEnd + (Integer.parseInt(((String)endIp).split(REGEX_IP)[3]) - 1);
            }
            list = IpUtils.parseIpRange((String)startIp, (String)endIp);
        }
        return list;
    }

    public static List<String> parseIpRange(String startIp, String endIp) {
        ArrayList<String> ips = new ArrayList<String>();
        String[] startIpArr = startIp.split(REGEX_IP);
        String[] endIpArr = endIp.split(REGEX_IP);
        int[] int_ipf = new int[4];
        int[] int_ipt = new int[4];
        for (int i = 0; i < 4; ++i) {
            int_ipf[i] = Integer.parseInt(startIpArr[i]);
            int_ipt[i] = Integer.parseInt(endIpArr[i]);
        }
        for (int A = int_ipf[0]; A <= int_ipt[0]; ++A) {
            for (int B = A == int_ipf[0] ? int_ipf[1] : 0; B <= (A == int_ipt[0] ? int_ipt[1] : 255); ++B) {
                for (int C = B == int_ipf[1] ? int_ipf[2] : 0; C <= (B == int_ipt[1] ? int_ipt[2] : 255); ++C) {
                    for (int D = C == int_ipf[2] ? int_ipf[3] : 0; D <= (C == int_ipt[2] ? int_ipt[3] : 255); ++D) {
                        ips.add(A + "." + B + "." + C + "." + D);
                    }
                }
            }
        }
        return ips;
    }

    public static String getBeginIpStr(String ip, String maskBit) {
        return IpUtils.getIpFromLong(IpUtils.getBeginIpLong(ip, maskBit));
    }

    public static boolean isSameNetworkSegment(String ip1, String ip2, String mask) {
        int ipValue2;
        int ipValue1;
        if (RegexUtils.isNotIp(ip1)) {
            return false;
        }
        if (RegexUtils.isNotIp(ip2)) {
            return false;
        }
        int maskInt = IpUtils.getIpV4Value(mask);
        return (maskInt & (ipValue1 = IpUtils.getIpV4Value(ip1))) == (maskInt & (ipValue2 = IpUtils.getIpV4Value(ip2)));
    }

    public static boolean isNotSameNetworkSegment(String ip1, String ip2, String mask) {
        return !IpUtils.isSameNetworkSegment(ip1, ip2, mask);
    }

    public static int getIpV4Value(String ipOrMask) {
        byte[] addr = IpUtils.getIpV4Bytes(ipOrMask);
        int address1 = addr[3] & 0xFF;
        address1 |= addr[2] << 8 & 0xFF00;
        address1 |= addr[1] << 16 & 0xFF0000;
        return address1 |= addr[0] << 24 & 0xFF000000;
    }

    public static byte[] getIpV4Bytes(String ipOrMask) {
        try {
            String[] addrs = ipOrMask.split(REGEX_IP);
            int length = addrs.length;
            byte[] addr = new byte[length];
            for (int index = 0; index < length; ++index) {
                addr[index] = (byte)(Integer.parseInt(addrs[index]) & 0xFF);
            }
            return addr;
        }
        catch (Exception exception) {
            return new byte[4];
        }
    }
}

