/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.util.regex;

import com.github.hugh.util.EmptyUtils;
import java.util.EnumMap;

public class CronRegex {
    public static boolean isTooShort(String str) {
        if (str == null) {
            return true;
        }
        String[] arr = str.split(" ");
        boolean flag = true;
        int length = arr.length;
        block7: for (int i = 1; i < length; ++i) {
            String v;
            switch (v = arr[i]) {
                case "*": 
                case "?": {
                    continue block7;
                }
                default: {
                    flag = false;
                }
            }
        }
        if (flag) {
            String top = arr[0];
            if (top.contains("*")) {
                return true;
            }
            if (!top.contains("-")) {
                if (top.contains("/")) {
                    String[] sec = top.split("/");
                    return Integer.parseInt(sec[1]) < 30;
                }
                return Integer.parseInt(top) < 30;
            }
        }
        return false;
    }

    public static boolean isCron(String string) {
        if (EmptyUtils.isEmpty(string)) {
            return false;
        }
        String cronRegex = CronRegex.createCronRegex();
        return string.matches(cronRegex);
    }

    public static boolean isNotCron(String string) {
        return !CronRegex.isCron(string);
    }

    private static String createCronRegex() {
        EnumMap<Field, Object> regexByField = new EnumMap<Field, Object>(Field.class);
        regexByField.put(Field.sec, "[0-5]?\\d");
        regexByField.put(Field.min, "[0-5]?\\d");
        regexByField.put(Field.hour, "[01]?\\d|2[0-3]");
        regexByField.put(Field.day, "0?[1-9]|[12]\\d|3[01]");
        regexByField.put(Field.month, "[1-9]|1[012]");
        regexByField.put(Field.dayOfWeek, "[0-6]");
        regexByField.put(Field.year, "|\\d{4}");
        for (Field field : Field.values()) {
            String number = (String)regexByField.get((Object)field);
            String range = "(?:" + number + ")(?:(?:-|/|," + (Field.dayOfWeek == field ? "|#" : "") + ")(?:" + number + "))?";
            if (field == Field.dayOfWeek) {
                range = range + "(?:L)?";
            }
            if (field == Field.month) {
                range = range + "(?:L|W)?";
            }
            regexByField.put(field, "\\?|\\*|" + range + "(?:," + range + ")*");
        }
        String monthValues = "JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC";
        String monthRange = "(?:" + monthValues + ")(?:(?:-)(?:" + monthValues + "))?";
        regexByField.put(Field.month, (String)regexByField.get((Object)Field.month) + "|\\?|\\*|" + monthRange + "(?:," + monthRange + ")*");
        String dayOfWeekValues = "MON|TUE|WED|THU|FRI|SAT|SUN";
        String dayOfWeekRange = "(?:" + dayOfWeekValues + ")(?:(?:-)(?:" + dayOfWeekValues + "))?";
        regexByField.put(Field.dayOfWeek, (String)regexByField.get((Object)Field.dayOfWeek) + "|\\?|\\*|" + dayOfWeekRange + "(?:," + dayOfWeekRange + ")*");
        return "^\\s*($|#|\\w+\\s*=|(" + (String)regexByField.get((Object)Field.sec) + ")\\s+(" + (String)regexByField.get((Object)Field.min) + ")\\s+(" + (String)regexByField.get((Object)Field.hour) + ")\\s+(" + (String)regexByField.get((Object)Field.day) + ")\\s+(" + (String)regexByField.get((Object)Field.month) + ")\\s+(" + (String)regexByField.get((Object)Field.dayOfWeek) + ")(|\\s)+(" + (String)regexByField.get((Object)Field.year) + "))$";
    }

    public static enum Field {
        sec,
        min,
        hour,
        day,
        month,
        dayOfWeek,
        year;

    }
}

