/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.util.regex;

import com.github.hugh.util.EmptyUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexUtils {
    private static final String[] SPECIAL_CHARS = new String[]{"\\", "$", "(", ")", "*", "+", ".", "[", "]", "?", "^", "{", "}", "|"};
    private static final Pattern PUNCTUATION_PATTERN = Pattern.compile("\\p{P}");
    private static final Pattern LETTER_PATTERN = Pattern.compile("\\p{L}");
    private static final Pattern MARKABLE_PATTERN = Pattern.compile("\\p{M}");
    private static final Pattern DELIMITER_PATTERN = Pattern.compile("\\p{Z}");
    private static final Pattern SYMBOL_PATTERN = Pattern.compile("\\p{S}");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("\\p{N}");
    private static final Pattern OTHER_CHARS_PATTERN = Pattern.compile("\\p{C}");
    private static final Pattern EMAIL_ENGLISH_PATTERN = Pattern.compile("^[a-zA-Z0-9_-]+@[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)+$");
    private static final Pattern EMAIL_CHINESE_PATTERN = Pattern.compile("^[A-Za-z0-9\\u4e00-\\u9fa5]+@[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)+$");
    private static final Pattern PHONE_PATTERN = Pattern.compile("^((13[0-9])|(14[5,7,9])|(15([0-3]|[5-9]))|(16([5-7]))|(17[0,1,2,3,5,6,7,8,9])|(18[0-9])|(19[1|5|8|9]))\\d{8}$");
    private static final Pattern URL_PATTERN = Pattern.compile("^([hH][tT]{2}[pP]:/*|[hH][tT]{2}[pP][sS]:/*|[fF][tT][pP]:/*)(([A-Za-z0-9-~]+).)+([A-Za-z0-9-~\\/])+(\\?{0,1}(([A-Za-z0-9-~]+\\={0,1})([A-Za-z0-9-~]*)\\&{0,1})*)$");
    private static final Pattern WEB_SITE_PATTERN = Pattern.compile("^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]");
    private static final String SQL_PATTERN = "(?:')|(?:--)|(/\\*(?:.|[\\n\\r])*?\\*/)|(\\b(select|update|union|and|or|delete|insert|trancate|char|into|substr|ascii|declare|exec|count|master|drop|execute)\\b)";
    private static final Pattern IP_PATTERN = Pattern.compile("^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$");
    private static final Pattern PORT_PATTERN = Pattern.compile("([0-9]|[1-9]\\d{1,3}|[1-5]\\d{4}|6[0-5]{2}[0-3][0-5])");
    private static final Pattern FULL_CHINESE_PATTERN = Pattern.compile("[\\u4e00-\\u9fa5]+");
    private static final Pattern SPECIAL_CHAR_PATTERN = Pattern.compile("[ _`~!@#$%^&*()+=|{}':;,\\[\\].<>/?\uff01\uffe5\u2026\uff08\uff09\u2014\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]|\n|\r|\t");

    private RegexUtils() {
    }

    public static String escapeWord(String keyword) {
        if (EmptyUtils.isNotEmpty(keyword)) {
            for (String key : SPECIAL_CHARS) {
                if (!keyword.contains(key)) continue;
                keyword = keyword.replace(key, "\\" + key);
            }
        }
        return keyword;
    }

    public static boolean isPunctuation(String string) {
        return RegexUtils.isPatternMatch(string, PUNCTUATION_PATTERN);
    }

    public static boolean isMarkable(String string) {
        return RegexUtils.isPatternMatch(string, MARKABLE_PATTERN);
    }

    public static boolean isSymbol(String string) {
        return RegexUtils.isPatternMatch(string, SYMBOL_PATTERN);
    }

    public static boolean isOtherChars(String string) {
        return RegexUtils.isPatternMatch(string, OTHER_CHARS_PATTERN);
    }

    public static boolean isNumber(String string) {
        return RegexUtils.isPatternMatch(string, NUMBER_PATTERN);
    }

    public static boolean isEmail(String string) {
        return RegexUtils.isPatternMatch(string, EMAIL_ENGLISH_PATTERN);
    }

    public static boolean isNotEmail(String string) {
        return !RegexUtils.isEmail(string);
    }

    public static boolean isUrl(String string) {
        return RegexUtils.isPatternMatch(string, URL_PATTERN);
    }

    public static boolean isWebSite(String string) {
        return WEB_SITE_PATTERN.matcher(string).matches();
    }

    public static boolean isNotWebSite(String string) {
        return !RegexUtils.isWebSite(string);
    }

    public static boolean isPhone(String mobile) {
        if (EmptyUtils.isEmpty(mobile) || mobile.length() != 11) {
            return false;
        }
        Matcher m = PHONE_PATTERN.matcher(mobile);
        return m.matches();
    }

    public static boolean isNotPhone(String mobile) {
        return !RegexUtils.isPhone(mobile);
    }

    public static boolean isSql(String str) {
        return RegexUtils.isPatternMatch(str, Pattern.compile(SQL_PATTERN, 2));
    }

    public static boolean isIp(String string) {
        if (EmptyUtils.isEmpty(string)) {
            return false;
        }
        return IP_PATTERN.matcher(string).matches();
    }

    public static boolean isNotIp(String string) {
        return !RegexUtils.isIp(string);
    }

    public static boolean isPort(String string) {
        if (EmptyUtils.isEmpty(string)) {
            return false;
        }
        return PORT_PATTERN.matcher(string).matches();
    }

    public static boolean isNotPort(String string) {
        return !RegexUtils.isPort(string);
    }

    protected static boolean isPatternMatch(String string, Pattern pattern) {
        if (EmptyUtils.isEmpty(string)) {
            return false;
        }
        return pattern.matcher(string).find();
    }

    public static boolean isFullChinese(String str) {
        if (EmptyUtils.isEmpty(str)) {
            return false;
        }
        return FULL_CHINESE_PATTERN.matcher(str).matches();
    }

    public static boolean isNotFullChinese(String str) {
        return !RegexUtils.isFullChinese(str);
    }

    public static boolean isLonLat(String longitude, String latitude) {
        return RegexUtils.isLongitude(longitude) && RegexUtils.isLatitude(latitude);
    }

    public static boolean isNotLonLat(String longitude, String latitude) {
        return !RegexUtils.isLonLat(longitude, latitude);
    }

    public static boolean isLongitude(String longitude) {
        if (EmptyUtils.isEmpty(longitude)) {
            return false;
        }
        String longitudePattern = "^[\\-+]?(0?\\d{1,2}\\.\\d{1,8}|1[0-7]?\\d{1}\\.\\d{1,8}|180\\.0{1,8})$";
        longitude = longitude.strip();
        return Pattern.matches(longitudePattern, longitude);
    }

    public static boolean isLatitude(String latitude) {
        if (EmptyUtils.isEmpty(latitude)) {
            return false;
        }
        String latitudePattern = "^[\\-+]?([0-8]?\\d{1}\\.\\d{1,8}|90\\.0{1,8})$";
        latitude = latitude.strip();
        return Pattern.matches(latitudePattern, latitude);
    }
}

