package com.github.hugh.constant;

/**
 * 常用的字符串常量
 *
 * @author hugh
 * @since 2.4.10
 */
public class StrPool {

    /**
     * 英文逗号
     */
    public static final String COMMA = ",";

    /**
     * 英文小数点
     */
    public static final String POINT = ".";

    /**
     * 反斜杠 {@code "\\"}
     */
    public static final String BACKSLASH = "\\";

    /**
     * 字符串常量：斜杠 {@code "/"}
     */
    public static final String SLASH = "/";

    /**
     * 空字符串
     */
    public static final String EMPTY = "";

    /**
     * 字符常量：空格符 {@code ' '}
     */
    public static final String SPACE = " ";

    /**
     * 字符串常量：制表符 {@code "\t"}
     */
    public static final String TAB = "\t";

    /**
     * 字符串常量：减号（连接符） {@code "-"}
     */
    public static final String DASHED = "-";

    /**
     * 常量：下划线字符 "_"
     *
     * <p>
     * 该常量表示一个下划线字符，在Java中通常用作标识符的一部分，而不是作为一个特殊的命名方式。
     * </p>
     *
     * 示例用法：
     * <pre>
     * String name = "John" + StrPool.UNDERLINE + "Doe";
     * // 输出结果："John_Doe"
     * </pre>
     *
     * @since 2.7.0
     */
    public static final String UNDERLINE = "_";

    /**
     * 字符串常量：花括号（左） <code>"{"</code>
     */
    public static final String CURLY_BRACKETS_START = "{";

    /**
     * 字符串常量：花括号（右） <code>"}"</code>
     */
    public static final String CURLY_BRACKETS_END = "}";

    /**
     * 字符串常量：中括号（左） {@code "["}
     */
    public static final String BRACKET_START = "[";

    /**
     * 字符串常量：中括号（右） {@code "]"}
     */
    public static final String BRACKET_END = "]";
}
