/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.crypto;

import com.github.hugh.exception.ToolboxException;
import com.github.hugh.util.EmptyUtils;
import com.github.hugh.util.base.BaseConvertUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Md5Utils {
    public static String lowerCase(String string) {
        return Md5Utils.encrypt(string, true, "MD5");
    }

    public static String upperCase(String string) {
        return Md5Utils.encrypt(string, false, "MD5");
    }

    public static String encrypt(String string, boolean lowerCase, String encryptType) {
        if (EmptyUtils.isEmpty((Object)string)) {
            return string;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(encryptType);
            byte[] output = messageDigest.digest(string.getBytes());
            String result = BaseConvertUtils.hexToString((byte[])output);
            if (lowerCase) {
                return result.toLowerCase();
            }
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new ToolboxException((Throwable)e);
        }
    }

    public static String encryptFile(File file) {
        String string;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            int len;
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[0xA00000];
            while ((len = fileInputStream.read(buffer)) > 0) {
                digest.update(buffer, 0, len);
            }
            Object md5 = new BigInteger(1, digest.digest()).toString(16);
            int length = 32 - ((String)md5).length();
            if (length > 0) {
                for (int i = 0; i < length; ++i) {
                    md5 = "0" + (String)md5;
                }
            }
            string = md5;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | NoSuchAlgorithmException e) {
                throw new ToolboxException((Throwable)e);
            }
        }
        fileInputStream.close();
        return string;
    }

    public static String encryptFile(String filePath) {
        return Md5Utils.encryptFile(new File(filePath));
    }
}

