/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.crypto;

import com.github.hugh.util.base.BaseConvertUtils;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public class DesEncDecUtils {
    private static final DesEncDecUtils ourInstance = new DesEncDecUtils();
    private static Cipher ENCRYPT_CIPHER;
    private static Cipher DECRYPT_CIPHER;
    private static final String ENCRYPTION_METHOD_DES = "DES";

    private DesEncDecUtils() {
    }

    public static DesEncDecUtils getInstance(String key) {
        try {
            DESKeySpec dks = new DESKeySpec(key.getBytes());
            SecretKeyFactory skf = SecretKeyFactory.getInstance(ENCRYPTION_METHOD_DES);
            SecretKey desKey = skf.generateSecret(dks);
            ENCRYPT_CIPHER = Cipher.getInstance(ENCRYPTION_METHOD_DES);
            DECRYPT_CIPHER = Cipher.getInstance(ENCRYPTION_METHOD_DES);
            ENCRYPT_CIPHER.init(1, desKey);
            DECRYPT_CIPHER.init(2, desKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | NoSuchPaddingException e) {
            e.printStackTrace();
        }
        return ourInstance;
    }

    public String encrypt(String str) throws BadPaddingException, IllegalBlockSizeException {
        byte[] utf8 = str.getBytes(StandardCharsets.UTF_8);
        byte[] enc = ENCRYPT_CIPHER.doFinal(utf8);
        return Base64.getEncoder().encodeToString(enc);
    }

    public String decrypt(String str) throws BadPaddingException, IllegalBlockSizeException {
        byte[] dec = Base64.getDecoder().decode(str);
        byte[] utf8 = DECRYPT_CIPHER.doFinal(dec);
        return new String(utf8, StandardCharsets.UTF_8);
    }

    public static String genCore(String key, String value) throws BadPaddingException, IllegalBlockSizeException {
        DesEncDecUtils des = DesEncDecUtils.getInstance(key);
        return des.encrypt(value);
    }

    public static boolean check(String key, String value, String sign) throws BadPaddingException, IllegalBlockSizeException {
        String core = DesEncDecUtils.genCore(key, value);
        return core.equals(sign);
    }

    public static String encrypt(String data, String cryptKey) throws NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, InvalidKeySpecException, BadPaddingException, InvalidKeyException {
        byte[] encrypt = DesEncDecUtils.encrypt(data.getBytes(), cryptKey.getBytes());
        byte[] hexBytes = BaseConvertUtils.decToHexBytes((byte[])encrypt);
        return new String(hexBytes);
    }

    private static byte[] encrypt(byte[] data, byte[] key) throws NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, InvalidKeySpecException, BadPaddingException, InvalidKeyException {
        return DesEncDecUtils.operate(data, key, 1);
    }

    public static String decrypt(String data, String cryptKey) throws Exception {
        byte[] bytes = BaseConvertUtils.hexToDec((byte[])data.getBytes());
        byte[] decrypt = DesEncDecUtils.decrypt(bytes, cryptKey.getBytes());
        return new String(decrypt);
    }

    private static byte[] decrypt(byte[] data, byte[] key) throws Exception {
        return DesEncDecUtils.operate(data, key, 2);
    }

    private static byte[] operate(byte[] data, byte[] key, int opMode) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        SecureRandom sr = new SecureRandom();
        DESKeySpec dks = new DESKeySpec(key);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ENCRYPTION_METHOD_DES);
        SecretKey secretKey = keyFactory.generateSecret(dks);
        Cipher cipher = Cipher.getInstance(ENCRYPTION_METHOD_DES);
        cipher.init(opMode, (Key)secretKey, sr);
        return cipher.doFinal(data);
    }
}

