/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.crypto.base;

import com.github.hugh.crypto.Md5Utils;
import com.github.hugh.crypto.exception.CryptoException;
import com.github.hugh.crypto.model.SecureDTO;
import com.github.hugh.util.DateUtils;
import java.util.Date;

public class SecureUtils {
    private SecureUtils() {
    }

    public static String signature(String appkey, String token, String data, String notifyUrl, String timestamp) {
        return Md5Utils.lowerCase(appkey + token + data + notifyUrl + timestamp);
    }

    public static boolean verifySignature(SecureDTO secureDTO) {
        return SecureUtils.verifySignature(secureDTO, 30);
    }

    public static boolean verifySignature(SecureDTO secureDTO, int difference) {
        if (secureDTO == null) {
            throw new CryptoException("secureDTO is null");
        }
        if (difference > 0 && !SecureUtils.verifyTimestamp(Long.parseLong(secureDTO.getTimestamp()), difference)) {
            return false;
        }
        String signature = SecureUtils.signature(secureDTO.getAppkey(), secureDTO.getToken(), secureDTO.getData(), secureDTO.getNotifyUrl(), secureDTO.getTimestamp());
        return signature.equals(secureDTO.getSign());
    }

    public static boolean verifyTimestamp(long timestamp, int difference) {
        Date date = DateUtils.parseTimestamp((long)timestamp);
        long l = DateUtils.minutesDifference((Date)date, (Date)new Date());
        return l < (long)difference;
    }
}

