/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.crypto;

import com.github.hugh.exception.ToolboxException;
import com.github.hugh.util.EmptyUtils;
import com.github.hugh.util.base.BaseConvertUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Md5Utils {
    public static String lowerCase(String string) {
        return Md5Utils.encrypt(string, true, "MD5");
    }

    public static String upperCase(String string) {
        return Md5Utils.encrypt(string, false, "MD5");
    }

    public static String encrypt(String string, boolean lowerCase, String encryptType) {
        if (EmptyUtils.isEmpty((Object)string)) {
            return string;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(encryptType);
            byte[] output = messageDigest.digest(string.getBytes());
            String result = BaseConvertUtils.hexBytesToString((byte[])output);
            if (lowerCase) {
                return result.toLowerCase();
            }
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new ToolboxException((Throwable)e);
        }
    }

    public static String encryptFile(File file) {
        String string;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            int numRead;
            byte[] buffer = new byte[1024];
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            while ((numRead = fileInputStream.read(buffer)) > 0) {
                md5.update(buffer, 0, numRead);
            }
            byte[] digest = md5.digest();
            StringBuilder result = new StringBuilder();
            for (byte b : digest) {
                result.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
            }
            string = result.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | NoSuchAlgorithmException e) {
                throw new ToolboxException((Throwable)e);
            }
        }
        fileInputStream.close();
        return string;
    }

    public static String encryptFile(String filePath) {
        return Md5Utils.encryptFile(new File(filePath));
    }
}

