/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.crypto;

import com.github.hugh.crypto.AppkeyUtils;
import com.github.hugh.crypto.exception.CryptoException;
import com.github.hugh.util.EmptyUtils;
import com.github.hugh.util.regex.RegexUtils;

public class Crc16Utils {
    private static final byte[] crc16_tab_h = new byte[]{0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64};
    private static final byte[] crc16_tab_l = new byte[]{0, -64, -63, 1, -61, 3, 2, -62, -58, 6, 7, -57, 5, -59, -60, 4, -52, 12, 13, -51, 15, -49, -50, 14, 10, -54, -53, 11, -55, 9, 8, -56, -40, 24, 25, -39, 27, -37, -38, 26, 30, -34, -33, 31, -35, 29, 28, -36, 20, -44, -43, 21, -41, 23, 22, -42, -46, 18, 19, -45, 17, -47, -48, 16, -16, 48, 49, -15, 51, -13, -14, 50, 54, -10, -9, 55, -11, 53, 52, -12, 60, -4, -3, 61, -1, 63, 62, -2, -6, 58, 59, -5, 57, -7, -8, 56, 40, -24, -23, 41, -21, 43, 42, -22, -18, 46, 47, -17, 45, -19, -20, 44, -28, 36, 37, -27, 39, -25, -26, 38, 34, -30, -29, 35, -31, 33, 32, -32, -96, 96, 97, -95, 99, -93, -94, 98, 102, -90, -89, 103, -91, 101, 100, -92, 108, -84, -83, 109, -81, 111, 110, -82, -86, 106, 107, -85, 105, -87, -88, 104, 120, -72, -71, 121, -69, 123, 122, -70, -66, 126, 127, -65, 125, -67, -68, 124, -76, 116, 117, -75, 119, -73, -74, 118, 114, -78, -77, 115, -79, 113, 112, -80, 80, -112, -111, 81, -109, 83, 82, -110, -106, 86, 87, -105, 85, -107, -108, 84, -100, 92, 93, -99, 95, -97, -98, 94, 90, -102, -101, 91, -103, 89, 88, -104, -120, 72, 73, -119, 75, -117, -118, 74, 78, -114, -113, 79, -115, 77, 76, -116, 68, -124, -123, 69, -121, 71, 70, -122, -126, 66, 67, -125, 65, -127, -128, 64};

    private Crc16Utils() {
    }

    private static int calcCrc16(byte[] data) {
        return Crc16Utils.calcCrc16(data, 0, data.length);
    }

    private static int calcCrc16(byte[] data, int offset, int len) {
        return Crc16Utils.calcCrc16(data, offset, len, 65535);
    }

    private static int calcCrc16(byte[] data, int offset, int len, int preval) {
        int ucCRCHi = (preval & 0xFF00) >> 8;
        int ucCRCLo = preval & 0xFF;
        for (int i = 0; i < len; ++i) {
            int iIndex = (ucCRCLo ^ data[offset + i]) & 0xFF;
            ucCRCLo = ucCRCHi ^ crc16_tab_h[iIndex];
            ucCRCHi = crc16_tab_l[iIndex];
        }
        return (ucCRCHi & 0xFF) << 8 | ucCRCLo & 0xFF & 0xFFFF;
    }

    public static String generate() {
        return Crc16Utils.generate(8);
    }

    public static String generate(int length) {
        return Crc16Utils.generate(length, 2);
    }

    public static String generateLowerCase(int length) {
        return Crc16Utils.generateLowerCase(length, 2);
    }

    public static String generateLowerCase(int length, int verifyLength) {
        return Crc16Utils.generate(length, verifyLength, false);
    }

    public static String generate(int length, int verifyLe) {
        return Crc16Utils.generate(length, verifyLe, true);
    }

    private static String generate(int length, int verifyLength, boolean flag) {
        if (length <= 0) {
            throw new CryptoException("length error");
        }
        if (RegexUtils.isNotEvenNumber((long)verifyLength)) {
            throw new CryptoException("is not even number");
        }
        if (length <= verifyLength) {
            throw new CryptoException("code length less than verify length error");
        }
        String random = AppkeyUtils.generate().substring(0, length);
        String code = random + Crc16Utils.getVerCode(random, verifyLength);
        if (flag) {
            return code.toUpperCase();
        }
        return code.toLowerCase();
    }

    public static String getVerCode(String data, int verifyLength) {
        int length = data.length() / 2;
        byte[] byteArray = new byte[length];
        for (int i = 0; i < length; ++i) {
            byteArray[i] = (byte)Short.parseShort(data.substring(i * 2, i * 2 + 2), 16);
        }
        int crc = Crc16Utils.calcCrc16(byteArray);
        int temp = verifyLength / 2;
        String a = String.format("%04x", crc).toUpperCase().substring(temp, verifyLength);
        String b = String.format("%04x", crc).toUpperCase().substring(0, temp);
        return a + b;
    }

    @Deprecated
    public static boolean checkCode(String str) {
        return Crc16Utils.verifyCode(str);
    }

    public static boolean verifyCode(String str) {
        return Crc16Utils.verifyCode(str, 2);
    }

    public static boolean verifyCode(String str, int verifyLength) {
        if (EmptyUtils.isEmpty((Object)str)) {
            return false;
        }
        if (RegexUtils.isNotEvenNumber((long)verifyLength)) {
            throw new CryptoException("is not even number");
        }
        try {
            String checkBody = str.substring(0, str.length() - verifyLength);
            String sign = str.substring(str.length() - verifyLength);
            String checkCode = Crc16Utils.getVerCode(checkBody, verifyLength);
            return sign.equalsIgnoreCase(checkCode);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getModbusChecksum(String data) {
        return Crc16Utils.getModbusChecksum(data, false);
    }

    public static String getModbusChecksum(String data, boolean sequence) {
        int len = (data = data.replace(" ", "")).length();
        if (len % 2 != 0) {
            return "0000";
        }
        int num = len / 2;
        byte[] para = new byte[num];
        for (int i = 0; i < num; ++i) {
            int value = Integer.valueOf(data.substring(i * 2, 2 * (i + 1)), 16);
            para[i] = (byte)value;
        }
        return Crc16Utils.getModbusChecksum(para, sequence);
    }

    public static String getModbusChecksum(byte[] bytes) {
        return Crc16Utils.getModbusChecksum(bytes, false);
    }

    public static String getModbusChecksum(byte[] bytes, boolean sequence) {
        int crcHex = 65535;
        int polynomial = 40961;
        for (byte aByte : bytes) {
            crcHex ^= aByte & 0xFF;
            for (int j = 0; j < 8; ++j) {
                if ((crcHex & 1) != 0) {
                    crcHex >>= 1;
                    crcHex ^= polynomial;
                    continue;
                }
                crcHex >>= 1;
            }
        }
        String result = Integer.toHexString(crcHex).toUpperCase();
        if (result.length() != 4) {
            StringBuilder stringBuilder = new StringBuilder("0000");
            result = stringBuilder.replace(4 - result.length(), 4, result).toString();
        }
        if (sequence) {
            return result.substring(2, 4) + result.substring(0, 2);
        }
        return result;
    }

    public static boolean verifyModbus(String data, String checksum) {
        return Crc16Utils.verifyModbus(data, checksum, false);
    }

    public static boolean verifyModbus(String data, String checksum, boolean sequence) {
        if (EmptyUtils.isEmpty((Object)data)) {
            throw new CryptoException("data is empty");
        }
        if (EmptyUtils.isEmpty((Object)checksum)) {
            throw new CryptoException("checksum is empty");
        }
        checksum = checksum.replace(" ", "").trim().strip();
        String modbusChecksum = Crc16Utils.getModbusChecksum(data, sequence);
        return modbusChecksum.equals(checksum);
    }
}

