/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.crypto.base.sm4;

import com.github.hugh.crypto.base.sm4.Sm4Result;
import com.github.hugh.crypto.emus.Sm4Enum;
import com.github.hugh.crypto.util.Sm4Utils;
import com.github.hugh.exception.ToolboxException;
import com.github.hugh.util.EmptyUtils;
import com.github.hugh.util.base.Base64;
import com.github.hugh.util.base.BaseConvertUtils;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class Sm4 {
    private final String key;
    private String encryptKeyType;
    private String encryptResultType;

    public Sm4(String key) {
        this.key = key;
    }

    public static Sm4 on(String key) {
        return new Sm4(key);
    }

    public static Sm4 on() {
        byte[] bytes = Sm4Utils.generateKey();
        return new Sm4(BaseConvertUtils.hexBytesToString((byte[])bytes));
    }

    public Sm4 encryptKeyTypeByStr() {
        this.encryptKeyType = Sm4Enum.TEXT.getCode();
        return this;
    }

    public Sm4 encryptResultTypeByHex() {
        this.encryptResultType = Sm4Enum.HEX.getCode();
        return this;
    }

    public Sm4 encryptKeyTypeByBase64() {
        this.encryptKeyType = Sm4Enum.BASE64.getCode();
        return this;
    }

    public Sm4 encryptKeyTypeByHex() {
        this.encryptKeyType = Sm4Enum.HEX.getCode();
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public Sm4Result encryptEcb(String text) {
        return this.encrypt(text, null);
    }

    public Sm4Result encryptCbc(String text, String iv) {
        return this.encrypt(text, iv);
    }

    private Sm4Result encrypt(String text, String iv) {
        byte[] keyBytes = this.getKeyOrIvBytes(this.key, this.encryptKeyType);
        byte[] ivBytes = null;
        if (iv != null) {
            ivBytes = this.getKeyOrIvBytes(iv, this.encryptKeyType);
        }
        return ivBytes == null ? new Sm4Result(Sm4Utils.encryptEcbPadding(keyBytes, text)) : new Sm4Result(Sm4Utils.encryptCbcPadding(keyBytes, ivBytes, text));
    }

    public String decryptEcb(String cipherText) {
        return this.decryptPadding(cipherText, null);
    }

    public String decryptCbc(String cipherText, String iv) {
        if (EmptyUtils.isEmpty((Object)iv)) {
            throw new ToolboxException("iv is null");
        }
        return this.decryptPadding(cipherText, iv);
    }

    private String decryptPadding(String cipherText, String iv) {
        byte[] keyBytes = this.getKeyOrIvBytes(this.key, this.encryptKeyType);
        byte[] ivBytes = null;
        if (iv != null) {
            ivBytes = this.getKeyOrIvBytes(iv, this.encryptKeyType);
        }
        byte[] cipherTextByte = Sm4Enum.HEX.getCode().equals(this.encryptResultType) ? BaseConvertUtils.hexToBytes((String)cipherText) : Base64.decodeToByte((String)cipherText);
        return ivBytes == null ? Sm4Utils.decryptEcbPadding(keyBytes, cipherTextByte) : Sm4Utils.decryptCbcPadding(keyBytes, ivBytes, cipherTextByte);
    }

    private byte[] getKeyOrIvBytes(String text, String encryptKeyType) {
        byte[] keyBytes;
        if (Sm4Enum.TEXT.getCode().equals(encryptKeyType)) {
            if (text.getBytes().length < 16) {
                throw new ToolboxException("\u5bc6\u94a5\u957f\u5ea6\u4e0d\u80fd\u5c11\u4e8e 16 \u5b57\u8282\uff01");
            }
            keyBytes = Arrays.copyOfRange(text.getBytes(), 0, 16);
        } else if (Sm4Enum.HEX.getCode().equals(encryptKeyType)) {
            keyBytes = BaseConvertUtils.hexToBytes((String)text);
        } else if (Sm4Enum.BASE64.getCode().equals(encryptKeyType)) {
            keyBytes = Base64.decodeToByte((String)text);
        } else {
            throw new ToolboxException("\u9519\u8bef\u52a0\u5bc6key\u7c7b\u578b");
        }
        return keyBytes;
    }

    public boolean verifyEcb(String cipherText, String plainText) {
        byte[] decryptData = this.decryptEcb(cipherText).getBytes(StandardCharsets.UTF_8);
        byte[] srcData = plainText.getBytes(StandardCharsets.UTF_8);
        return Arrays.equals(decryptData, srcData);
    }

    public boolean verifyCbc(String cipherText, String iv, String plainText) {
        String decryptedCbcText = this.decryptCbc(cipherText, iv);
        byte[] decryptData = decryptedCbcText.getBytes(StandardCharsets.UTF_8);
        byte[] srcData = plainText.getBytes(StandardCharsets.UTF_8);
        return Arrays.equals(decryptData, srcData);
    }
}

