/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.crypto.util;

import com.github.hugh.crypto.emus.Sm4Enum;
import com.github.hugh.exception.ToolboxException;
import com.github.hugh.util.base.BaseConvertUtils;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Sm4Utils {
    public static final int DEFAULT_KEY_SIZE = 128;

    private Sm4Utils() {
    }

    public static byte[] generateKey() {
        try {
            return Sm4Utils.generateKey(128);
        }
        catch (Exception exception) {
            throw new ToolboxException(exception.getMessage());
        }
    }

    public static byte[] generateKey(int keySize) {
        try {
            KeyGenerator kg = KeyGenerator.getInstance(Sm4Enum.ALGORITHM_NAME.getCode(), "BC");
            kg.init(keySize, new SecureRandom());
            return kg.generateKey().getEncoded();
        }
        catch (Exception exception) {
            throw new ToolboxException(exception.getMessage());
        }
    }

    public static byte[] encryptEcbPadding(String hexKey, String data) {
        try {
            Cipher cipher = Sm4Utils.generateEcbCipher(1, BaseConvertUtils.hexToBytes((String)hexKey));
            return cipher.doFinal(data.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception exception) {
            throw new ToolboxException(exception.getMessage());
        }
    }

    public static byte[] encryptEcbPadding(byte[] bytes, String data) {
        try {
            Cipher cipher = Sm4Utils.generateEcbCipher(1, bytes);
            return cipher.doFinal(data.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception exception) {
            throw new ToolboxException((Throwable)exception);
        }
    }

    public static String encryptEcbPaddingToHex(String hexKey, String data) {
        return BaseConvertUtils.hexBytesToString((byte[])Sm4Utils.encryptEcbPadding(hexKey, data));
    }

    public static String decryptEcbPadding(String hexKey, String cipherText) {
        return Sm4Utils.decryptEcbPadding(BaseConvertUtils.hexToBytes((String)hexKey), BaseConvertUtils.hexToBytes((String)cipherText));
    }

    public static String decryptEcbPadding(byte[] keyBytes, byte[] cipherText) {
        byte[] decryptBytes;
        try {
            Cipher cipher = Sm4Utils.generateEcbCipher(2, keyBytes);
            decryptBytes = cipher.doFinal(cipherText);
        }
        catch (BadPaddingException e) {
            if ("pad block corrupted".equals(e.getMessage())) {
                Cipher cipher = Sm4Utils.generateEcbCipher(Sm4Enum.ALGORITHM_NAME_ECB_NO_PADDING.getCode(), 2, keyBytes);
                try {
                    decryptBytes = cipher.doFinal(cipherText);
                }
                catch (IllegalBlockSizeException ex) {
                    throw new ToolboxException("\u89e3\u5bc6\u5931\u8d25\uff1a\u65e0\u6548\u7684\u5757\u5927\u5c0f", (Throwable)ex);
                }
                catch (BadPaddingException ex) {
                    throw new ToolboxException("\u89e3\u5bc6\u5931\u8d25\uff1a\u586b\u5145\u5f02\u5e38", (Throwable)ex);
                }
            }
            throw new ToolboxException("\u89e3\u5bc6\u5931\u8d25\uff1a\u586b\u5145\u5f02\u5e38", (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            throw new ToolboxException("\u89e3\u5bc6\u5931\u8d25\uff1a\u65e0\u6548\u7684\u5757\u5927\u5c0f", (Throwable)e);
        }
        catch (Exception e) {
            throw new ToolboxException("\u89e3\u5bc6\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef", (Throwable)e);
        }
        return new String(decryptBytes);
    }

    public static String encryptCbcPadding(String hexKey, String iv, String data) {
        byte[] bytes = Sm4Utils.encryptCbcPadding(BaseConvertUtils.hexToBytes((String)hexKey), BaseConvertUtils.hexToBytes((String)iv), data);
        return BaseConvertUtils.hexBytesToString((byte[])bytes);
    }

    public static byte[] encryptCbcPadding(byte[] bytesKey, byte[] bytesIv, String data) {
        try {
            Cipher cipher = Sm4Utils.generateCbcCipher(1, bytesKey, bytesIv);
            return cipher.doFinal(data.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception exception) {
            throw new ToolboxException(exception.getMessage());
        }
    }

    public static String decryptCbcPadding(String hexKey, String iv, String cipherText) {
        return Sm4Utils.decryptCbcPadding(BaseConvertUtils.hexToBytes((String)hexKey), BaseConvertUtils.hexToBytes((String)iv), BaseConvertUtils.hexToBytes((String)cipherText));
    }

    public static String decryptCbcPadding(byte[] keyBytes, byte[] iv, byte[] cipherText) {
        try {
            Cipher cipher = Sm4Utils.generateCbcCipher(2, keyBytes, iv);
            byte[] decryptBytes = cipher.doFinal(cipherText);
            return new String(decryptBytes);
        }
        catch (Exception exception) {
            throw new ToolboxException(exception.getMessage());
        }
    }

    private static Cipher generateEcbCipher(int mode, byte[] key) {
        return Sm4Utils.generateEcbCipher(Sm4Enum.ALGORITHM_NAME_ECB_PKCS5_PADDING.getCode(), mode, key);
    }

    private static Cipher generateEcbCipher(String transformation, int mode, byte[] key) {
        try {
            Cipher cipher = Cipher.getInstance(transformation, "BC");
            SecretKeySpec sm4Key = new SecretKeySpec(key, Sm4Enum.ALGORITHM_NAME.getCode());
            cipher.init(mode, sm4Key);
            return cipher;
        }
        catch (Exception exception) {
            throw new ToolboxException(exception.getMessage());
        }
    }

    private static Cipher generateCbcCipher(int mode, byte[] key, byte[] iv) {
        try {
            Cipher cipher = Cipher.getInstance(Sm4Enum.ALGORITHM_NAME_CBC_PADDING.getCode(), "BC");
            SecretKeySpec sm4Key = new SecretKeySpec(key, Sm4Enum.ALGORITHM_NAME.getCode());
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            cipher.init(mode, (Key)sm4Key, ivParameterSpec);
            return cipher;
        }
        catch (Exception exception) {
            throw new ToolboxException(exception.getMessage());
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

