/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.http;

import com.github.hugh.json.gson.JsonObjectUtils;
import com.github.hugh.json.gson.JsonObjects;
import com.github.hugh.util.EmptyUtils;
import com.github.hugh.util.StringUtils;
import com.google.gson.JsonElement;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class UrlUtils {
    public static <T> String urlParam(String url, T data) {
        if (EmptyUtils.isEmpty((Object)url)) {
            return "";
        }
        String last = ((String)url).substring(((String)url).length() - 1);
        if (!"?".equals(last)) {
            url = (String)url + "?";
        }
        String params = UrlUtils.jsonParse(data);
        url = (String)url + params;
        return url;
    }

    public static <T> String jsonParse(T json) {
        if (json == null) {
            return "";
        }
        JsonObjects jsonObjects = new JsonObjects(json);
        if (jsonObjects.isNull()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entrySet : jsonObjects.entrySet()) {
            String asString = JsonObjectUtils.getAsString((JsonElement)((JsonElement)entrySet.getValue()));
            if (asString == null) {
                asString = "";
            }
            String value = URLEncoder.encode(asString, StandardCharsets.UTF_8);
            stringBuilder.append((String)entrySet.getKey()).append("=").append(value).append("&");
        }
        return StringUtils.trimLastPlace((StringBuilder)stringBuilder);
    }
}

