/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.http.builder;

import com.github.hugh.http.UrlUtils;
import com.github.hugh.http.builder.OkHttpsResponse;
import com.github.hugh.http.constant.MediaTypes;
import com.github.hugh.http.constant.OkHttpCode;
import com.github.hugh.http.exception.ToolboxHttpException;
import com.github.hugh.http.model.FileFrom;
import com.github.hugh.json.gson.GsonUtils;
import com.github.hugh.json.gson.Jsons;
import com.github.hugh.util.EmptyUtils;
import com.github.hugh.util.ListUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class OkHttps {
    private static final int TIME_OUT = 10;
    private String url;
    private Object body;
    private long time;
    private Map<String, String> header;
    private int connectTimeout;
    private int readTimeout;
    private int writeTimeout;
    private boolean isSendCookies = false;
    private List<FileFrom> fileFrom;
    private OkHttpClient okHttpClient;
    private ConnectionPool connectionPool;
    private Map<String, Object> params;
    private static final ConnectionPool defaultConnectionPool = new ConnectionPool(5, 60L, TimeUnit.SECONDS);
    public static final OkHttpClient cookieClient = new OkHttpClient.Builder().cookieJar(new CookieJar(){

        public void saveFromResponse(@NotNull HttpUrl httpUrl, @NotNull List<Cookie> list) {
            OkHttpCode.COOKIE_STORE.put(httpUrl.host(), list);
        }

        @NotNull
        public List<Cookie> loadForRequest(@NotNull HttpUrl httpUrl) {
            ArrayList cookies = OkHttpCode.COOKIE_STORE.get(httpUrl.host());
            return cookies == null ? new ArrayList() : cookies;
        }
    }).connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).build();

    public OkHttps setUrl(String url) {
        this.url = url;
        return this;
    }

    public OkHttps setBody(Object body) {
        this.body = body;
        return this;
    }

    public OkHttps setHeader(Map<String, String> header) {
        this.header = header;
        return this;
    }

    public OkHttps setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public OkHttps setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public OkHttps setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    public OkHttps sendCookie() {
        this.isSendCookies = true;
        return this;
    }

    public OkHttps setFileFrom(FileFrom fileFrom) {
        this.fileFrom = Collections.singletonList(fileFrom);
        return this;
    }

    public OkHttps setFileFrom(List<FileFrom> fileNameList) {
        this.fileFrom = fileNameList;
        return this;
    }

    public OkHttps setOkHttpClient(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
        return this;
    }

    public OkHttps setConnectionPool(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
        return this;
    }

    public OkHttps setParam(String key, Object value) {
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        this.params.put(key, value);
        return this;
    }

    private void setBodyFromParams() {
        if (this.params != null) {
            this.body = this.params;
        }
    }

    public static OkHttps url(String url) {
        return new OkHttps().setUrl(url);
    }

    public OkHttpsResponse doGet() throws IOException {
        byte[] result;
        this.verifyUrlEmpty();
        this.setBodyFromParams();
        this.url = UrlUtils.urlParam(this.url, this.body);
        Request.Builder request = new Request.Builder().url(this.url);
        if (this.header != null) {
            Headers headers = Headers.of(this.header);
            request.headers(headers);
        }
        if (this.isSendCookies) {
            result = this.send(request.build(), cookieClient);
        } else {
            this.initOkHttpClient();
            result = this.send(request.build(), this.okHttpClient);
        }
        return new OkHttpsResponse(result);
    }

    private void initOkHttpClient() {
        if (this.okHttpClient == null) {
            OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder();
            okHttpClientBuilder.connectTimeout(this.connectTimeout > 0 ? (long)this.connectTimeout : 10L, TimeUnit.SECONDS);
            okHttpClientBuilder.readTimeout(this.readTimeout > 0 ? (long)this.readTimeout : 10L, TimeUnit.SECONDS);
            okHttpClientBuilder.writeTimeout(this.writeTimeout > 0 ? (long)this.writeTimeout : 10L, TimeUnit.SECONDS);
            if (this.connectionPool == null) {
                okHttpClientBuilder.connectionPool(defaultConnectionPool);
            }
            this.okHttpClient = okHttpClientBuilder.build();
        }
    }

    public OkHttpsResponse doPostForm() throws IOException {
        this.verifyUrlEmpty();
        this.setBodyFromParams();
        String paramsStr = UrlUtils.jsonParse(this.body);
        if (this.isSendCookies) {
            return this.doPost(MediaTypes.APPLICATION_FORM_URLENCODED, paramsStr, cookieClient);
        }
        this.initOkHttpClient();
        return this.doPost(MediaTypes.APPLICATION_FORM_URLENCODED, paramsStr, this.okHttpClient);
    }

    public OkHttpsResponse doPostJson() throws IOException {
        this.verifyUrlEmpty();
        this.setBodyFromParams();
        if (this.isSendCookies) {
            this.okHttpClient = cookieClient;
        } else {
            this.initOkHttpClient();
        }
        if (this.body == null) {
            return this.doPost(MediaTypes.APPLICATION_JSON_UTF8, "", this.okHttpClient);
        }
        if (this.body instanceof String) {
            return this.doPost(MediaTypes.APPLICATION_JSON_UTF8, String.valueOf(this.body), this.okHttpClient);
        }
        return this.doPost(MediaTypes.APPLICATION_JSON_UTF8, GsonUtils.toJson((Object)this.body), this.okHttpClient);
    }

    private OkHttpsResponse doPost(MediaType mediaType, String body, OkHttpClient okHttpClient) throws IOException {
        RequestBody requestBody = RequestBody.create((MediaType)mediaType, (String)body);
        Request.Builder request = new Request.Builder().url(this.url).post(requestBody);
        if (this.header != null) {
            Headers headers = Headers.of(this.header);
            request.headers(headers);
        }
        byte[] result = this.send(request.build(), okHttpClient);
        return new OkHttpsResponse(result);
    }

    public <K, V> OkHttpsResponse uploadFile() throws IOException {
        MultipartBody.Builder requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM);
        if (EmptyUtils.isNotEmpty((Object)this.body)) {
            Map params = new Jsons(this.body).toMap();
            for (Map.Entry entry : params.entrySet()) {
                requestBody.addFormDataPart(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            }
        }
        if (ListUtils.isEmpty(this.fileFrom)) {
            throw new ToolboxHttpException("file is null");
        }
        for (FileFrom file : this.fileFrom) {
            requestBody.addFormDataPart(file.getKey(), file.getName(), this.setFileParam(file));
        }
        Request request = new Request.Builder().url(this.url).post((RequestBody)requestBody.build()).build();
        if (this.isSendCookies) {
            this.okHttpClient = cookieClient;
        } else {
            this.initOkHttpClient();
        }
        byte[] result = this.send(request, this.okHttpClient);
        return new OkHttpsResponse(result);
    }

    private RequestBody setFileParam(FileFrom file) {
        File uploadFile;
        if (EmptyUtils.isEmpty((Object)file.getKey())) {
            throw new ToolboxHttpException("upload file key is null");
        }
        if (file.getFile() == null) {
            this.isFilePathEmpty(file.getPath());
            uploadFile = new File(file.getPath());
        } else {
            uploadFile = file.getFile();
        }
        return RequestBody.create((MediaType)file.getFileMediaType(), (File)uploadFile);
    }

    private void verifyUrlEmpty() {
        if (EmptyUtils.isEmpty((Object)this.url)) {
            throw new ToolboxHttpException("url is null");
        }
    }

    private void isFilePathEmpty(String path) {
        if (EmptyUtils.isEmpty((Object)path)) {
            throw new ToolboxHttpException("file path is null");
        }
    }

    private byte[] send(Request request, OkHttpClient okHttpClient) throws IOException {
        try (Response response = okHttpClient.newCall(request).execute();){
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                throw new ToolboxHttpException("result params is null ");
            }
            byte[] byArray = responseBody.bytes();
            return byArray;
        }
    }

    public static OkHttpsBuilder builder() {
        return new OkHttpsBuilder();
    }

    public String getUrl() {
        return this.url;
    }

    public Object getBody() {
        return this.body;
    }

    public long getTime() {
        return this.time;
    }

    public Map<String, String> getHeader() {
        return this.header;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public boolean isSendCookies() {
        return this.isSendCookies;
    }

    public List<FileFrom> getFileFrom() {
        return this.fileFrom;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void setSendCookies(boolean isSendCookies) {
        this.isSendCookies = isSendCookies;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OkHttps)) {
            return false;
        }
        OkHttps other = (OkHttps)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTime() != other.getTime()) {
            return false;
        }
        if (this.getConnectTimeout() != other.getConnectTimeout()) {
            return false;
        }
        if (this.getReadTimeout() != other.getReadTimeout()) {
            return false;
        }
        if (this.getWriteTimeout() != other.getWriteTimeout()) {
            return false;
        }
        if (this.isSendCookies() != other.isSendCookies()) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        Object this$body = this.getBody();
        Object other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        Map<String, String> this$header = this.getHeader();
        Map<String, String> other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        List<FileFrom> this$fileFrom = this.getFileFrom();
        List<FileFrom> other$fileFrom = other.getFileFrom();
        if (this$fileFrom == null ? other$fileFrom != null : !((Object)this$fileFrom).equals(other$fileFrom)) {
            return false;
        }
        OkHttpClient this$okHttpClient = this.getOkHttpClient();
        OkHttpClient other$okHttpClient = other.getOkHttpClient();
        if (this$okHttpClient == null ? other$okHttpClient != null : !this$okHttpClient.equals(other$okHttpClient)) {
            return false;
        }
        ConnectionPool this$connectionPool = this.getConnectionPool();
        ConnectionPool other$connectionPool = other.getConnectionPool();
        if (this$connectionPool == null ? other$connectionPool != null : !this$connectionPool.equals(other$connectionPool)) {
            return false;
        }
        Map<String, Object> this$params = this.getParams();
        Map<String, Object> other$params = other.getParams();
        return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OkHttps;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $time = this.getTime();
        result = result * 59 + (int)($time >>> 32 ^ $time);
        result = result * 59 + this.getConnectTimeout();
        result = result * 59 + this.getReadTimeout();
        result = result * 59 + this.getWriteTimeout();
        result = result * 59 + (this.isSendCookies() ? 79 : 97);
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        Object $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        Map<String, String> $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        List<FileFrom> $fileFrom = this.getFileFrom();
        result = result * 59 + ($fileFrom == null ? 43 : ((Object)$fileFrom).hashCode());
        OkHttpClient $okHttpClient = this.getOkHttpClient();
        result = result * 59 + ($okHttpClient == null ? 43 : $okHttpClient.hashCode());
        ConnectionPool $connectionPool = this.getConnectionPool();
        result = result * 59 + ($connectionPool == null ? 43 : $connectionPool.hashCode());
        Map<String, Object> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        return result;
    }

    public String toString() {
        return "OkHttps(url=" + this.getUrl() + ", body=" + this.getBody() + ", time=" + this.getTime() + ", header=" + this.getHeader() + ", connectTimeout=" + this.getConnectTimeout() + ", readTimeout=" + this.getReadTimeout() + ", writeTimeout=" + this.getWriteTimeout() + ", isSendCookies=" + this.isSendCookies() + ", fileFrom=" + this.getFileFrom() + ", okHttpClient=" + this.getOkHttpClient() + ", connectionPool=" + this.getConnectionPool() + ", params=" + this.getParams() + ")";
    }

    public OkHttps(String url, Object body, long time, Map<String, String> header, int connectTimeout, int readTimeout, int writeTimeout, boolean isSendCookies, List<FileFrom> fileFrom, OkHttpClient okHttpClient, ConnectionPool connectionPool, Map<String, Object> params) {
        this.url = url;
        this.body = body;
        this.time = time;
        this.header = header;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.writeTimeout = writeTimeout;
        this.isSendCookies = isSendCookies;
        this.fileFrom = fileFrom;
        this.okHttpClient = okHttpClient;
        this.connectionPool = connectionPool;
        this.params = params;
    }

    public OkHttps() {
    }

    public static class OkHttpsBuilder {
        private String url;
        private Object body;
        private long time;
        private Map<String, String> header;
        private int connectTimeout;
        private int readTimeout;
        private int writeTimeout;
        private boolean isSendCookies;
        private List<FileFrom> fileFrom;
        private OkHttpClient okHttpClient;
        private ConnectionPool connectionPool;
        private Map<String, Object> params;

        OkHttpsBuilder() {
        }

        public OkHttpsBuilder url(String url) {
            this.url = url;
            return this;
        }

        public OkHttpsBuilder body(Object body) {
            this.body = body;
            return this;
        }

        public OkHttpsBuilder time(long time) {
            this.time = time;
            return this;
        }

        public OkHttpsBuilder header(Map<String, String> header) {
            this.header = header;
            return this;
        }

        public OkHttpsBuilder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public OkHttpsBuilder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public OkHttpsBuilder writeTimeout(int writeTimeout) {
            this.writeTimeout = writeTimeout;
            return this;
        }

        public OkHttpsBuilder isSendCookies(boolean isSendCookies) {
            this.isSendCookies = isSendCookies;
            return this;
        }

        public OkHttpsBuilder fileFrom(List<FileFrom> fileFrom) {
            this.fileFrom = fileFrom;
            return this;
        }

        public OkHttpsBuilder okHttpClient(OkHttpClient okHttpClient) {
            this.okHttpClient = okHttpClient;
            return this;
        }

        public OkHttpsBuilder connectionPool(ConnectionPool connectionPool) {
            this.connectionPool = connectionPool;
            return this;
        }

        public OkHttpsBuilder params(Map<String, Object> params) {
            this.params = params;
            return this;
        }

        public OkHttps build() {
            return new OkHttps(this.url, this.body, this.time, this.header, this.connectTimeout, this.readTimeout, this.writeTimeout, this.isSendCookies, this.fileFrom, this.okHttpClient, this.connectionPool, this.params);
        }

        public String toString() {
            return "OkHttps.OkHttpsBuilder(url=" + this.url + ", body=" + this.body + ", time=" + this.time + ", header=" + this.header + ", connectTimeout=" + this.connectTimeout + ", readTimeout=" + this.readTimeout + ", writeTimeout=" + this.writeTimeout + ", isSendCookies=" + this.isSendCookies + ", fileFrom=" + this.fileFrom + ", okHttpClient=" + this.okHttpClient + ", connectionPool=" + this.connectionPool + ", params=" + this.params + ")";
        }
    }
}

