/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.http.builder;

import com.github.hugh.crypto.Md5Utils;
import com.github.hugh.json.gson.GsonUtils;
import com.github.hugh.json.gson.Jsons;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpsResponse {
    private static final Logger log = LoggerFactory.getLogger(OkHttpsResponse.class);
    private final String message;
    private final byte[] bytes;
    private String url;
    private String contentType;
    private int responseCode;

    public OkHttpsResponse(byte[] result, String url, String contentType, int responseCode) {
        this.bytes = result;
        this.message = new String(result);
        this.url = url;
        this.contentType = contentType;
        this.responseCode = responseCode;
    }

    public <T> T fromJson(Class<T> clazz) {
        if (this.isErrorResponse()) {
            return null;
        }
        return (T)GsonUtils.fromJson((Object)this.message, clazz);
    }

    public String getMessage() {
        return this.message;
    }

    public Jsons toJsons() {
        if (this.isErrorResponse()) {
            return null;
        }
        return new Jsons((Object)this.message);
    }

    public <T> List<T> toList(Class<T> clazz) {
        if (this.isErrorResponse()) {
            return null;
        }
        return GsonUtils.toArrayList((String)this.message, clazz);
    }

    public String md5() {
        return Md5Utils.encryptBytes((byte[])this.bytes);
    }

    public boolean is404() {
        return this.responseCode == 404;
    }

    public boolean is200() {
        return this.responseCode == 200;
    }

    public boolean is400() {
        return this.responseCode == 400;
    }

    public boolean is401() {
        return this.responseCode == 401;
    }

    public boolean is403() {
        return this.responseCode == 403;
    }

    public boolean is500() {
        return this.responseCode == 500;
    }

    public boolean is502() {
        return this.responseCode == 502;
    }

    public boolean is503() {
        return this.responseCode == 503;
    }

    public boolean is504() {
        return this.responseCode == 504;
    }

    private boolean isErrorResponse() {
        if (this.is404()) {
            log.error("\u8bf7\u6c42\u63a5\u53e3\u54cd\u5e94404\uff0cURL\uff1a{}\uff0c\u54cd\u5e94\u5185\u5bb9\uff1a{}", (Object)this.url, (Object)this.message);
            return true;
        }
        if (GsonUtils.isNotJsonValid((String)this.message)) {
            log.error("\u8bf7\u6c42\u63a5\u53e3\u8fd4\u56de\u975e\u6cd5json\u5b57\u7b26\u4e32\uff0cURL\uff1a{}\uff0c\u54cd\u5e94\u5185\u5bb9\uff1a{}", (Object)this.url, (Object)this.message);
            return true;
        }
        return false;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getUrl() {
        return this.url;
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getResponseCode() {
        return this.responseCode;
    }
}

