/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.mongodb;

import com.github.hugh.mongodb.exception.ToolboxMongoException;
import com.github.hugh.util.ListUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.schema.JsonSchemaObject;

public class MongoQuery {
    private final Query query = new Query();

    public static MongoQuery on() {
        return new MongoQuery();
    }

    public MongoQuery where(String key, Object value) {
        this.query.addCriteria((CriteriaDefinition)Criteria.where((String)key).is(value));
        return this;
    }

    public MongoQuery or(String key, Object value) {
        this.or((List<String>)Lists.newArrayList((Object[])new String[]{key}), Lists.newArrayList((Object[])new Object[]{value}));
        return this;
    }

    public MongoQuery or(List<String> keys, Object value) {
        ArrayList<Criteria> criterias = new ArrayList<Criteria>();
        for (String key : keys) {
            criterias.add(Criteria.where((String)key).is(value));
        }
        Criteria orCriteria = new Criteria().orOperator(criterias.toArray(new Criteria[0]));
        this.query.addCriteria((CriteriaDefinition)orCriteria.type(new JsonSchemaObject.Type[]{JsonSchemaObject.Type.objectType()}));
        return this;
    }

    public MongoQuery or(List<String> keys, List<Object> values) {
        if (ListUtils.isEmpty(keys) || ListUtils.isEmpty(values)) {
            throw new ToolboxMongoException("keys\u548cvalues\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<Criteria> criterias = new ArrayList<Criteria>();
        for (int i = 0; i < Math.min(keys.size(), values.size()); ++i) {
            String k = keys.get(i);
            Object v = values.get(i);
            criterias.add(Criteria.where((String)k).is(v));
        }
        Criteria orCriteria = new Criteria().orOperator(criterias.toArray(new Criteria[0]));
        this.query.addCriteria((CriteriaDefinition)orCriteria);
        return this;
    }

    public MongoQuery likeIgnoreCase(String key, String value) {
        this.query.addCriteria((CriteriaDefinition)Criteria.where((String)key).regex(".*" + value + ".*", "i"));
        return this;
    }

    public MongoQuery like(String key, String value) {
        this.query.addCriteria((CriteriaDefinition)Criteria.where((String)key).regex(".*" + value + ".*"));
        return this;
    }

    public MongoQuery regex(String key, String regex) {
        this.query.addCriteria((CriteriaDefinition)Criteria.where((String)key).regex(regex));
        return this;
    }

    public MongoQuery orderBy(String key, String value) {
        Sort.Direction direction = value.equalsIgnoreCase(Sort.Direction.ASC.toString()) ? Sort.Direction.ASC : Sort.Direction.DESC;
        this.query.with(Sort.by((Sort.Order[])new Sort.Order[]{new Sort.Order(direction, key)}));
        return this;
    }

    public MongoQuery orderByDesc(String key) {
        this.orderBy(key, Sort.Direction.DESC.toString());
        return this;
    }

    public MongoQuery orderByAsc(String key) {
        this.orderBy(key, Sort.Direction.ASC.toString());
        return this;
    }

    public Query query() {
        return this.query;
    }

    public MongoQuery page(int page, int size) {
        int currentPage = page > 0 ? page - 1 : 0;
        this.query.with((Pageable)PageRequest.of((int)currentPage, (int)size));
        return this;
    }

    public MongoQuery in(String key, Object ... values) {
        this.in(key, Arrays.asList(values));
        return this;
    }

    public MongoQuery in(String key, Collection<?> values) {
        this.query.addCriteria((CriteriaDefinition)Criteria.where((String)key).in(values));
        return this;
    }

    public MongoQuery gt(String key, Object value) {
        this.query.addCriteria((CriteriaDefinition)Criteria.where((String)key).gt(value));
        return this;
    }

    public MongoQuery gte(String key, Object value) {
        this.query.addCriteria((CriteriaDefinition)Criteria.where((String)key).gte(value));
        return this;
    }

    public MongoQuery lt(String key, Object value) {
        this.query.addCriteria((CriteriaDefinition)Criteria.where((String)key).lt(value));
        return this;
    }

    public MongoQuery lte(String key, Object value) {
        this.query.addCriteria((CriteriaDefinition)Criteria.where((String)key).lte(value));
        return this;
    }

    public MongoQuery gteAndLte(String key, Object gteValue, Object lteValue) {
        Criteria criteria = new Criteria().andOperator(new Criteria[]{Criteria.where((String)key).lte(lteValue), Criteria.where((String)key).gte(gteValue)});
        this.query.addCriteria((CriteriaDefinition)criteria);
        return this;
    }

    public MongoQuery gtAndLt(String key, Object gteValue, Object lteValue) {
        Criteria criteria = new Criteria().andOperator(new Criteria[]{Criteria.where((String)key).lt(lteValue), Criteria.where((String)key).gt(gteValue)});
        this.query.addCriteria((CriteriaDefinition)criteria);
        return this;
    }

    public MongoQuery isBlank(String key) {
        this.query.addCriteria((CriteriaDefinition)Criteria.where((String)key).is((Object)""));
        return this;
    }

    public MongoQuery isEmpty(String key) {
        this.query.addCriteria((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)key).is((Object)""), Criteria.where((String)key).isNull()}));
        return this;
    }
}

