/*
 * Decompiled with CFR 0.152.
 */
package com.github.hugh.mongodb;

import com.github.hugh.constant.QueryCode;
import com.github.hugh.mongodb.MongoQuery;
import com.github.hugh.util.DateUtils;
import com.github.hugh.util.EmptyUtils;
import com.github.hugh.util.EntityUtils;
import com.github.hugh.util.ListUtils;
import com.github.hugh.util.MapUtils;
import com.github.hugh.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.data.mongodb.core.query.Query;

public class RequestQuery {
    private static Map<String, Boolean> existMap;
    private static final String GE = "_ge";
    private static final String LE = "le";
    private static final String UNDERLINE_LE = "_le";
    private static final String LIKE = "_like";
    private static final String IN_FIELD_NAME = "_in";
    private static final String OR_FIELD_NAME = "_or";
    private static final String DATE = "date";
    private static final String SORT = "sort";
    private static final String ORDER = "order";
    private static final String START_DATE = "startDate";
    private static final String END_DATE = "endDate";

    private RequestQuery() {
    }

    public static <K, V> Query createQuery(Map<K, V> params) {
        return RequestQuery.create(params).query();
    }

    public static <K, V> Query createPageQuery(Map<K, V> params) {
        return RequestQuery.createPage(params).query();
    }

    public static <K, V> MongoQuery createPage(Map<K, V> params) {
        if (params == null) {
            throw new NullPointerException();
        }
        Map kvMap = (Map)EntityUtils.deepClone(params);
        Object page = kvMap.remove(QueryCode.Lowercase.PAGE);
        Object size = kvMap.remove(QueryCode.Lowercase.SIZE);
        MongoQuery mongoQuery = RequestQuery.create(kvMap);
        RequestQuery.page(page, size, mongoQuery);
        return mongoQuery;
    }

    public static <K, V> MongoQuery create(Map<K, V> params) {
        if (MapUtils.isEmpty(params)) {
            return new MongoQuery();
        }
        MongoQuery mongoQuery = new MongoQuery();
        Map<String, Object> modifiedMap = params.entrySet().stream().collect(Collectors.toMap(entry -> RequestQuery.modifyKey(String.valueOf(entry.getKey())), Map.Entry::getValue));
        existMap = new HashMap<String, Boolean>();
        for (Map.Entry<String, Object> entry2 : modifiedMap.entrySet()) {
            String key = String.valueOf(entry2.getKey());
            if (EmptyUtils.isEmpty((Object)entry2.getValue()) || SORT.equals(key)) continue;
            if (key.toLowerCase().endsWith(LIKE)) {
                key = StringUtils.before((String)key, (String)"_");
                mongoQuery.likeIgnoreCase(key, entry2.getValue().toString());
                continue;
            }
            if (ORDER.equals(key)) {
                mongoQuery.orderBy(String.valueOf(params.get(SORT)), String.valueOf(params.get(ORDER)));
                continue;
            }
            if (key.toLowerCase().endsWith(OR_FIELD_NAME)) {
                key = StringUtils.before((String)key, (String)"_");
                mongoQuery.or((List<String>)ListUtils.guavaStringToList((String)key, (String)"_"), entry2.getValue());
                continue;
            }
            if (key.toLowerCase().endsWith(IN_FIELD_NAME)) {
                key = StringUtils.before((String)key, (String)"_");
                List objects = ListUtils.guavaStringToList((String)entry2.getValue().toString());
                mongoQuery.in(key, objects);
                continue;
            }
            if (key.toLowerCase().endsWith(GE)) {
                RequestQuery.processGteAndLte(modifiedMap, key, entry2.getValue(), mongoQuery, StringUtils.before((String)key, (String)"_") + UNDERLINE_LE, true);
                continue;
            }
            if (key.toLowerCase().endsWith(UNDERLINE_LE)) {
                RequestQuery.processGteAndLte(modifiedMap, key, entry2.getValue(), mongoQuery, StringUtils.before((String)key, (String)"_") + GE, false);
                continue;
            }
            mongoQuery.where(key, entry2.getValue());
        }
        return mongoQuery;
    }

    public static void page(Object page, Object size, MongoQuery mongoQuery) {
        if (EmptyUtils.isNotEmpty((Object)page) && EmptyUtils.isNotEmpty((Object)size)) {
            mongoQuery.page(Integer.parseInt(String.valueOf(page)), Integer.parseInt(String.valueOf(size)));
        }
    }

    private static String modifyKey(String key) {
        if (START_DATE.equals(key)) {
            return QueryCode.Lowercase.CREATE_DATE + GE;
        }
        if (END_DATE.equals(key)) {
            return QueryCode.Lowercase.CREATE_DATE + UNDERLINE_LE;
        }
        return key;
    }

    public static void processGteAndLte(Map params, String key, Object entryValue, MongoQuery mongoQuery, String key2, boolean gteFlag) {
        if (Boolean.TRUE.equals(existMap.get(key))) {
            return;
        }
        Object kye2Value = params.get(key2);
        if (RequestQuery.existAndIsNotEmpty(params.containsKey(key2), kye2Value)) {
            RequestQuery.handleExistParams(key, entryValue, key2, kye2Value, mongoQuery);
        } else {
            RequestQuery.handleNonExistParams(key, entryValue, mongoQuery, gteFlag);
        }
    }

    private static void handleExistParams(String key, Object keyValue, String key2, Object key2Value, MongoQuery mongoQuery) {
        if ((key = StringUtils.before((String)key, (String)"_")).toLowerCase().contains(DATE)) {
            if (key2.contains(UNDERLINE_LE)) {
                mongoQuery.gteAndLte(key, DateUtils.parse((Object)keyValue), DateUtils.parse((Object)key2Value));
            } else {
                mongoQuery.gteAndLte(key, DateUtils.parse((Object)key2Value), DateUtils.parse((Object)keyValue));
            }
        } else if (key2.contains(UNDERLINE_LE)) {
            mongoQuery.gteAndLte(key, keyValue, key2Value);
        } else {
            mongoQuery.gteAndLte(key, key2Value, keyValue);
        }
        existMap.put(key2, true);
    }

    private static void handleNonExistParams(String key, Object entryValue, MongoQuery mongoQuery, boolean gteFlag) {
        key = StringUtils.before((String)key, (String)"_");
        if (gteFlag) {
            if (key.toLowerCase().contains(DATE)) {
                mongoQuery.gte(key, DateUtils.parse((Object)entryValue));
            } else {
                mongoQuery.gte(key, entryValue);
            }
        } else if (key.toLowerCase().contains(DATE)) {
            mongoQuery.lte(key, DateUtils.parse((Object)entryValue));
        } else {
            mongoQuery.lte(key, entryValue);
        }
    }

    public static boolean existAndIsNotEmpty(boolean containsKey, Object keyValue) {
        return containsKey && EmptyUtils.isNotEmpty((Object)keyValue);
    }
}

