/*
 * Decompiled with CFR 0.152.
 */
package com.github.ichanzhar.rsql.utils;

import com.github.ichanzhar.rsql.exception.InvalidDateFormatException;
import com.github.ichanzhar.rsql.exception.InvalidEnumValueException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.ISODateTimeFormat;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0010\u0010\u0007\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0001\u0018\u00010\bJ&\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0010\u0010\u000b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0001\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u001a\u0010\r\u001a\u00020\u000e2\u0010\u0010\u000f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0001\u0018\u00010\bH\u0002J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/github/ichanzhar/rsql/utils/ArgumentConvertor;", "", "()V", "castArgument", "arg", "", "property", "javaType", "Ljava/lang/Class;", "getEnumValue", "", "enumClass", "value", "isEnumClass", "", "clazz", "parseDate", "Ljava/util/Date;", "rsql-hibernate-jpa"})
public final class ArgumentConvertor {
    public static final ArgumentConvertor INSTANCE;

    @NotNull
    public final Object castArgument(@NotNull String arg, @Nullable String property, @Nullable Class<? extends Object> javaType) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        Class<? extends Object> clazz = javaType;
        if (Intrinsics.areEqual(clazz, Integer.TYPE)) {
            String string = arg;
            boolean bl = false;
            return Integer.parseInt(string);
        }
        if (Intrinsics.areEqual(clazz, Long.TYPE)) {
            String string = arg;
            boolean bl = false;
            return Long.parseLong(string);
        }
        if (Intrinsics.areEqual(clazz, BigInteger.class)) {
            String string = arg;
            boolean bl = false;
            return new BigInteger(string);
        }
        if (Intrinsics.areEqual(clazz, Double.TYPE)) {
            String string = arg;
            boolean bl = false;
            return Double.parseDouble(string);
        }
        if (Intrinsics.areEqual(clazz, Float.TYPE)) {
            String string = arg;
            boolean bl = false;
            return Float.valueOf(Float.parseFloat(string));
        }
        if (Intrinsics.areEqual(clazz, BigDecimal.class)) {
            String string = arg;
            boolean bl = false;
            return new BigDecimal(string);
        }
        if (Intrinsics.areEqual(clazz, Character.TYPE)) {
            return Character.valueOf(arg.charAt(0));
        }
        if (Intrinsics.areEqual(clazz, Short.TYPE)) {
            String string = arg;
            boolean bl = false;
            return Short.parseShort(string);
        }
        if (Intrinsics.areEqual(clazz, Boolean.TYPE)) {
            String string = arg;
            boolean bl = false;
            return Boolean.parseBoolean(string);
        }
        if (Intrinsics.areEqual(clazz, UUID.class)) {
            UUID uUID = UUID.fromString(arg);
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"UUID.fromString(arg)");
            return uUID;
        }
        if (Intrinsics.areEqual(clazz, Timestamp.class) || Intrinsics.areEqual(clazz, Date.class)) {
            return this.parseDate(arg, property);
        }
        if (Intrinsics.areEqual(clazz, LocalDate.class)) {
            LocalDate localDate = LocalDate.parse(arg);
            Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"LocalDate.parse(arg)");
            return localDate;
        }
        if (Intrinsics.areEqual(clazz, LocalDateTime.class)) {
            LocalDateTime localDateTime = LocalDateTime.parse(arg);
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"LocalDateTime.parse(arg)");
            return localDateTime;
        }
        if (Intrinsics.areEqual(clazz, LocalTime.class)) {
            LocalTime localTime = LocalTime.parse(arg);
            Intrinsics.checkNotNullExpressionValue((Object)localTime, (String)"LocalTime.parse(arg)");
            return localTime;
        }
        if (Intrinsics.areEqual(clazz, OffsetDateTime.class)) {
            OffsetDateTime offsetDateTime = OffsetDateTime.parse(arg);
            Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"OffsetDateTime.parse(arg)");
            return offsetDateTime;
        }
        if (Intrinsics.areEqual(clazz, ZonedDateTime.class)) {
            ZonedDateTime zonedDateTime = ZonedDateTime.parse(arg);
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"ZonedDateTime.parse(arg)");
            return zonedDateTime;
        }
        if (this.isEnumClass(javaType)) {
            return this.getEnumValue(javaType, arg);
        }
        return arg;
    }

    private final boolean isEnumClass(Class<? extends Object> clazz) {
        Class<? extends Object> clazz2 = clazz;
        return clazz2 != null && clazz2.isEnum();
    }

    private final Date parseDate(String arg, String property) {
        try {
            Date date = ISODateTimeFormat.dateTimeParser().parseDateTime(arg).toDate();
            Intrinsics.checkNotNullExpressionValue((Object)date, (String)"ISODateTimeFormat.dateTi\u2026rseDateTime(arg).toDate()");
            return date;
        }
        catch (Exception exception) {
            try {
                Date date = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS").parseDateTime(arg).toDate();
                Intrinsics.checkNotNullExpressionValue((Object)date, (String)"DateTimeFormat.forPatter\u2026rseDateTime(arg).toDate()");
                return date;
            }
            catch (Exception e) {
                throw (Throwable)new InvalidDateFormatException(arg, property);
            }
        }
    }

    private final Enum<?> getEnumValue(Class<? extends Object> enumClass, String value) {
        Class<? extends Object> clazz = enumClass;
        Object object = clazz != null ? clazz.getEnumConstants() : null;
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<out kotlin.Enum<*>>");
        }
        Enum[] enumConstants = (Enum[])object;
        try {
            Enum element$iv;
            block5: {
                Enum[] $this$first$iv = enumConstants;
                boolean $i$f$first = false;
                Enum[] enumArray = $this$first$iv;
                int n = enumArray.length;
                for (int i = 0; i < n; ++i) {
                    Enum it = element$iv = enumArray[i];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.name(), (Object)value)) {
                        continue;
                    }
                    break block5;
                }
                throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
            }
            return element$iv;
        }
        catch (NoSuchElementException e) {
            throw (Throwable)new InvalidEnumValueException(enumClass, value);
        }
    }

    private ArgumentConvertor() {
    }

    static {
        ArgumentConvertor argumentConvertor;
        INSTANCE = argumentConvertor = new ArgumentConvertor();
    }
}

