/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.aspect.lifecycle;

import java.io.Serializable;
import java.util.HashMap;
import java.util.UUID;
import org.aspectj.configuration.AspectJDescriptor;
import org.aspectj.configuration.model.Aspect;
import org.aspectj.configuration.model.Configuration;
import org.aspectj.configuration.model.Expression;
import org.aspectj.configuration.model.GlobalContext;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.util.MavenLoader;
import org.aspectj.util.Utils;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;

public abstract class BaseAspectLifecycle {
    public static final String JOIN_POINT_VARIABLE = "joinPoint";
    private final Aspect aspect;
    protected final Serializable processScript;
    protected VariableResolverFactory resolverFactory = new MapVariableResolverFactory(new HashMap());

    protected BaseAspectLifecycle() {
        String aspectName = this.getClass().getName();
        Configuration configuration = AspectJDescriptor.getConfiguration();
        this.checkConfiguration(configuration);
        this.initGlobalContext(configuration);
        this.aspect = configuration.getAspect(aspectName);
        this.registerGlobalResolverContext(configuration);
        MavenLoader.loadArtifact(this.aspect.getArtifacts(), this.resolverFactory);
        Utils.executeExpression(this.aspect.getInit(), this.resolverFactory);
        this.processScript = Expression.isNotEmptyExpression(this.aspect.getProcess()) ? Utils.compileMvelExpression(this.aspect.getProcess().getExpression()) : null;
        Utils.registerDisposeExpression(this.aspect.getDispose(), this.resolverFactory);
    }

    private void checkConfiguration(Configuration configuration) {
        if (configuration == null) {
            ClassNotFoundException exception = null;
            try {
                Class<?> loadClass = BaseAspectLifecycle.class.getClassLoader().loadClass(UUID.randomUUID().toString());
            }
            catch (ClassNotFoundException e) {
                exception = e;
            }
            throw new IllegalStateException("Shared aspect configuration not found. May be class loader isolate this aspect from loaded configuration. Shared configuration class hash: " + System.identityHashCode(AspectJDescriptor.class), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initGlobalContext(Configuration configuration) {
        if (configuration.getGlobalContext() == null || configuration.getGlobalResolver() != null) return;
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            if (configuration.getGlobalResolver() != null) return;
            MavenLoader.prefetchDependencies(configuration.getAllAspects());
            if (configuration.getGlobalContext() != null) {
                MavenLoader.prefetch(configuration.getGlobalContext().getArtifacts());
            }
            GlobalContext globalContext = configuration.getGlobalContext();
            MapVariableResolverFactory globalResolver = new MapVariableResolverFactory(new HashMap());
            MavenLoader.loadArtifact(globalContext.getArtifacts(), (VariableResolverFactory)globalResolver);
            Utils.executeExpression(globalContext.getInit(), (VariableResolverFactory)globalResolver);
            Utils.registerDisposeExpression(globalContext.getDispose(), (VariableResolverFactory)globalResolver);
            configuration.setGlobalResolver((VariableResolverFactory)globalResolver);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void registerGlobalResolverContext(Configuration configuration) {
        VariableResolverFactory globalResolver = configuration.getGlobalResolver();
        if (globalResolver != null) {
            this.resolverFactory.setNextFactory(globalResolver);
        }
    }

    protected Object processAround(ProceedingJoinPoint pjp) throws Throwable {
        if (this.processScript == null) {
            return pjp.proceed();
        }
        return this.process((JoinPoint)pjp);
    }

    protected Object process(JoinPoint pjp) throws Throwable {
        if (this.processScript == null) {
            return null;
        }
        VariableResolverFactory variableResolverFactory = this.createProcessVariableResolver(pjp);
        return Utils.executeMvelExpression(this.processScript, variableResolverFactory);
    }

    protected void executeProcessWithException(JoinPoint joinPoint, Throwable exception) throws Throwable {
        if (this.processScript == null) {
            return;
        }
        VariableResolverFactory variableResolverFactory = this.createProcessVariableResolver(joinPoint);
        variableResolverFactory.createVariable("exception", (Object)exception);
        Utils.executeMvelExpression(this.processScript, variableResolverFactory);
    }

    private VariableResolverFactory createProcessVariableResolver(JoinPoint pjp) {
        MapVariableResolverFactory variableResolverFactory = new MapVariableResolverFactory();
        Utils.fillResolveParams(this.aspect.getProcess().getResultParams(), (VariableResolverFactory)variableResolverFactory);
        variableResolverFactory.createVariable(JOIN_POINT_VARIABLE, (Object)pjp);
        variableResolverFactory.setNextFactory(this.resolverFactory);
        return variableResolverFactory;
    }
}

