/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.configuration;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.aspectj.configuration.ConfigurationLoader;
import org.aspectj.configuration.model.Aspect;
import org.aspectj.configuration.model.Configuration;
import org.aspectj.util.Utils;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.templates.TemplateRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectJDescriptor {
    public static final String DEFAULT_FILTER = "ALL_ASPECT";
    private static Logger LOGGER = Logger.getLogger(AspectJDescriptor.class.getName());
    private static volatile Configuration configuration;

    public static String generate(Collection<Aspect> aspects) {
        return TemplateRuntime.eval((String)"<aspectj>\n\t<aspects>\n@foreach{aspect : aspects} \t\t<concrete-aspect name=\"@{aspect.name}\" extends=\"@{aspect.type.aspectName}\"><pointcut name=\"pointcutExpression\" expression=\"@{aspect.pointcut}\"/></concrete-aspect>\n@end{}\t</aspects>\n@if{Boolean.getBoolean(\"org.aspectj.weaver.loadtime.configuration.debug\")}\t<weaver options=\"-verbose  -showWeaveInfo\"/>\n@end{}</aspectj>\n", Collections.singletonMap("aspects", aspects)).toString();
    }

    public static URL renderConfigurationToTemporaryFile(String configurationLocation) throws IOException {
        String instanceFilter = System.getProperty("org.aspectj.weaver.loadtime.configuration.filter", DEFAULT_FILTER);
        Configuration configuration = AspectJDescriptor.loadConfiguration(configurationLocation);
        Collection<Aspect> aspects = DEFAULT_FILTER.equals(instanceFilter) ? configuration.getAllAspects() : configuration.currentAspects(Utils.checkMvelExpression(instanceFilter).toString());
        String aopXmlContent = AspectJDescriptor.generate(aspects);
        return AspectJDescriptor.writeAopXml(aopXmlContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL writeAopXml(String aopXmlContent) throws IOException {
        File aopXmlTempFile = File.createTempFile("aop", ".xml");
        if (!Boolean.getBoolean("org.aspectj.weaver.loadtime.configuration.debug")) {
            aopXmlTempFile.deleteOnExit();
        } else {
            LOGGER.info("AspectJ aop.xml descriptor: " + aopXmlTempFile.getAbsolutePath());
        }
        FileOutputStream outputStream = new FileOutputStream(aopXmlTempFile);
        try {
            IOUtils.copy((Reader)new StringReader(aopXmlContent), (OutputStream)outputStream);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        URL url = aopXmlTempFile.toURI().toURL();
        return url;
    }

    public static synchronized Configuration getConfiguration() {
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized Configuration loadConfiguration(String configurationLocation) throws IOException {
        if (configuration == null) {
            Configuration configuration;
            String configurationContent;
            LOGGER.info("Fetch configuration from " + configurationLocation);
            InputStream configStream = new URL(configurationLocation).openStream();
            try {
                configurationContent = IOUtils.toString((InputStream)configStream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)configStream);
            }
            if (configurationContent.startsWith("{")) {
                LOGGER.info("Load configuration as JSON file: configuration start with '{'");
                configuration = ConfigurationLoader.fromJson(configurationContent);
            } else {
                configuration = ConfigurationLoader.fromXml(configurationContent);
            }
            Configuration.validateConfiguration(configuration);
            AspectJDescriptor.configuration = configuration;
            OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.SAFE_REFLECTIVE);
            LOGGER.info("Shared configuration class hash: " + System.identityHashCode(AspectJDescriptor.class));
        }
        return configuration;
    }
}

