/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.configuration;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.aspectj.configuration.model.Configuration;

public class ConfigurationLoader {
    public static Configuration fromJson(String json) {
        try {
            return (Configuration)new GsonBuilder().create().fromJson(json, Configuration.class);
        }
        catch (JsonSyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Configuration fromXml(String xml) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Configuration.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            return (Configuration)jaxbUnmarshaller.unmarshal((Reader)new StringReader(xml));
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

